/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.ui.internal;

import java.util.List;
import org.eclipse.cft.server.core.internal.CloudFoundryCallback;
import org.eclipse.cft.server.core.internal.CloudFoundryPlugin;
import org.eclipse.cft.server.core.internal.CloudFoundryServer;
import org.eclipse.cft.server.core.internal.CloudServerEvent;
import org.eclipse.cft.server.core.internal.ServerEventHandler;
import org.eclipse.cft.server.core.internal.application.ModuleChangeEvent;
import org.eclipse.cft.server.core.internal.client.CloudFoundryApplicationModule;
import org.eclipse.cft.server.core.internal.client.DeploymentConfiguration;
import org.eclipse.cft.server.core.internal.debug.ApplicationDebugLauncher;
import org.eclipse.cft.server.core.internal.jrebel.CFRebelServerIntegration;
import org.eclipse.cft.server.core.internal.log.CloudLog;
import org.eclipse.cft.server.ui.internal.ApplicationDeploymentUIHandler;
import org.eclipse.cft.server.ui.internal.CFUiUtil;
import org.eclipse.cft.server.ui.internal.CloudRebelUIServerIntegration;
import org.eclipse.cft.server.ui.internal.Messages;
import org.eclipse.cft.server.ui.internal.actions.ConnectCommand;
import org.eclipse.cft.server.ui.internal.console.ConsoleManagerRegistry;
import org.eclipse.cft.server.ui.internal.console.StandardLogContentType;
import org.eclipse.cft.server.ui.internal.debug.ApplicationDebugUILauncher;
import org.eclipse.cft.server.ui.internal.wizards.CloudFoundryCredentialsWizard;
import org.eclipse.cft.server.ui.internal.wizards.DeleteServicesWizard;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class CloudFoundryUiCallback
extends CloudFoundryCallback {
    public void applicationStarted(CloudFoundryServer server, CloudFoundryApplicationModule cloudModule) {
        ServerEventHandler.getDefault().fireServerEvent((CloudServerEvent)new ModuleChangeEvent(server, 427, cloudModule.getLocalModule(), Status.OK_STATUS));
    }

    public void startApplicationConsole(CloudFoundryServer cloudServer, CloudFoundryApplicationModule cloudModule, int showIndex, IProgressMonitor monitor) {
        if (cloudModule == null || cloudModule.getApplication() == null) {
            CloudFoundryPlugin.logError((String)"No application content to display to the console while starting application in the Cloud Foundry server.");
            return;
        }
        if (showIndex < 0) {
            showIndex = 0;
        }
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)(cloudModule.getDeploymentInfo().getInstances() * 100));
        subMonitor.subTask(NLS.bind((String)Messages.CloudFoundryUiCallback_STARTING_CONSOLE, (Object)cloudModule.getDeployedApplicationName()));
        int i = 0;
        while (i < cloudModule.getDeploymentInfo().getInstances()) {
            boolean shouldClearConsole = false;
            ConsoleManagerRegistry.getConsoleManager(cloudServer.getServer()).startConsole(cloudServer, StandardLogContentType.APPLICATION_LOG, cloudModule, i, i == showIndex, shouldClearConsole, (IProgressMonitor)subMonitor.newChild(100));
            ++i;
        }
    }

    public void showCloudFoundryLogs(CloudFoundryServer cloudServer, CloudFoundryApplicationModule cloudModule, int showIndex, IProgressMonitor monitor) {
        ConsoleManagerRegistry.getConsoleManager(cloudServer.getServer()).showCloudFoundryLogs(cloudServer, cloudModule, showIndex, false, monitor);
    }

    public void printToConsole(CloudFoundryServer cloudServer, CloudFoundryApplicationModule cloudModule, String message, boolean clearConsole, boolean isError) {
        ConsoleManagerRegistry.getConsoleManager(cloudServer.getServer()).writeToStandardConsole(message, cloudServer, cloudModule, 0, clearConsole, isError);
    }

    public void trace(CloudLog log, boolean clear) {
        ConsoleManagerRegistry.getInstance().trace(log, clear);
    }

    public void showTraceView(boolean showTrace) {
        if (showTrace) {
            ConsoleManagerRegistry.getInstance().setTraceConsoleVisible();
        }
    }

    public void applicationStarting(CloudFoundryServer server, CloudFoundryApplicationModule cloudModule) {
    }

    public void deleteApplication(CloudFoundryApplicationModule cloudModule, CloudFoundryServer cloudServer) {
        this.stopApplicationConsole(cloudModule, cloudServer);
    }

    public void stopApplicationConsole(CloudFoundryApplicationModule cloudModule, CloudFoundryServer cloudServer) {
        if (cloudModule == null) {
            return;
        }
        int totalInstances = cloudModule.isDeployed() ? cloudModule.getApplication().getInstances() : 0;
        int instance = 0;
        do {
            ConsoleManagerRegistry.getConsoleManager(cloudServer.getServer()).stopConsole(cloudServer.getServer(), cloudModule, instance);
        } while (++instance < totalInstances);
    }

    public void disconnecting(CloudFoundryServer cloudServer) {
        ConsoleManagerRegistry.getConsoleManager(cloudServer.getServer()).stopConsoles();
    }

    public void getCredentials(final CloudFoundryServer server) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                CloudFoundryCredentialsWizard wizard = new CloudFoundryCredentialsWizard(server);
                WizardDialog dialog = new WizardDialog(PlatformUI.getWorkbench().getModalDialogShellProvider().getShell(), (IWizard)wizard);
                dialog.open();
            }
        });
        if (server.getUsername() == null || server.getUsername().length() == 0 || server.getPassword() == null || server.getPassword().length() == 0 || server.getUrl() == null || server.getUrl().length() == 0) {
            throw new OperationCanceledException();
        }
    }

    public DeploymentConfiguration prepareForDeployment(CloudFoundryServer server, CloudFoundryApplicationModule module, IProgressMonitor monitor) throws CoreException {
        return new ApplicationDeploymentUIHandler().prepareForDeployment(server, module, monitor);
    }

    public void deleteServices(final List<String> services, final CloudFoundryServer cloudServer) {
        if (services == null || services.isEmpty()) {
            return;
        }
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                DeleteServicesWizard wizard = new DeleteServicesWizard(cloudServer, services);
                WizardDialog dialog = new WizardDialog(Display.getCurrent().getActiveShell(), (IWizard)wizard);
                dialog.open();
            }
        });
    }

    public void displayAndLogError(final IStatus status) {
        if (status != null && status.getSeverity() == 4) {
            CloudFoundryPlugin.log((IStatus)status);
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    Shell shell = CFUiUtil.getShell();
                    if (shell != null) {
                        MessageDialog.openError((Shell)shell, (String)Messages.CloudFoundryUiCallback_ERROR_CALLBACK_TITLE, (String)status.getMessage());
                    }
                }
            });
        }
    }

    public boolean prompt(final String title, final String message) {
        final boolean[] shouldContinue = new boolean[1];
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                Shell shell = CFUiUtil.getShell();
                if (shell != null) {
                    shouldContinue[0] = MessageDialog.openConfirm((Shell)shell, (String)title, (String)message);
                }
            }
        });
        return shouldContinue[0];
    }

    public boolean question(final String title, final String message) {
        final boolean[] shouldContinue = new boolean[1];
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                Shell shell = CFUiUtil.getShell();
                if (shell != null) {
                    shouldContinue[0] = MessageDialog.openQuestion((Shell)shell, (String)title, (String)message);
                }
            }
        });
        return shouldContinue[0];
    }

    public CFRebelServerIntegration getJRebelServerIntegration() {
        CloudRebelUIServerIntegration integration = new CloudRebelUIServerIntegration();
        return integration;
    }

    public ApplicationDebugLauncher getDebugLauncher(CloudFoundryServer cloudServer) {
        return new ApplicationDebugUILauncher();
    }

    public void syncRunInUi(Runnable runnable) {
        if (runnable != null) {
            Display.getDefault().syncExec(runnable);
        }
    }

    public boolean ssoLoginUserPrompt(CloudFoundryServer cloudServer) {
        return ConnectCommand.openConnectDialog(cloudServer, (IProgressMonitor)new NullProgressMonitor());
    }
}

