/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.standalone.core.internal.application;

import org.eclipse.cft.server.core.internal.CloudFoundryPlugin;
import org.eclipse.cft.server.core.internal.CloudFoundryProjectUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.wst.common.project.facet.core.IDelegate;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;

public class StandaloneFacetHandler {
    private final IProject project;
    public static final String ID_JAVA_STANDALONE_APP_VERSION = "1.0";
    public static final String ID_MODULE_STANDALONE = "cloudfoundry.standalone.app";
    public static final IProjectFacet FACET = ProjectFacetsManager.getProjectFacet((String)"cloudfoundry.standalone.app");

    public StandaloneFacetHandler(IProject project) {
        this.project = project;
    }

    public boolean hasFacet() {
        try {
            IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)this.project);
            return facetedProject != null && facetedProject.hasProjectFacet(FACET);
        }
        catch (CoreException e) {
            CloudFoundryPlugin.log((CoreException)e);
            return false;
        }
    }

    public void addFacet(IProgressMonitor monitor) {
        if (this.canAddFacet()) {
            try {
                IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)this.project);
                if (facetedProject == null) {
                    facetedProject = ProjectFacetsManager.create((IProject)this.project, (boolean)true, (IProgressMonitor)monitor);
                }
                if (facetedProject != null) {
                    facetedProject.installProjectFacet(FACET.getDefaultVersion(), null, null);
                }
            }
            catch (CoreException e) {
                CloudFoundryPlugin.log((CoreException)e);
            }
        }
    }

    public void removeFacet() {
        if (this.hasFacet()) {
            try {
                IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)this.project);
                if (facetedProject != null) {
                    facetedProject.uninstallProjectFacet(FACET.getDefaultVersion(), null, null);
                }
            }
            catch (CoreException e) {
                CloudFoundryPlugin.log((CoreException)e);
            }
        }
    }

    public boolean canAddFacet() {
        if (this.project == null || !this.project.isAccessible() || this.hasFacet()) {
            return false;
        }
        IJavaProject javaProject = CloudFoundryProjectUtil.getJavaProject((IProject)this.project);
        return javaProject != null && javaProject.exists();
    }

    public static class CFFacetInstallDelegate
    implements IDelegate {
        public void execute(IProject project, IProjectFacetVersion fv, Object config, IProgressMonitor monitor) throws CoreException {
            if (!new StandaloneFacetHandler(project).canAddFacet()) {
                throw new CoreException(CloudFoundryPlugin.getErrorStatus((String)"Cloud Foundry Standalone Facet can only be installed on a Java project."));
            }
        }
    }

    public static class CFFacetUninstallDelegate
    implements IDelegate {
        public void execute(IProject project, IProjectFacetVersion fv, Object config, IProgressMonitor monitor) throws CoreException {
        }
    }
}

