/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.csd.identifier.ui.runnables;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.chemclipse.chromatogram.csd.identifier.peak.PeakIdentifierCSD;
import org.eclipse.chemclipse.csd.model.core.IChromatogramPeakCSD;
import org.eclipse.chemclipse.csd.model.core.selection.ChromatogramSelectionCSD;
import org.eclipse.chemclipse.csd.model.core.selection.IChromatogramSelectionCSD;
import org.eclipse.chemclipse.model.support.IRetentionTimeRange;
import org.eclipse.chemclipse.processing.core.IProcessingInfo;
import org.eclipse.chemclipse.processing.core.MessageProvider;
import org.eclipse.chemclipse.processing.ui.support.ProcessingInfoViewSupport;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;

public class PeakIdentifierRunnable
implements IRunnableWithProgress {
    private static final String DESCRIPTION = "Unidentified Peak Remover";
    private static final String IDENTIFIER_ID = "org.eclipse.chemclipse.chromatogram.csd.identifier.deleteUnidentifiedPeaks";
    private IChromatogramSelectionCSD chromatogramSelection;

    public PeakIdentifierRunnable(IChromatogramSelectionCSD chromatogramSelection) {
        this.chromatogramSelection = chromatogramSelection;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        try {
            monitor.beginTask(DESCRIPTION, -1);
            List peaks = this.chromatogramSelection.getChromatogramCSD().getPeaks((IRetentionTimeRange)this.chromatogramSelection);
            ArrayList<IChromatogramPeakCSD> peakList = new ArrayList<IChromatogramPeakCSD>();
            for (IChromatogramPeakCSD chromatogramPeak : peaks) {
                peakList.add(chromatogramPeak);
            }
            IProcessingInfo processingInfo = PeakIdentifierCSD.identify(peakList, (String)IDENTIFIER_ID, (IProgressMonitor)monitor);
            ProcessingInfoViewSupport.updateProcessingInfo((MessageProvider)processingInfo, (boolean)false);
            if (this.chromatogramSelection instanceof ChromatogramSelectionCSD) {
                ((ChromatogramSelectionCSD)this.chromatogramSelection).update(true);
            }
        }
        finally {
            monitor.done();
        }
    }
}

