/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.quantitation.supplier.chemclipse.ui.core;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.chemclipse.chromatogram.msd.quantitation.core.AbstractPeakQuantifier;
import org.eclipse.chemclipse.chromatogram.msd.quantitation.core.IPeakQuantifier;
import org.eclipse.chemclipse.chromatogram.msd.quantitation.settings.IPeakQuantifierSettings;
import org.eclipse.chemclipse.chromatogram.msd.quantitation.supplier.chemclipse.preferences.PreferenceSupplier;
import org.eclipse.chemclipse.chromatogram.msd.quantitation.supplier.chemclipse.settings.PeakDatabaseSettings;
import org.eclipse.chemclipse.chromatogram.msd.quantitation.supplier.chemclipse.ui.internal.wizards.AddPeaksWizardESTD;
import org.eclipse.chemclipse.model.core.IPeak;
import org.eclipse.chemclipse.processing.core.IProcessingInfo;
import org.eclipse.chemclipse.processing.core.ProcessingInfo;
import org.eclipse.chemclipse.progress.core.InfoType;
import org.eclipse.chemclipse.progress.core.StatusLineLogger;
import org.eclipse.chemclipse.support.ui.workbench.DisplayUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;

public class AddPeaksESTD
extends AbstractPeakQuantifier
implements IPeakQuantifier {
    private static final String DESCRIPTION = "Peaks to DB (ESTD)";

    public IProcessingInfo quantify(List<IPeak> peaks, IPeakQuantifierSettings peakQuantifierSettings, IProgressMonitor monitor) {
        ProcessingInfo processingInfo = new ProcessingInfo();
        if (peakQuantifierSettings instanceof PeakDatabaseSettings) {
            Shell shell = DisplayUtils.getShell();
            if (shell != null) {
                this.addPeaks(peaks, shell, (IProcessingInfo)processingInfo);
            } else {
                WizardRunnable wizardRunnable = new WizardRunnable((IProcessingInfo)processingInfo, peaks);
                DisplayUtils.getDisplay().syncExec((Runnable)wizardRunnable);
            }
        }
        return processingInfo;
    }

    public IProcessingInfo quantify(IPeak peak, IPeakQuantifierSettings peakQuantifierSettings, IProgressMonitor monitor) {
        ArrayList<IPeak> peaks = new ArrayList<IPeak>();
        peaks.add(peak);
        return this.quantify(peaks, peakQuantifierSettings, monitor);
    }

    public IProcessingInfo quantify(IPeak peak, IProgressMonitor monitor) {
        ArrayList<IPeak> peaks = new ArrayList<IPeak>();
        peaks.add(peak);
        PeakDatabaseSettings peakDatabaseSettings = PreferenceSupplier.getPeakDatabaseSettings();
        return this.quantify(peaks, (IPeakQuantifierSettings)peakDatabaseSettings, monitor);
    }

    public IProcessingInfo quantify(List<IPeak> peaks, IProgressMonitor monitor) {
        PeakDatabaseSettings peakDatabaseSettings = PreferenceSupplier.getPeakDatabaseSettings();
        return this.quantify(peaks, (IPeakQuantifierSettings)peakDatabaseSettings, monitor);
    }

    private void addPeaks(List<IPeak> peaks, Shell shell, IProcessingInfo processingInfo) {
        AddPeaksWizardESTD wizard = new AddPeaksWizardESTD(peaks);
        WizardDialog dialog = new WizardDialog(shell, (IWizard)wizard);
        if (dialog.open() == 0) {
            StatusLineLogger.setInfo((InfoType)InfoType.MESSAGE, (String)"Done: The peaks have been added to the quantitation table.");
            processingInfo.addErrorMessage(DESCRIPTION, "Successfully added the peaks to the database.");
        } else {
            processingInfo.addErrorMessage(DESCRIPTION, "Something went wrong to add the peaks.");
        }
    }

    private class WizardRunnable
    implements Runnable {
        private IProcessingInfo processingInfo;
        private List<IPeak> peaks;

        public WizardRunnable(IProcessingInfo processingInfo, List<IPeak> peaks) {
            this.processingInfo = processingInfo;
            this.peaks = peaks;
        }

        @Override
        public void run() {
            Shell shell = new Shell();
            shell.setSize(0, 0);
            shell.open();
            AddPeaksESTD.this.addPeaks(this.peaks, shell, this.processingInfo);
            shell.close();
        }
    }
}

