/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.process.supplier.workflows.converter;

import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.workflows.converter.ISampleQuantWriter;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.workflows.model.ISampleQuantReport;
import org.eclipse.chemclipse.chromatogram.xxd.process.supplier.workflows.model.ISampleQuantSubstance;
import org.eclipse.core.runtime.IProgressMonitor;

public class SampleQuantWriter_1200
implements ISampleQuantWriter {
    @Override
    public void write(File file, ISampleQuantReport sampleQuantReport, IProgressMonitor monitor) throws Exception {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        ZipOutputStream zipOutputStream = new ZipOutputStream(new BufferedOutputStream(fileOutputStream));
        zipOutputStream.setLevel(9);
        zipOutputStream.setMethod(8);
        this.writeVersion(zipOutputStream, monitor);
        this.writeData(zipOutputStream, sampleQuantReport, monitor);
        zipOutputStream.flush();
        zipOutputStream.close();
    }

    private void writeVersion(ZipOutputStream zipOutputStream, IProgressMonitor monitor) throws IOException {
        ZipEntry zipEntry = new ZipEntry("VERSION");
        zipOutputStream.putNextEntry(zipEntry);
        DataOutputStream dataOutputStream = new DataOutputStream(zipOutputStream);
        this.writeString(dataOutputStream, "1.2.0.0");
        dataOutputStream.flush();
        zipOutputStream.closeEntry();
    }

    private void writeData(ZipOutputStream zipOutputStream, ISampleQuantReport sampleQuantReport, IProgressMonitor monitor) throws IOException {
        ZipEntry zipEntry = new ZipEntry("DATA");
        zipOutputStream.putNextEntry(zipEntry);
        DataOutputStream dataOutputStream = new DataOutputStream(zipOutputStream);
        this.writeString(dataOutputStream, sampleQuantReport.getPathChromatogramOriginal());
        this.writeString(dataOutputStream, sampleQuantReport.getPathChromatogramEdited());
        this.writeString(dataOutputStream, sampleQuantReport.getName());
        this.writeString(dataOutputStream, sampleQuantReport.getDataName());
        this.writeString(dataOutputStream, sampleQuantReport.getDate());
        this.writeString(dataOutputStream, sampleQuantReport.getOperator());
        this.writeString(dataOutputStream, sampleQuantReport.getMiscInfo());
        List<ISampleQuantSubstance> sampleQuantSubstances = sampleQuantReport.getSampleQuantSubstances();
        dataOutputStream.writeInt(sampleQuantSubstances.size());
        for (ISampleQuantSubstance sampleQuantSubstance : sampleQuantSubstances) {
            dataOutputStream.writeInt(sampleQuantSubstance.getId());
            this.writeString(dataOutputStream, sampleQuantSubstance.getCasNumber());
            this.writeString(dataOutputStream, sampleQuantSubstance.getName());
            dataOutputStream.writeInt(sampleQuantSubstance.getMaxScan());
            dataOutputStream.writeDouble(sampleQuantSubstance.getConcentration());
            this.writeString(dataOutputStream, sampleQuantSubstance.getUnit());
            this.writeString(dataOutputStream, sampleQuantSubstance.getMisc());
            dataOutputStream.writeDouble(sampleQuantSubstance.getMinMatchQuality());
            dataOutputStream.writeDouble(sampleQuantSubstance.getMatchQuality());
            dataOutputStream.writeBoolean(sampleQuantSubstance.isValidated());
        }
        dataOutputStream.flush();
        zipOutputStream.closeEntry();
    }

    private void writeString(DataOutputStream dataOutputStream, String value) throws IOException {
        dataOutputStream.writeInt(value.length());
        dataOutputStream.writeChars(value);
    }
}

