/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.model.core;

import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import org.eclipse.chemclipse.model.core.Classifiable;
import org.eclipse.chemclipse.model.core.IIntegrationEntry;
import org.eclipse.chemclipse.model.core.IPeakModel;
import org.eclipse.chemclipse.model.core.ISignal;
import org.eclipse.chemclipse.model.core.ITargetSupplier;
import org.eclipse.chemclipse.model.core.PeakPosition;
import org.eclipse.chemclipse.model.core.PeakType;
import org.eclipse.chemclipse.model.identifier.IIdentificationTarget;
import org.eclipse.chemclipse.model.identifier.ILibraryInformation;
import org.eclipse.chemclipse.model.quantitation.IInternalStandard;
import org.eclipse.chemclipse.model.quantitation.IQuantitationEntry;
import org.eclipse.chemclipse.model.support.IIntegrationConstraints;

public interface IPeak
extends ITargetSupplier,
PeakPosition,
Classifiable,
ISignal {
    public static final Comparator<IPeak> COMPARATOR_RT_MAX = (o1, o2) -> Integer.compare(o1.getPeakModel().getRetentionTimeAtPeakMaximum(), o2.getPeakModel().getRetentionTimeAtPeakMaximum());
    public static final Comparator<IPeak> COMPARATOR_RT_START = (o1, o2) -> Integer.compare(o1.getPeakModel().getStartRetentionTime(), o2.getPeakModel().getStartRetentionTime());

    public IPeakModel getPeakModel();

    public String getModelDescription();

    public void setModelDescription(String var1);

    @Override
    public PeakType getPeakType();

    public void setPeakType(PeakType var1);

    public int getSuggestedNumberOfComponents();

    public void setSuggestedNumberOfComponents(int var1);

    public String getIntegratorDescription();

    public void setIntegratorDescription(String var1);

    public String getDetectorDescription();

    public void setDetectorDescription(String var1);

    public IIntegrationConstraints getIntegrationConstraints();

    public double getIntegratedArea();

    public void setIntegratedArea(List<? extends IIntegrationEntry> var1, String var2);

    public List<IIntegrationEntry> getIntegrationEntries();

    public void addAllIntegrationEntries(Collection<? extends IIntegrationEntry> var1);

    public void addAllIntegrationEntries(IIntegrationEntry ... var1);

    public String getQuantifierDescription();

    public void setQuantifierDescription(String var1);

    public void addQuantitationEntry(IQuantitationEntry var1);

    public void addAllQuantitationEntries(Collection<? extends IQuantitationEntry> var1);

    public void addAllQuantitationEntries(IQuantitationEntry ... var1);

    public void removeQuantitationEntry(IQuantitationEntry var1);

    public void removeQuantitationEntries(List<IQuantitationEntry> var1);

    public List<IQuantitationEntry> getQuantitationEntries();

    public void removeAllQuantitationEntries();

    public void removeAllIntegrationEntries();

    public boolean isActiveForAnalysis();

    public void setActiveForAnalysis(boolean var1);

    public List<IInternalStandard> getInternalStandards();

    public void addInternalStandard(IInternalStandard var1);

    public void addInternalStandards(List<IInternalStandard> var1);

    public void removeInternalStandard(IInternalStandard var1);

    public List<String> getQuantitationReferences();

    public void addQuantitationReference(String var1);

    public void addQuantitationReferences(List<String> var1);

    public void removeQuantitationReference(String var1);

    default public String getName() {
        String name;
        ILibraryInformation libraryInformation;
        IIdentificationTarget target = IIdentificationTarget.getBestIdentificationTarget(this.getTargets());
        if (target != null && (libraryInformation = target.getLibraryInformation()) != null && (name = libraryInformation.getName()) != null && !name.isEmpty()) {
            return name;
        }
        return null;
    }

    @Override
    default public int getPeakEnd() {
        IPeakModel peakModel = this.getPeakModel();
        return peakModel.getPeakScan(peakModel.getStopRetentionTime()).getScanNumber() - 1;
    }

    @Override
    default public int getPeakStart() {
        IPeakModel peakModel = this.getPeakModel();
        return peakModel.getPeakScan(peakModel.getStartRetentionTime()).getScanNumber() - 1;
    }

    @Override
    default public int getPeakMaximum() {
        IPeakModel peakModel = this.getPeakModel();
        return peakModel.getPeakMaximum().getScanNumber() - 1;
    }

    @Override
    default public double getX() {
        return this.getPeakModel().getRetentionTimeAtPeakMaximum();
    }

    @Override
    default public double getY() {
        IPeakModel peakModel = this.getPeakModel();
        return peakModel.getPeakAbundance() + peakModel.getBackgroundAbundance();
    }
}

