/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.model.methods;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.chemclipse.model.methods.ProcessEntry;
import org.eclipse.chemclipse.processing.methods.IProcessEntry;
import org.eclipse.chemclipse.processing.methods.ProcessEntryContainer;
import org.eclipse.chemclipse.processing.supplier.IProcessSupplier;

public class ListProcessEntryContainer
implements ProcessEntryContainer {
    private final List<IProcessEntry> entries = new ArrayList<IProcessEntry>();
    private final List<IProcessEntry> view = Collections.unmodifiableList(this.entries);
    private boolean readOnly;
    private String description;
    private String name;

    public ListProcessEntryContainer() {
        this(null);
    }

    public ListProcessEntryContainer(ProcessEntryContainer other) {
        if (other != null) {
            other.forEach(this::addProcessEntry);
        }
    }

    public Iterator<IProcessEntry> iterator() {
        return this.getEntries().iterator();
    }

    public int getNumberOfEntries() {
        return this.entries.size();
    }

    public String getDescription() {
        if (this.description == null) {
            return "";
        }
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getName() {
        if (this.name == null) {
            return "";
        }
        return this.name;
    }

    public void setName(String name) throws IllegalStateException {
        this.name = name;
    }

    public ProcessEntry createEntry() {
        return this.createEntry(null, null);
    }

    public <T> ProcessEntry createEntry(IProcessSupplier<T> supplier, T settings) {
        ProcessEntry entry = new ProcessEntry(this);
        if (supplier != null) {
            entry.setProcessorId(supplier.getId());
            entry.setName(supplier.getName());
            entry.setDescription(supplier.getDescription());
            if (settings != null) {
                try {
                    entry.setSettings(entry.getPreferences(supplier).getSerialization().toString(settings));
                }
                catch (IOException e) {
                    throw new RuntimeException("creation of setings failed", e);
                }
            }
        }
        this.getEntries().add(entry);
        return entry;
    }

    public List<IProcessEntry> getEntries() {
        if (this.readOnly) {
            return this.view;
        }
        return this.entries;
    }

    public IProcessEntry addProcessEntry(IProcessEntry processEntry) {
        ProcessEntry newEntry = new ProcessEntry(processEntry, this);
        this.getEntries().add(newEntry);
        return newEntry;
    }

    public void removeProcessEntry(IProcessEntry processEntry) {
        this.getEntries().remove(processEntry);
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }
}

