/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.model.methods;

import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.eclipse.chemclipse.model.methods.ListProcessEntryContainer;
import org.eclipse.chemclipse.processing.DataCategory;
import org.eclipse.chemclipse.processing.methods.IProcessMethod;
import org.eclipse.chemclipse.processing.methods.ProcessEntryContainer;

public class ProcessMethod
extends ListProcessEntryContainer
implements IProcessMethod {
    public static final Set<DataCategory> CHROMATOGRAPHY = Collections.unmodifiableSet(EnumSet.copyOf(Arrays.asList(DataCategory.MSD, DataCategory.CSD, DataCategory.WSD)));
    public static final Set<DataCategory> NMR = Collections.unmodifiableSet(EnumSet.copyOf(Arrays.asList(DataCategory.FID, DataCategory.NMR)));
    private String UUID = java.util.UUID.randomUUID().toString();
    private String operator;
    private String category;
    private File sourceFile;
    private final Set<DataCategory> catgories;
    private final Map<String, String> metadata = new LinkedHashMap<String, String>();

    @Deprecated
    public ProcessMethod() {
        this(CHROMATOGRAPHY);
    }

    public ProcessMethod(Set<DataCategory> categories) {
        this.catgories = Collections.unmodifiableSet(categories);
    }

    public ProcessMethod(IProcessMethod other) {
        super((ProcessEntryContainer)other);
        if (other != null) {
            this.operator = other.getOperator();
            this.setDescription(other.getDescription());
            this.category = other.getCategory();
            this.setName(other.getName());
            if (other instanceof ProcessMethod) {
                this.sourceFile = ((ProcessMethod)other).sourceFile;
            }
            this.metadata.putAll(other.getMetaData());
            this.catgories = Collections.unmodifiableSet(new HashSet(other.getDataCategories()));
            this.setReadOnly(other.isFinal());
        } else {
            this.catgories = Collections.emptySet();
        }
    }

    public String getOperator() {
        if (this.operator == null) {
            return "";
        }
        return this.operator;
    }

    public void setOperator(String operator) {
        this.operator = operator;
    }

    @Override
    public String getName() {
        String name = super.getName();
        if (name == null || name.isEmpty()) {
            if (this.sourceFile != null) {
                return this.sourceFile.getName();
            }
            return "";
        }
        return name;
    }

    public String getCategory() {
        if (this.category == null) {
            return "";
        }
        return this.category;
    }

    public void setCategory(String category) throws IllegalStateException {
        this.category = category;
    }

    public void setSourceFile(File sourceFile) {
        this.sourceFile = sourceFile;
    }

    public File getSourceFile() {
        return this.sourceFile;
    }

    public String getUUID() {
        return this.UUID;
    }

    public void setUUID(String UUID2) {
        this.UUID = UUID2;
    }

    public boolean isFinal() {
        return this.isReadOnly();
    }

    public Set<DataCategory> getDataCategories() {
        return this.catgories;
    }

    public Map<String, String> getMetaData() {
        if (this.isFinal()) {
            return Collections.unmodifiableMap(this.metadata);
        }
        return this.metadata;
    }
}

