/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.model.quantitation;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.core.IIntegrationEntry;
import org.eclipse.chemclipse.model.core.IPeak;

public class QuantitationSupport {
    private static final Logger logger = Logger.getLogger(QuantitationSupport.class);
    private IPeak peak;
    private Map<Double, Double> integratedSignals;

    public QuantitationSupport(IPeak peak) {
        this.peak = peak;
        this.integratedSignals = this.calculateIntegratedSignals();
    }

    public boolean validateTIC() {
        if (this.isTotalSignalIntegrated()) {
            return true;
        }
        String info = this.peak != null ? this.peak.toString() : "--";
        logger.warn((Object)("Quantitation: The peak integration entry doesn't match: " + info));
        return false;
    }

    public boolean validateXIC(List<Double> selectedSignals) {
        if (this.isTotalSignalIntegrated()) {
            return true;
        }
        if (this.integratedSignals.keySet().containsAll(selectedSignals)) {
            return true;
        }
        StringBuilder builder = new StringBuilder();
        builder.append("Quantitation: The peak integration entries do not match quantitation entries: ");
        builder.append(this.peak != null ? this.peak : "--");
        builder.append(" Integrated Signals: ");
        builder.append(this.integratedSignals);
        builder.append(" Selected Quantitation Signals: ");
        builder.append(selectedSignals);
        logger.warn((Object)builder.toString());
        return false;
    }

    public boolean isTotalSignalIntegrated() {
        return this.integratedSignals.size() == 1 && this.integratedSignals.containsKey(0.0);
    }

    public double getIntegrationArea(double signal) {
        Double value = this.isTotalSignalIntegrated() ? this.integratedSignals.get(0.0) : this.integratedSignals.get(signal);
        return value == null ? 0.0 : value;
    }

    private Map<Double, Double> calculateIntegratedSignals() {
        HashMap<Double, Double> integratedIons = new HashMap<Double, Double>();
        if (this.peak != null) {
            for (IIntegrationEntry integrationEntry : this.peak.getIntegrationEntries()) {
                integratedIons.put(integrationEntry.getSignal(), integrationEntry.getIntegratedArea());
            }
        }
        return integratedIons;
    }
}

