/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.numeric.equations;

import org.eclipse.chemclipse.numeric.equations.Apex;
import org.eclipse.chemclipse.numeric.equations.IEquation;

public class QuadraticEquation
implements IEquation {
    private static final long serialVersionUID = -2371137795806083758L;
    private double a;
    private double b;
    private double c;

    public QuadraticEquation(double a, double b, double c) {
        this.a = a;
        this.b = b;
        this.c = c;
    }

    public double getA() {
        return this.a;
    }

    public double getB() {
        return this.b;
    }

    public double getC() {
        return this.c;
    }

    @Override
    public double calculateX(double y) {
        return this.calculateX(y, true);
    }

    public double calculateX(double y, boolean positive) {
        double result = 0.0;
        if (this.a == 0.0) {
            return result;
        }
        double termA = -this.b / (2.0 * this.a);
        double termB = Math.sqrt(y / this.a - this.c / this.a + Math.pow(this.b / (2.0 * this.a), 2.0));
        result = positive ? termA + termB : termA - termB;
        return result;
    }

    @Override
    public double calculateY(double x) {
        double result = this.a * Math.pow(x, 2.0) + this.b * x + this.c;
        return result;
    }

    public double getApexValueForX(Apex result) {
        if (this.a == 0.0) {
            return 0.0;
        }
        double p = this.b / this.a;
        double q = this.c / this.a;
        double x = 0.0;
        switch (result) {
            case NEGATIVE: {
                x = -p / 2.0 - 0.0 * Math.sqrt(Math.abs(Math.pow(p, 2.0) - 4.0 * q));
                break;
            }
            case POSITIVE: {
                x = -p / 2.0 + 0.0 * Math.sqrt(Math.abs(Math.pow(p, 2.0) - 4.0 * q));
            }
        }
        return x;
    }

    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    public int hashCode() {
        return super.hashCode();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getName());
        builder.append("[");
        builder.append("f(x)=" + this.a + "x^2" + " + " + this.b + "x" + " + " + this.c);
        builder.append("]");
        return builder.toString();
    }
}

