/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.support.ui.swt;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.eclipse.chemclipse.rcp.ui.icons.core.ApplicationImageFactory;
import org.eclipse.chemclipse.support.ui.preferences.ToolbarPreferencePage;
import org.eclipse.chemclipse.support.ui.swt.ControlBuilder;
import org.eclipse.jface.action.AbstractGroupMarker;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.ControlContribution;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.SubContributionManager;
import org.eclipse.jface.action.SubToolBarManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.preference.PreferenceNode;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class EditorToolBar {
    private static final AtomicLong ID_SEQUENCE = new AtomicLong(System.currentTimeMillis());
    private final IToolBarManager toolBarManager;
    private final AbstractGroupMarker group;
    private final EditorToolBar parent;
    private final ConfigSection config;
    private final List<ActionContributionItem> actionContributions;
    private boolean showText = true;

    public EditorToolBar(Composite parent) {
        this(parent, 131072);
    }

    public EditorToolBar(Composite parent, int align) {
        this.parent = null;
        this.actionContributions = new ArrayList<ActionContributionItem>();
        ToolBarManager toolbarManagerSWT = new ToolBarManager(0x800040);
        this.group = null;
        ToolBar toolBar = toolbarManagerSWT.createControl(parent);
        toolBar.setLayoutData((Object)new GridData(align, 0x1000000, true, false));
        this.toolBarManager = toolbarManagerSWT;
        this.config = new ConfigSection(this);
    }

    private EditorToolBar(IToolBarManager manager, EditorToolBar parent, String groupName) {
        this.toolBarManager = manager;
        this.parent = parent;
        this.config = null;
        this.group = new GroupMarker(groupName);
        this.actionContributions = parent.actionContributions;
    }

    public boolean isShowText() {
        if (this.parent != null) {
            return this.parent.isShowText();
        }
        return this.showText;
    }

    public void setShowText(boolean showText) {
        if (this.parent != null) {
            this.parent.setShowText(showText);
        } else if (this.showText != showText) {
            this.showText = showText;
            for (ActionContributionItem item : this.actionContributions) {
                if (showText) {
                    item.setMode(ActionContributionItem.MODE_FORCE_TEXT);
                    continue;
                }
                item.setMode(0);
            }
            this.update();
        }
    }

    public void addAction(IAction action) {
        this.addContribution((IContributionItem)this.createContribution(action), false);
    }

    private void addContribution(IContributionItem item, boolean prepend) {
        if (this.group == null) {
            if (this.config != null && this.config.toolbar != null) {
                if (prepend) {
                    IContributionItem[] items = this.toolBarManager.getItems();
                    this.toolBarManager.insertBefore(items[0].getId(), item);
                } else {
                    this.toolBarManager.insertBefore(((ConfigSection)this.config).toolbar.group.getId(), item);
                }
            } else {
                IContributionItem[] items;
                if (prepend && (items = this.toolBarManager.getItems()).length > 0) {
                    this.toolBarManager.insertBefore(items[0].getId(), item);
                    return;
                }
                this.toolBarManager.add(item);
            }
        } else if (prepend) {
            this.toolBarManager.prependToGroup(this.group.getId(), item);
        } else {
            this.toolBarManager.appendToGroup(this.group.getId(), item);
        }
        this.update();
    }

    private ActionContributionItem createContribution(IAction action) {
        ActionContributionItem contributionItem = new ActionContributionItem(action);
        if (this.isShowText()) {
            contributionItem.setMode(ActionContributionItem.MODE_FORCE_TEXT);
        }
        contributionItem.setId("Action." + ID_SEQUENCE.incrementAndGet());
        this.actionContributions.add(contributionItem);
        return contributionItem;
    }

    public void setVisible(boolean visible) {
        if (this.toolBarManager instanceof SubContributionManager) {
            ((SubContributionManager)this.toolBarManager).setVisible(visible);
        } else if (this.toolBarManager instanceof ToolBarManager) {
            GridData gridData;
            ToolBar control = ((ToolBarManager)this.toolBarManager).getControl();
            control.setVisible(visible);
            Object object = control.getLayoutData();
            if (object instanceof GridData && (gridData = (GridData)control.getLayoutData()) != null) {
                gridData.exclude = !visible;
            }
            Composite parent = control.getParent();
            parent.layout(true);
            parent.redraw();
        }
        this.update();
    }

    public void createCombo(final Consumer<ComboViewer> consumer, final boolean readOnly, final int width) {
        ControlContribution contribution = new ControlContribution(UUID.randomUUID().toString()){

            protected Control createControl(Composite parent) {
                Composite composite = ControlBuilder.createContainer(parent);
                ComboViewer viewer = new ComboViewer(composite, readOnly ? 8 : 0);
                viewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
                GridData data = ControlBuilder.gridData(ControlBuilder.maximize(viewer.getControl()));
                data.verticalAlignment = 0x1000000;
                consumer.accept(viewer);
                return composite;
            }

            protected int computeWidth(Control control) {
                return width > 0 ? width : super.computeWidth(control);
            }
        };
        contribution.setId("Combo." + ID_SEQUENCE.incrementAndGet());
        this.addContribution((IContributionItem)contribution, false);
    }

    public void update() {
        this.toolBarManager.update(true);
        if (this.parent != null) {
            this.parent.update();
        }
    }

    public EditorToolBar createChild() {
        return this.createChild(false);
    }

    public EditorToolBar createChild(boolean prepend) {
        String baseName = this.group == null ? "master" : this.group.getId();
        EditorToolBar child = new EditorToolBar((IToolBarManager)new SubToolBarManager(this.toolBarManager), this, String.valueOf(baseName) + "." + ID_SEQUENCE.incrementAndGet());
        this.addContribution((IContributionItem)child.group, prepend);
        return child;
    }

    public void addSeparator() {
        Separator separator = new Separator();
        separator.setId("Separator." + ID_SEQUENCE.incrementAndGet());
        this.addContribution((IContributionItem)separator, false);
    }

    public IAction enableToolbarTextButton(final IPreferenceStore preferenceStore, final String key) {
        if (this.parent != null) {
            return this.parent.enableToolbarTextButton(preferenceStore, key);
        }
        Action action = new Action("Show Text", 2){

            public void run() {
                EditorToolBar.this.setShowText(!EditorToolBar.this.isShowText());
            }

            public void setChecked(boolean checked) {
                if (checked) {
                    this.setImageDescriptor(ApplicationImageFactory.getInstance().getImageDescriptor("org.eclipse.chemclipse.rcp.ui.icons/selected.gif", "16x16"));
                } else {
                    this.setImageDescriptor(ApplicationImageFactory.getInstance().getImageDescriptor("org.eclipse.chemclipse.rcp.ui.icons/deselected.gif", "16x16"));
                }
                if (preferenceStore != null) {
                    preferenceStore.setValue(key, checked);
                }
                super.setChecked(checked);
            }
        };
        boolean checked = this.updateShowTextByPreference(preferenceStore, key);
        action.setChecked(checked);
        this.config.getToolbar().addAction((IAction)action);
        this.update();
        return action;
    }

    private boolean updateShowTextByPreference(IPreferenceStore preferenceStore, String key) {
        boolean checked;
        if (preferenceStore != null) {
            preferenceStore.setDefault(key, true);
            checked = preferenceStore.getBoolean(key);
            this.setShowText(checked);
        } else {
            checked = this.isShowText();
        }
        return checked;
    }

    public void enableToolbarTextPage(IPreferenceStore preferenceStore, String key) {
        if (preferenceStore != null) {
            if (this.parent != null) {
                this.parent.enableToolbarTextPage(preferenceStore, key);
            } else {
                this.updateShowTextByPreference(preferenceStore, key);
                this.config.addPreferencePageContainer(new PreferencePageContainer(() -> Collections.singleton(new ToolbarPreferencePage(preferenceStore, key)), () -> {
                    boolean bl = this.updateShowTextByPreference(preferenceStore, key);
                }));
                this.update();
            }
        }
    }

    public void addPreferencePages(Supplier<Collection<? extends IPreferencePage>> pageSupplier, Runnable settingsChangedRunnable) {
        if (this.parent != null) {
            this.parent.addPreferencePages(pageSupplier, settingsChangedRunnable);
            return;
        }
        this.config.addPreferencePageContainer(new PreferencePageContainer(pageSupplier, settingsChangedRunnable));
        this.update();
    }

    public boolean isVisible() {
        if (this.toolBarManager instanceof SubContributionManager) {
            return ((SubContributionManager)this.toolBarManager).isVisible();
        }
        if (this.toolBarManager instanceof ToolBarManager) {
            return ((ToolBarManager)this.toolBarManager).getControl().isVisible();
        }
        return false;
    }

    public void clear() {
        this.toolBarManager.removeAll();
    }

    private static final class ConfigSection {
        private final List<PreferencePageContainer> preferencePages = new ArrayList<PreferencePageContainer>();
        private EditorToolBar toolbar;
        private IAction configAction;
        private final EditorToolBar parent;

        public ConfigSection(EditorToolBar editorToolBar) {
            this.parent = editorToolBar;
        }

        private void addPreferencePageContainer(PreferencePageContainer container) {
            if (this.configAction == null) {
                this.configAction = new Action("Settings", ApplicationImageFactory.getInstance().getImageDescriptor("org.eclipse.chemclipse.rcp.ui.icons/configure.gif", "16x16")){

                    public void runWithEvent(Event event) {
                        ToolItem widget = (ToolItem)event.widget;
                        PreferenceManager preferenceManager = new PreferenceManager();
                        int i = 0;
                        for (PreferencePageContainer container : preferencePages) {
                            for (IPreferencePage page : (Collection)container.supplier.get()) {
                                preferenceManager.addToRoot((IPreferenceNode)new PreferenceNode(String.valueOf(i++), page));
                            }
                        }
                        ToolBar parent = widget.getParent();
                        PreferenceDialog preferenceDialog = new PreferenceDialog(parent.getShell(), preferenceManager);
                        preferenceDialog.create();
                        preferenceDialog.getShell().setText("Settings");
                        if (preferenceDialog.open() == 0) {
                            for (PreferencePageContainer container : preferencePages) {
                                if (container.runnable == null) continue;
                                event.display.asyncExec(container.runnable);
                            }
                        }
                    }
                };
                this.getToolbar().addAction(this.configAction);
                this.getToolbar().setVisible(true);
            }
            this.preferencePages.add(container);
        }

        public EditorToolBar getToolbar() {
            if (this.toolbar == null) {
                this.toolbar = this.parent.createChild(false);
            }
            return this.toolbar;
        }
    }

    private static final class PreferencePageContainer {
        private final Supplier<Collection<? extends IPreferencePage>> supplier;
        private final Runnable runnable;

        private PreferencePageContainer(Supplier<Collection<? extends IPreferencePage>> supplier, Runnable runnable) {
            this.supplier = supplier;
            this.runnable = runnable;
        }
    }
}

