/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.support.ui.swt.columns;

import java.util.Comparator;
import java.util.function.Function;
import org.eclipse.chemclipse.support.ui.swt.columns.ColumnDefinition;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;

public class SimpleColumnDefinition<DataType, ColumnType>
implements ColumnDefinition<DataType, ColumnType> {
    private String title;
    private int width;
    private CellLabelProvider labelProvider;
    private Comparator<ColumnType> comparator;
    private Function<DataType, ColumnType> mapper;
    private Function<ColumnViewer, EditingSupport> editingSupportSupplier;
    private int style = 16384;
    private boolean resizable = true;
    private int minWidth = -1;

    public SimpleColumnDefinition(String title, int width, final Function<DataType, String> extractor) {
        this(title, width, (CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                String string = (String)extractor.apply(element);
                return string == null ? "" : string;
            }
        }, null, null);
    }

    public SimpleColumnDefinition(String title, int width, CellLabelProvider labelProvider) {
        this(title, width, labelProvider, null, null);
    }

    public SimpleColumnDefinition(String title, int width, CellLabelProvider labelProvider, Comparator<ColumnType> comparator, Function<DataType, ColumnType> mapper) {
        this.title = title;
        this.width = width;
        this.labelProvider = labelProvider;
        this.comparator = comparator;
        this.mapper = mapper;
    }

    @Override
    public ColumnType apply(DataType t) {
        if (this.mapper != null) {
            return this.mapper.apply(t);
        }
        return null;
    }

    @Override
    public CellLabelProvider getLabelProvider() {
        return this.labelProvider;
    }

    @Override
    public Comparator<ColumnType> getComparator() {
        return this.comparator;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public EditingSupport getEditingSupport(ColumnViewer columnViewer) {
        if (this.editingSupportSupplier != null) {
            return this.editingSupportSupplier.apply(columnViewer);
        }
        return ColumnDefinition.super.getEditingSupport(columnViewer);
    }

    public SimpleColumnDefinition<DataType, ColumnType> withEditingSupport(Function<ColumnViewer, EditingSupport> editingSupportSupplier) {
        this.editingSupportSupplier = editingSupportSupplier;
        return this;
    }

    @Override
    public int getStyle() {
        return this.style;
    }

    public SimpleColumnDefinition<DataType, ColumnType> withStyle(int style) {
        this.style = style;
        return this;
    }

    @Override
    public boolean isResizable() {
        return this.resizable;
    }

    public SimpleColumnDefinition<DataType, ColumnType> resizable(boolean resizable) {
        this.resizable = resizable;
        return this;
    }

    @Override
    public int getMinWidth() {
        if (this.minWidth >= 0) {
            return this.minWidth;
        }
        return ColumnDefinition.super.getMinWidth();
    }

    public SimpleColumnDefinition<DataType, ColumnType> minWidth(int minWidth) {
        this.minWidth = minWidth;
        return this;
    }
}

