/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.wsd.model.xwc;

import java.util.List;
import java.util.Optional;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.eclipse.chemclipse.wsd.model.core.selection.IChromatogramSelectionWSD;
import org.eclipse.chemclipse.wsd.model.core.support.IMarkedWavelength;
import org.eclipse.chemclipse.wsd.model.core.support.IMarkedWavelengths;
import org.eclipse.chemclipse.wsd.model.xwc.IExtractedSingleWavelengthSignals;

public interface IExtractedSingleWavelengthSignalExtractor {
    public List<IExtractedSingleWavelengthSignals> getExtractedWavelengthSignals(IChromatogramSelectionWSD var1);

    public List<IExtractedSingleWavelengthSignals> getExtractedWavelengthSignals();

    public List<IExtractedSingleWavelengthSignals> getExtractedWavelengthSignals(int var1, int var2);

    public List<IExtractedSingleWavelengthSignals> getExtractedWavelengthSignals(int var1, int var2, IMarkedWavelengths var3);

    public List<IExtractedSingleWavelengthSignals> getExtractedWavelengthSignals(IMarkedWavelengths var1);

    public Optional<IExtractedSingleWavelengthSignals> getExtractWavelengthContinuousSignal(int var1, int var2, IMarkedWavelength var3);

    public Optional<IExtractedSingleWavelengthSignals> getExtractWavelengthContinuousSignal(IMarkedWavelength var1);

    public boolean isJoinSignal();

    public void setJoinSignal(boolean var1);

    public static SortedMap<Double, SortedSet<IExtractedSingleWavelengthSignals>> sortExtractedSignals(List<IExtractedSingleWavelengthSignals> extractedSingleWavelengthSignals) {
        TreeMap<Double, SortedSet<IExtractedSingleWavelengthSignals>> sortedMap = new TreeMap<Double, SortedSet<IExtractedSingleWavelengthSignals>>();
        for (IExtractedSingleWavelengthSignals signals : extractedSingleWavelengthSignals) {
            double wavelength = signals.getWavelength();
            sortedMap.putIfAbsent(wavelength, new TreeSet((s1, s2) -> Integer.compare(s1.getStartScan(), s2.getStartScan())));
            SortedSet signalOnWavelength = (SortedSet)sortedMap.get(wavelength);
            signalOnWavelength.add(signals);
        }
        return sortedMap;
    }
}

