/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.visualization.xygraph.linearscale;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.nebula.visualization.internal.xygraph.utils.LargeNumberUtils;
import org.eclipse.nebula.visualization.xygraph.linearscale.IScaleProvider;
import org.eclipse.nebula.visualization.xygraph.linearscale.ITicksProvider;
import org.eclipse.nebula.visualization.xygraph.linearscale.Range;
import org.eclipse.swt.graphics.Font;

public class LinearScaleTicks
implements ITicksProvider {
    public static final String NAME = "DEFAULT";
    private static final String MINUS = "-";
    private static final int TICK_LABEL_GAP = 2;
    private boolean showMaxLabel = true;
    private boolean showMinLabel = true;
    private ArrayList<Double> tickLabelValues;
    private ArrayList<String> tickLabels;
    private ArrayList<Integer> tickLabelPositions;
    private ArrayList<Boolean> tickLabelVisibilities;
    private int tickLabelMaxLength;
    private int tickLabelMaxHeight;
    private int gridStepInPixel;
    private ArrayList<Integer> minorPositions;
    private IScaleProvider scale;

    private BigDecimal pow(double base, int exponent) {
        BigDecimal result = exponent >= 0 ? BigDecimal.valueOf(base).pow(exponent) : BigDecimal.ONE.divide(BigDecimal.valueOf(base).pow(-exponent));
        return result;
    }

    public LinearScaleTicks(IScaleProvider scale) {
        this.scale = scale;
        this.tickLabelValues = new ArrayList();
        this.tickLabels = new ArrayList();
        this.tickLabelPositions = new ArrayList();
        this.tickLabelVisibilities = new ArrayList();
        this.minorPositions = new ArrayList();
    }

    public int getGridStepInPixels() {
        return this.gridStepInPixel;
    }

    public int getTickLabelMaxHeight() {
        return this.tickLabelMaxHeight;
    }

    public int getTickLabelMaxLength() {
        return this.tickLabelMaxLength;
    }

    @Override
    public List<Integer> getPositions() {
        return this.tickLabelPositions;
    }

    @Override
    public List<Boolean> getVisibilities() {
        return this.tickLabelVisibilities;
    }

    @Override
    public int getPosition(int index) {
        return this.tickLabelPositions.get(index);
    }

    @Override
    public double getValue(int index) {
        return this.tickLabelValues.get(index);
    }

    @Override
    public String getLabel(int index) {
        return this.tickLabels.get(index);
    }

    @Override
    public List<String> getLabels() {
        return this.tickLabels;
    }

    @Override
    public int getLabelPosition(int index) {
        return this.tickLabelPositions.get(index);
    }

    @Override
    public boolean isVisible(int index) {
        return this.tickLabelVisibilities.get(index);
    }

    @Override
    public int getMajorCount() {
        return this.tickLabels.size();
    }

    @Override
    public int getMinorCount() {
        return this.minorPositions.size();
    }

    @Override
    public int getMinorPosition(int index) {
        return this.minorPositions.get(index);
    }

    @Override
    public int getMaxWidth() {
        return this.tickLabelMaxLength;
    }

    @Override
    public int getMaxHeight() {
        return this.tickLabelMaxHeight;
    }

    @Override
    public boolean isShowMaxLabel() {
        return this.showMaxLabel;
    }

    @Override
    public void setShowMaxLabel(boolean showMaxLabel) {
        this.showMaxLabel = showMaxLabel;
    }

    @Override
    public boolean isShowMinLabel() {
        return this.showMinLabel;
    }

    @Override
    public void setShowMinLabel(boolean showMinLabel) {
        this.showMinLabel = showMinLabel;
    }

    /*
     * Unable to fully structure code
     */
    private double getGridStep(int lengthInPixels, double min, double max) {
        block14: {
            if ((int)this.scale.getMajorGridStep() != 0) {
                return this.scale.getMajorGridStep();
            }
            if (lengthInPixels <= 0) {
                lengthInPixels = 1;
            }
            minBigger = false;
            if (min >= max) {
                if (max == min) {
                    max += 1.0;
                } else {
                    minBigger = true;
                    swap = min;
                    min = max;
                    max = swap;
                }
            }
            length = LargeNumberUtils.requireFinite(Math.abs(max - min));
            majorTickMarkStepHint = this.scale.getMajorTickMarkStepHint();
            if (majorTickMarkStepHint > (double)lengthInPixels) {
                majorTickMarkStepHint = lengthInPixels;
            }
            gridStepHint = length / (double)lengthInPixels * majorTickMarkStepHint;
            if (this.scale.isDateEnabled()) {
                temp = this.getTimeGridStep(min, max, gridStepHint);
                if (minBigger) {
                    temp = -temp;
                }
                return temp;
            }
            mantissa = gridStepHint;
            exp = 0;
            if (!(mantissa < 1.0)) ** GOTO lbl35
            if (mantissa == 0.0) break block14;
            while (mantissa < 1.0) {
                mantissa *= 10.0;
                --exp;
            }
            break block14;
lbl-1000:
            // 1 sources

            {
                mantissa /= 10.0;
                ++exp;
lbl35:
                // 2 sources

                ** while (mantissa >= 10.0)
            }
        }
        gridStep = mantissa > 7.5 ? 10.0 * Math.pow(10.0, exp) : (mantissa > 3.5 ? 5.0 * Math.pow(10.0, exp) : (mantissa > 1.5 ? 2.0 * Math.pow(10.0, exp) : Math.pow(10.0, exp)));
        if (minBigger) {
            gridStep = -gridStep;
        }
        return gridStep;
    }

    private double getTimeGridStep(double min, double max, double gridStepHint) {
        long timeStep = max - min < 1000.0 ? 10L : (max - min < 60000.0 ? 1000L : (max - min < 600000.0 ? 10000L : (max - min < 6400000.0 ? 60000L : (max - min < 4.32E7 ? 600000L : (max - min < 8.64E7 ? 1800000L : (max - min < 6.048E8 ? 3600000L : 86400000L))))));
        if (this.scale.getTimeUnit() == 13) {
            timeStep = 1000L;
        } else if (this.scale.getTimeUnit() == 12) {
            timeStep = 60000L;
        } else if (this.scale.getTimeUnit() == 11) {
            timeStep = 3600000L;
        } else if (this.scale.getTimeUnit() == 5) {
            timeStep = 86400000L;
        } else if (this.scale.getTimeUnit() == 2) {
            timeStep = 2592000000L;
        } else if (this.scale.getTimeUnit() == 1) {
            timeStep = 31536000000L;
        }
        double temp = gridStepHint + ((double)timeStep - gridStepHint % (double)timeStep);
        return temp;
    }

    private boolean hasSpaceToDraw(int previousPosition, int tickLabelPosition, String previousTickLabel, String tickLabel) {
        Dimension tickLabelSize = FigureUtilities.getTextExtents((String)tickLabel, (Font)this.scale.getFont());
        Dimension previousTickLabelSize = FigureUtilities.getTextExtents((String)previousTickLabel, (Font)this.scale.getFont());
        int interval = tickLabelPosition - previousPosition;
        int textLength = (int)(this.scale.isHorizontal() ? (double)tickLabelSize.width / 2.0 + (double)previousTickLabelSize.width / 2.0 : (double)tickLabelSize.height);
        boolean noLapOnPrevoius = true;
        boolean noLapOnEnd = true;
        if (tickLabelPosition != this.tickLabelPositions.get(this.tickLabelPositions.size() - 1)) {
            noLapOnPrevoius = interval > textLength + 2;
            Dimension endTickLabelSize = FigureUtilities.getTextExtents((String)this.tickLabels.get(this.tickLabels.size() - 1), (Font)this.scale.getFont());
            interval = this.tickLabelPositions.get(this.tickLabelPositions.size() - 1) - tickLabelPosition;
            textLength = (int)(this.scale.isHorizontal() ? (double)tickLabelSize.width / 2.0 + (double)endTickLabelSize.width / 2.0 : (double)tickLabelSize.height);
            boolean bl = noLapOnEnd = interval > textLength + 2;
        }
        return noLapOnPrevoius && noLapOnEnd;
    }

    private boolean isMajorTick(double tickValue) {
        if (!this.scale.isLogScaleEnabled()) {
            return true;
        }
        double log10 = Math.log10(tickValue);
        return log10 == Math.rint(log10);
    }

    @Override
    public String getDefaultFormatPattern(double min, double max) {
        String format = null;
        double mantissa = Math.abs(max - min);
        if (Math.abs(mantissa) > 0.1) {
            format = "############.##";
        } else {
            format = "##.##";
            while (mantissa < 1.0) {
                mantissa *= 10.0;
                format = String.valueOf(format) + "#";
            }
        }
        return format;
    }

    private void updateTickLabelForLinearScale(double min, double max, int length) {
        double gridStep = this.getGridStep(length, min, max);
        double f = LargeNumberUtils.maxMagnitude(min, max);
        double t = max / f - min / f;
        this.gridStepInPixel = (int)((double)length * (gridStep / f) / t);
        this.updateTickLabelForLinearScale(min, max, length, gridStep);
    }

    private void updateTickLabelForLinearScale(double min, double max, int length, double tickStep) {
        String lblStr;
        double zeroOclock;
        boolean minBigger = max < min;
        double firstPosition = min % tickStep <= 0.0 ? min - min % tickStep : min - min % tickStep + tickStep;
        if (this.scale.isDateEnabled() && min < (zeroOclock = firstPosition - 3600000.0)) {
            firstPosition = zeroOclock;
        }
        boolean minDateAdded = false;
        if (min > firstPosition == minBigger) {
            String lblStr2;
            this.tickLabelValues.add(min);
            if (this.isShowMinLabel()) {
                if (this.scale.isDateEnabled()) {
                    Date date = new Date((long)min);
                    lblStr2 = this.scale.format(date, true);
                    minDateAdded = true;
                } else {
                    lblStr2 = this.scale.format(min);
                }
            } else {
                lblStr2 = "";
            }
            this.tickLabels.add(lblStr2);
            this.tickLabelPositions.add(this.scale.getMargin());
        }
        int i = 1;
        double f = LargeNumberUtils.maxMagnitude(min, max);
        tickStep /= f;
        double t = (max /= f) - (min /= f);
        double p = firstPosition /= f;
        while (!(max >= min ? !(p < max) : !(p > max))) {
            double b = p * f;
            if (!Double.isInfinite(b)) {
                if (this.scale.isDateEnabled()) {
                    Date date = new Date((long)b);
                    this.tickLabels.add(this.scale.format(date, i == 1 && !minDateAdded));
                } else {
                    this.tickLabels.add(this.scale.format(b));
                }
                this.tickLabelValues.add(b);
                int tickLabelPosition = (int)((p - min) / t * (double)length) + this.scale.getMargin();
                this.tickLabelPositions.add(tickLabelPosition);
            }
            p = firstPosition + (double)i++ * tickStep;
        }
        this.tickLabelValues.add(max *= f);
        if (this.showMaxLabel) {
            if (this.scale.isDateEnabled()) {
                Date date = new Date((long)max);
                lblStr = this.scale.format(date, true);
            } else {
                lblStr = this.scale.format(max);
            }
        } else {
            lblStr = "";
        }
        this.tickLabels.add(lblStr);
        this.tickLabelPositions.add(this.scale.getMargin() + length);
    }

    private void updateTickLabelForLogScale(double min, double max, int length) {
        BigDecimal tickStep;
        if (min <= 0.0 || max <= 0.0) {
            throw new IllegalArgumentException("the range for log scale must be in positive range");
        }
        boolean minBigger = max < min;
        double logMin = Math.log10(min);
        int minLogDigit = (int)Math.ceil(logMin);
        int maxLogDigit = (int)Math.ceil(Math.log10(max));
        BigDecimal minDec = BigDecimal.valueOf(min);
        BigDecimal firstPosition = minDec.remainder(tickStep = this.pow(10.0, minLogDigit - 1)).doubleValue() <= 0.0 ? minDec.subtract(minDec.remainder(tickStep)) : (minBigger ? minDec.subtract(minDec.remainder(tickStep)) : minDec.subtract(minDec.remainder(tickStep)).add(tickStep));
        boolean minDateAdded = false;
        if (minDec.compareTo(firstPosition) == (minBigger ? 1 : -1)) {
            minDateAdded = this.addMinMaxTickInfo(min, length, true);
        }
        int i = minLogDigit;
        while (!(minBigger ? i < maxLogDigit : i > maxLogDigit)) {
            if (Math.abs(maxLogDigit - minLogDigit) > 20) {
                BigDecimal v = this.pow(10.0, i);
                if (v.doubleValue() > max) break;
                this.addTickInfo(v, max, logMin, length, i == minLogDigit, minDateAdded);
            } else {
                BigDecimal j = firstPosition;
                while (!(minBigger ? !(j.doubleValue() >= this.pow(10.0, i - 1).doubleValue()) : !(j.doubleValue() <= this.pow(10.0, i).doubleValue()))) {
                    if (!minBigger ? j.doubleValue() > max : j.doubleValue() < max) break;
                    this.addTickInfo(j, max, logMin, length, j == firstPosition, minDateAdded);
                    BigDecimal bigDecimal = j = minBigger ? j.subtract(tickStep) : j.add(tickStep);
                }
                tickStep = minBigger ? tickStep.divide(this.pow(10.0, 1)) : tickStep.multiply(this.pow(10.0, 1));
                firstPosition = minBigger ? this.pow(10.0, i - 1) : tickStep.add(this.pow(10.0, i));
            }
            i += minBigger ? -1 : 1;
        }
        if (minBigger ? max < this.tickLabelValues.get(this.tickLabelValues.size() - 1) : max > this.tickLabelValues.get(this.tickLabelValues.size() - 1)) {
            this.addMinMaxTickInfo(max, length, false);
        }
    }

    private void addTickInfo(BigDecimal d, double max, double logMin, int length, boolean isFirstPosition, boolean minDateAdded) {
        if (this.scale.isDateEnabled()) {
            Date date = new Date((long)d.doubleValue());
            this.tickLabels.add(this.scale.format(date, isFirstPosition && !minDateAdded));
        } else {
            this.tickLabels.add(this.scale.format(d.doubleValue()));
        }
        int tickLabelPosition = (int)((Math.log10(d.doubleValue()) - logMin) / (Math.log10(max) - logMin) * (double)length) + this.scale.getMargin();
        this.tickLabelPositions.add(tickLabelPosition);
        this.tickLabelValues.add(d.doubleValue());
    }

    private boolean addMinMaxTickInfo(double value, int length, boolean isMin) {
        boolean minDateAdded = false;
        if (isMin) {
            this.tickLabelValues.add(value);
            BigDecimal minDec = BigDecimal.valueOf(value);
            if (this.scale.isDateEnabled()) {
                Date date = new Date((long)minDec.doubleValue());
                this.tickLabels.add(this.scale.format(date, true));
                minDateAdded = true;
            } else {
                this.tickLabels.add(this.scale.format(minDec.doubleValue()));
            }
            this.tickLabelPositions.add(this.scale.getMargin());
        } else {
            this.tickLabelValues.add(value);
            if (this.scale.isDateEnabled()) {
                Date date = new Date((long)value);
                this.tickLabels.add(this.scale.format(date, true));
            } else {
                this.tickLabels.add(this.scale.format(value));
            }
            this.tickLabelPositions.add(this.scale.getMargin() + length);
        }
        return minDateAdded;
    }

    private void updateTickLabelMaxLengthAndHeight() {
        int maxLength = 0;
        int maxHeight = 0;
        int i = 0;
        while (i < this.tickLabels.size()) {
            if (this.tickLabelVisibilities.size() > i && this.tickLabelVisibilities.get(i).booleanValue()) {
                Dimension p = FigureUtilities.getTextExtents((String)this.tickLabels.get(i), (Font)this.scale.getFont());
                if (this.tickLabels.get(0).startsWith(MINUS) && !this.tickLabels.get(i).startsWith(MINUS)) {
                    p.width += FigureUtilities.getTextExtents((String)MINUS, (Font)this.scale.getFont()).width;
                }
                if (p.width > maxLength) {
                    maxLength = p.width;
                }
                if (p.height > maxHeight) {
                    maxHeight = p.height;
                }
            }
            ++i;
        }
        this.tickLabelMaxLength = maxLength;
        this.tickLabelMaxHeight = maxHeight;
    }

    @Override
    public int getHeadMargin() {
        Range r = this.scale.getScaleRange();
        Dimension l = this.scale.getDimension(r.getLower());
        Dimension h = this.scale.getDimension(r.getUpper());
        if (this.scale.isHorizontal()) {
            return (int)Math.ceil((double)Math.max(l.width, h.width) / 2.0);
        }
        return (int)Math.ceil((double)Math.max(l.height, h.height) / 2.0);
    }

    @Override
    public int getTailMargin() {
        return this.getHeadMargin();
    }

    private void updateTickVisibility() {
        this.tickLabelVisibilities.clear();
        if (this.tickLabelPositions.isEmpty()) {
            return;
        }
        int i = 0;
        while (i < this.tickLabelPositions.size()) {
            this.tickLabelVisibilities.add(Boolean.TRUE);
            ++i;
        }
        int previousPosition = 0;
        String previousLabel = null;
        int i2 = 0;
        while (i2 < this.tickLabelPositions.size()) {
            boolean hasSpaceToDraw = true;
            String currentLabel = this.tickLabels.get(i2);
            int currentPosition = this.tickLabelPositions.get(i2);
            if (i2 != 0) {
                hasSpaceToDraw = this.hasSpaceToDraw(previousPosition, currentPosition, previousLabel, currentLabel);
            }
            boolean isRepeatSameTickAndNotEnd = currentLabel.equals(previousLabel) && i2 != 0 && i2 != this.tickLabelPositions.size() - 1;
            boolean isMajorTickOrEnd = true;
            if (this.scale.isLogScaleEnabled()) {
                boolean bl = isMajorTickOrEnd = this.isMajorTick(this.tickLabelValues.get(i2)) || i2 == 0 || i2 == this.tickLabelPositions.size() - 1;
            }
            if (!hasSpaceToDraw || isRepeatSameTickAndNotEnd || !isMajorTickOrEnd) {
                this.tickLabelVisibilities.set(i2, Boolean.FALSE);
            } else {
                previousPosition = currentPosition;
                previousLabel = currentLabel;
            }
            ++i2;
        }
    }

    @Override
    public Range update(double min, double max, int length) {
        this.tickLabels.clear();
        this.tickLabelValues.clear();
        this.tickLabelPositions.clear();
        if (this.scale.isLogScaleEnabled()) {
            this.updateTickLabelForLogScale(min, max, length);
        } else {
            this.updateTickLabelForLinearScale(min, max, length);
        }
        this.updateTickVisibility();
        this.updateTickLabelMaxLengthAndHeight();
        return null;
    }
}

