/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.activity.edit.utils.updater;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.papyrus.uml.diagram.activity.edit.utils.updater.AbstractCallActionPinUpdater;
import org.eclipse.uml2.uml.CallBehaviorAction;
import org.eclipse.uml2.uml.InputPin;
import org.eclipse.uml2.uml.OutputPin;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.ParameterDirectionKind;
import org.eclipse.uml2.uml.UMLFactory;

public class CallBehaviorActionPinUpdater
extends AbstractCallActionPinUpdater<CallBehaviorAction> {
    @Override
    public List<OutputPin> deriveResults(CallBehaviorAction node) {
        ArrayList<OutputPin> derivedOutputPins = new ArrayList<OutputPin>();
        if (node.getBehavior() != null) {
            for (Parameter parameter : node.getBehavior().getOwnedParameters()) {
                if (parameter.getDirection() != ParameterDirectionKind.INOUT_LITERAL && parameter.getDirection() != ParameterDirectionKind.RETURN_LITERAL && parameter.getDirection() != ParameterDirectionKind.OUT_LITERAL) continue;
                OutputPin derivedPin = UMLFactory.eINSTANCE.createOutputPin();
                derivedPin.setType(parameter.getType());
                derivedPin.setLower(parameter.getLower());
                derivedPin.setUpper(parameter.getUpper());
                if (parameter.getDirection() == ParameterDirectionKind.INOUT_LITERAL) {
                    derivedPin.setName("[out] " + parameter.getName());
                } else {
                    derivedPin.setName(parameter.getName());
                }
                derivedOutputPins.add(derivedPin);
            }
        }
        return derivedOutputPins;
    }

    @Override
    public List<InputPin> deriveArguments(CallBehaviorAction node) {
        ArrayList<InputPin> derivedInputPins = new ArrayList<InputPin>();
        if (node.getBehavior() != null) {
            for (Parameter parameter : node.getBehavior().getOwnedParameters()) {
                if (parameter.getDirection() != ParameterDirectionKind.INOUT_LITERAL && parameter.getDirection() != ParameterDirectionKind.IN_LITERAL) continue;
                InputPin derivedPin = UMLFactory.eINSTANCE.createInputPin();
                derivedPin.setType(parameter.getType());
                derivedPin.setLower(parameter.getLower());
                derivedPin.setUpper(parameter.getUpper());
                if (parameter.getDirection() == ParameterDirectionKind.INOUT_LITERAL) {
                    derivedPin.setName("[in] " + parameter.getName());
                } else {
                    derivedPin.setName(parameter.getName());
                }
                derivedInputPins.add(derivedPin);
            }
        }
        return derivedInputPins;
    }
}

