/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.common.commit;

import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.commit.CDOChangeKind;
import org.eclipse.emf.cdo.common.commit.CDOChangeSetData;
import org.eclipse.emf.cdo.common.commit.CDOCommitHistory;
import org.eclipse.emf.cdo.common.commit.CDOCommitInfo;
import org.eclipse.emf.cdo.common.commit.CDOCommitInfoHandler;
import org.eclipse.emf.cdo.common.commit.CDOCommitInfoManager;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.model.CDOPackageUnit;
import org.eclipse.emf.cdo.common.revision.CDOIDAndVersion;
import org.eclipse.emf.cdo.common.revision.CDORevisionKey;
import org.eclipse.emf.cdo.internal.common.bundle.OM;
import org.eclipse.net4j.util.collection.GrowingRandomAccessList;
import org.eclipse.net4j.util.container.Container;
import org.eclipse.net4j.util.event.FinishedEvent;
import org.eclipse.net4j.util.event.IListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CDOCommitHistoryImpl
extends Container<CDOCommitInfo>
implements CDOCommitHistory {
    private final CDOCommitHistory.TriggerLoadElement triggerLoadElement = new TriggerLoadElementImpl();
    private final CDOCommitInfoManager manager;
    private final CDOBranch branch;
    private int loadCount = 50;
    private GrowingRandomAccessList<CDOCommitInfo> commitInfos = new GrowingRandomAccessList(CDOCommitInfo.class, 50);
    private CDOCommitInfo[] elements;
    private boolean appendingTriggerLoadElement;
    private boolean full;
    private Thread loaderThread;
    private Object loaderThreadLock = new Object();

    public CDOCommitHistoryImpl(CDOCommitInfoManager manager, CDOBranch branch) {
        super(true);
        this.manager = manager;
        this.branch = branch;
    }

    @Override
    public final CDOCommitInfoManager getManager() {
        return this.manager;
    }

    @Override
    public final CDOBranch getBranch() {
        return this.branch;
    }

    @Override
    public final int getLoadCount() {
        return this.loadCount;
    }

    @Override
    public void setLoadCount(int loadCount) {
        this.loadCount = loadCount;
    }

    @Override
    public boolean isAppendingTriggerLoadElement() {
        return this.appendingTriggerLoadElement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAppendingTriggerLoadElement(boolean appendingTriggerLoadElement) {
        int event = 0;
        GrowingRandomAccessList<CDOCommitInfo> growingRandomAccessList = this.commitInfos;
        synchronized (growingRandomAccessList) {
            if (this.appendingTriggerLoadElement != appendingTriggerLoadElement) {
                this.appendingTriggerLoadElement = appendingTriggerLoadElement;
                this.elements = null;
                if (!this.full) {
                    event = appendingTriggerLoadElement ? 1 : 2;
                }
            }
        }
        switch (event) {
            case 1: {
                this.fireElementAddedEvent(this.triggerLoadElement);
                break;
            }
            case 2: {
                this.fireElementRemovedEvent(this.triggerLoadElement);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CDOCommitInfo getFirstElement() {
        this.checkActive();
        GrowingRandomAccessList<CDOCommitInfo> growingRandomAccessList = this.commitInfos;
        synchronized (growingRandomAccessList) {
            block4: {
                if (!this.commitInfos.isEmpty()) break block4;
                return null;
            }
            return (CDOCommitInfo)this.commitInfos.getFirst();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CDOCommitInfo getLastElement() {
        this.checkActive();
        GrowingRandomAccessList<CDOCommitInfo> growingRandomAccessList = this.commitInfos;
        synchronized (growingRandomAccessList) {
            block4: {
                if (!this.commitInfos.isEmpty()) break block4;
                return null;
            }
            return (CDOCommitInfo)this.commitInfos.getLast();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CDOCommitInfo getElement(int index) {
        this.checkActive();
        GrowingRandomAccessList<CDOCommitInfo> growingRandomAccessList = this.commitInfos;
        synchronized (growingRandomAccessList) {
            return (CDOCommitInfo)this.commitInfos.get(index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CDOCommitInfo[] getElements() {
        this.checkActive();
        GrowingRandomAccessList<CDOCommitInfo> growingRandomAccessList = this.commitInfos;
        synchronized (growingRandomAccessList) {
            if (this.elements == null) {
                int size = this.commitInfos.size();
                if (!this.full && this.appendingTriggerLoadElement && !this.isLoading()) {
                    this.elements = (CDOCommitInfo[])this.commitInfos.toArray((Object[])new CDOCommitInfo[size + 1]);
                    this.elements[size] = this.triggerLoadElement;
                } else {
                    this.elements = (CDOCommitInfo[])this.commitInfos.toArray((Object[])new CDOCommitInfo[size]);
                }
            }
            return this.elements;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        this.checkActive();
        GrowingRandomAccessList<CDOCommitInfo> growingRandomAccessList = this.commitInfos;
        synchronized (growingRandomAccessList) {
            int size = this.commitInfos.size();
            if (!this.full && this.appendingTriggerLoadElement) {
                ++size;
            }
            return size;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        this.checkActive();
        GrowingRandomAccessList<CDOCommitInfo> growingRandomAccessList = this.commitInfos;
        synchronized (growingRandomAccessList) {
            block4: {
                if (this.full || !this.appendingTriggerLoadElement) break block4;
                return false;
            }
            return this.commitInfos.isEmpty();
        }
    }

    @Override
    public boolean isFull() {
        return this.full;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isLoading() {
        Object object = this.loaderThreadLock;
        synchronized (object) {
            return this.loaderThread != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void waitWhileLoading(long timeout) {
        long end = System.currentTimeMillis() + timeout;
        GrowingRandomAccessList<CDOCommitInfo> growingRandomAccessList = this.commitInfos;
        synchronized (growingRandomAccessList) {
            while (this.isLoading()) {
                try {
                    long remaining = end - System.currentTimeMillis();
                    if (remaining <= 0L) {
                        return;
                    }
                    this.commitInfos.wait(remaining);
                }
                catch (InterruptedException ex) {
                    return;
                }
            }
        }
    }

    @Override
    public boolean triggerLoad() {
        return this.triggerLoad(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean triggerLoad(final CDOCommitInfoHandler handler) {
        Object object = this.loaderThreadLock;
        synchronized (object) {
            block4: {
                if (!this.full && this.loaderThread == null) break block4;
                return false;
            }
            this.loaderThread = new Thread("CDOCommitHistoryLoader"){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    block14: {
                        try {
                            try {
                                CDOCommitHistoryImpl.this.doLoadCommitInfos(handler);
                            }
                            catch (Throwable ex) {
                                OM.LOG.error(ex);
                                Object object = CDOCommitHistoryImpl.this.loaderThreadLock;
                                synchronized (object) {
                                    CDOCommitHistoryImpl.this.loaderThread = null;
                                    break block14;
                                }
                            }
                        }
                        catch (Throwable throwable) {
                            Object object = CDOCommitHistoryImpl.this.loaderThreadLock;
                            synchronized (object) {
                                CDOCommitHistoryImpl.this.loaderThread = null;
                            }
                            throw throwable;
                        }
                        Object object = CDOCommitHistoryImpl.this.loaderThreadLock;
                        synchronized (object) {
                            CDOCommitHistoryImpl.this.loaderThread = null;
                        }
                    }
                }
            };
        }
        this.loaderThread.start();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleCommitInfo(CDOCommitInfo commitInfo) {
        if (this.filter(commitInfo)) {
            return;
        }
        long timeStamp = commitInfo.getTimeStamp();
        GrowingRandomAccessList<CDOCommitInfo> growingRandomAccessList = this.commitInfos;
        synchronized (growingRandomAccessList) {
            if (this.commitInfos.isEmpty() || timeStamp > ((CDOCommitInfo)this.commitInfos.getFirst()).getTimeStamp()) {
                this.commitInfos.addFirst((Object)commitInfo);
            } else if (timeStamp < ((CDOCommitInfo)this.commitInfos.getLast()).getTimeStamp()) {
                this.commitInfos.addLast((Object)commitInfo);
            } else {
                ListIterator it = this.commitInfos.listIterator();
                while (it.hasNext()) {
                    CDOCommitInfo current = (CDOCommitInfo)it.next();
                    long currentTimeStamp = current.getTimeStamp();
                    if (timeStamp == currentTimeStamp) {
                        return;
                    }
                    if (timeStamp >= currentTimeStamp) continue;
                    it.add(commitInfo);
                    break;
                }
            }
            this.elements = null;
            this.commitInfos.notifyAll();
        }
        this.fireElementAddedEvent(commitInfo);
    }

    protected boolean filter(CDOCommitInfo commitInfo) {
        return this.branch != null && this.branch != commitInfo.getBranch();
    }

    protected void setFull() {
        this.full = true;
    }

    protected void doActivate() throws Exception {
        super.doActivate();
        this.manager.addCommitInfoHandler(this);
    }

    protected void doAfterActivate() throws Exception {
        super.doAfterActivate();
        this.triggerLoad();
    }

    protected void doDeactivate() throws Exception {
        this.manager.removeCommitInfoHandler(this);
        super.doDeactivate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doLoadCommitInfos(final CDOCommitInfoHandler handler) {
        long startTime;
        GrowingRandomAccessList<CDOCommitInfo> growingRandomAccessList = this.commitInfos;
        synchronized (growingRandomAccessList) {
            startTime = this.commitInfos.isEmpty() ? 0L : ((CDOCommitInfo)this.commitInfos.getLast()).getTimeStamp();
        }
        final int[] loaded = new int[1];
        this.manager.getCommitInfos(this.branch, startTime, null, null, -this.loadCount, new CDOCommitInfoHandler(startTime){
            private boolean ignore;
            {
                this.ignore = l != 0L;
            }

            public void handleCommitInfo(CDOCommitInfo commitInfo) {
                loaded[0] = loaded[0] + 1;
                if (this.ignore) {
                    this.ignore = false;
                    return;
                }
                CDOCommitHistoryImpl.this.handleCommitInfo(commitInfo);
                CDOCommitHistoryImpl.handle(handler, commitInfo);
            }
        });
        if (loaded[0] < this.loadCount) {
            this.setFull();
        } else if (this.appendingTriggerLoadElement) {
            this.fireElementAddedEvent(this.triggerLoadElement);
            CDOCommitHistoryImpl.handle(handler, this.triggerLoadElement);
        }
        if (handler instanceof IListener) {
            IListener listener = (IListener)handler;
            listener.notifyEvent(FinishedEvent.INSTANCE);
        }
    }

    private static void handle(CDOCommitInfoHandler handler, CDOCommitInfo commitInfo) {
        if (handler != null) {
            handler.handleCommitInfo(commitInfo);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Empty
    extends Container<CDOCommitInfo>
    implements CDOCommitHistory {
        private static final CDOCommitInfo[] NO_ELEMENTS = new CDOCommitInfo[0];

        public CDOCommitInfo[] getElements() {
            return NO_ELEMENTS;
        }

        public CDOCommitInfo[] getElements(boolean withTriggerLoadElement) {
            return NO_ELEMENTS;
        }

        @Override
        public void handleCommitInfo(CDOCommitInfo commitInfo) {
        }

        @Override
        public CDOCommitInfoManager getManager() {
            return null;
        }

        @Override
        public CDOBranch getBranch() {
            return null;
        }

        @Override
        public boolean isAppendingTriggerLoadElement() {
            return false;
        }

        @Override
        public void setAppendingTriggerLoadElement(boolean appendingTriggerLoadElement) {
        }

        @Override
        public CDOCommitInfo getFirstElement() {
            return null;
        }

        @Override
        public CDOCommitInfo getLastElement() {
            return null;
        }

        @Override
        public CDOCommitInfo getElement(int index) {
            return null;
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public boolean isLoading() {
            return false;
        }

        @Override
        public void waitWhileLoading(long timeout) {
        }

        @Override
        public int getLoadCount() {
            return 0;
        }

        @Override
        public void setLoadCount(int loadCount) {
        }

        @Override
        public boolean triggerLoad() {
            return false;
        }

        @Override
        public boolean triggerLoad(CDOCommitInfoHandler handler) {
            return false;
        }

        @Override
        public boolean isFull() {
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class TriggerLoadElementImpl
    implements CDOCommitHistory.TriggerLoadElement {
        private TriggerLoadElementImpl() {
        }

        @Override
        public CDOCommitHistory getHistory() {
            return CDOCommitHistoryImpl.this;
        }

        @Override
        public CDOCommitInfoManager getCommitInfoManager() {
            return CDOCommitHistoryImpl.this.manager;
        }

        @Override
        public CDOBranch getBranch() {
            return null;
        }

        @Override
        public long getTimeStamp() {
            return 0L;
        }

        @Override
        public long getPreviousTimeStamp() {
            return 0L;
        }

        @Override
        public String getUserID() {
            return null;
        }

        @Override
        public String getComment() {
            return "Load more history elements";
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public boolean isInitialCommit() {
            return false;
        }

        @Override
        public boolean isCommitDataLoaded() {
            return true;
        }

        @Override
        public List<CDOPackageUnit> getNewPackageUnits() {
            return null;
        }

        @Override
        public List<CDOIDAndVersion> getNewObjects() {
            return null;
        }

        @Override
        public List<CDORevisionKey> getChangedObjects() {
            return null;
        }

        @Override
        public List<CDOIDAndVersion> getDetachedObjects() {
            return null;
        }

        @Override
        public Map<CDOID, CDOChangeKind> getChangeKinds() {
            return null;
        }

        @Override
        public CDOChangeKind getChangeKind(CDOID id) {
            return null;
        }

        @Override
        public void merge(CDOChangeSetData changeSetData) {
        }

        @Override
        public CDOChangeSetData copy() {
            return null;
        }
    }
}

