/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.common.id;

import java.io.IOException;
import java.io.ObjectStreamException;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.model.CDOClassifierRef;
import org.eclipse.emf.cdo.common.protocol.CDODataInput;
import org.eclipse.emf.cdo.common.protocol.CDODataOutput;
import org.eclipse.emf.cdo.spi.common.id.AbstractCDOID;
import org.eclipse.emf.cdo.spi.common.id.InternalCDOIDObject;
import org.eclipse.net4j.util.CheckUtil;
import org.eclipse.net4j.util.ObjectUtil;
import org.eclipse.net4j.util.ref.Interner;

public final class CDOIDObjectLongWithClassifierImpl
extends AbstractCDOID
implements InternalCDOIDObject,
CDOClassifierRef.Provider {
    private static final long serialVersionUID = 1L;
    private static final LongWithClassifierInterner INTERNER = new LongWithClassifierInterner();
    private final long value;
    private final CDOClassifierRef classifierRef;

    private CDOIDObjectLongWithClassifierImpl(long value, CDOClassifierRef classifierRef) {
        CheckUtil.checkArg((value != 0L ? 1 : 0) != 0, (String)"Zero not allowed");
        this.value = value;
        this.classifierRef = classifierRef;
    }

    private CDOIDObjectLongWithClassifierImpl() {
        this.value = 0L;
        this.classifierRef = null;
    }

    public long getLongValue() {
        return this.value;
    }

    public CDOClassifierRef getClassifierRef() {
        return this.classifierRef;
    }

    public void write(CDODataOutput out) throws IOException {
        out.writeLong(this.value);
        out.writeCDOClassifierRef(this.classifierRef);
    }

    public String toURIFragment() {
        return String.valueOf(this.classifierRef.getPackageURI()) + "#" + this.classifierRef.getClassifierName() + "#" + this.value;
    }

    public CDOID.Type getType() {
        return CDOID.Type.OBJECT;
    }

    public CDOID.ObjectType getSubType() {
        return CDOID.ObjectType.LONG_WITH_CLASSIFIER;
    }

    public boolean isExternal() {
        return false;
    }

    public boolean isObject() {
        return true;
    }

    public boolean isTemporary() {
        return false;
    }

    public int hashCode() {
        return CDOIDObjectLongWithClassifierImpl.getHashCode(this.value, this.classifierRef);
    }

    public String toString() {
        return "OID:" + this.toURIFragment();
    }

    protected int doCompareTo(CDOID o) throws ClassCastException {
        return this.toURIFragment().compareTo(o.toURIFragment());
    }

    private Object readResolve() throws ObjectStreamException {
        return CDOIDObjectLongWithClassifierImpl.create(this.value, this.classifierRef);
    }

    private static int getHashCode(long value, CDOClassifierRef classifierRef) {
        return ObjectUtil.hashCode((long)value) ^ classifierRef.hashCode();
    }

    public static CDOIDObjectLongWithClassifierImpl create(long value, CDOClassifierRef classifierRef) {
        return INTERNER.intern(value, classifierRef);
    }

    public static CDOIDObjectLongWithClassifierImpl create(CDODataInput in) throws IOException {
        long value = in.readLong();
        CDOClassifierRef classifierRef = in.readCDOClassifierRef();
        return CDOIDObjectLongWithClassifierImpl.create(value, classifierRef);
    }

    public static CDOIDObjectLongWithClassifierImpl create(String fragmentPart) {
        int index1 = fragmentPart.indexOf("#");
        int index2 = fragmentPart.indexOf("#", index1 + 1);
        if (index1 == -1 || index2 == -1) {
            throw new IllegalArgumentException("The fragment " + fragmentPart + " is not a valid fragment");
        }
        String packageURI = fragmentPart.substring(0, index1);
        String classifierName = fragmentPart.substring(index1 + 1, index2);
        CDOClassifierRef classifierRef = new CDOClassifierRef(packageURI, classifierName);
        long value = Long.parseLong(fragmentPart.substring(index2 + 1));
        return CDOIDObjectLongWithClassifierImpl.create(value, classifierRef);
    }

    /* synthetic */ CDOIDObjectLongWithClassifierImpl(long l, CDOClassifierRef cDOClassifierRef, CDOIDObjectLongWithClassifierImpl cDOIDObjectLongWithClassifierImpl) {
        this(l, cDOClassifierRef);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class LongWithClassifierInterner
    extends Interner<CDOIDObjectLongWithClassifierImpl> {
        private LongWithClassifierInterner() {
        }

        public synchronized CDOIDObjectLongWithClassifierImpl intern(long value, CDOClassifierRef classifierRef) {
            int hashCode = CDOIDObjectLongWithClassifierImpl.getHashCode(value, classifierRef);
            Interner.Entry entry = this.getEntry(hashCode);
            while (entry != null) {
                CDOIDObjectLongWithClassifierImpl id = (CDOIDObjectLongWithClassifierImpl)entry.get();
                if (id != null && id.value == value && id.classifierRef.equals(classifierRef)) {
                    return id;
                }
                entry = entry.getNextEntry();
            }
            CDOIDObjectLongWithClassifierImpl id = new CDOIDObjectLongWithClassifierImpl(value, classifierRef, null);
            this.addEntry(this.createEntry(id, hashCode));
            return id;
        }

        protected int hashCode(CDOIDObjectLongWithClassifierImpl id) {
            return CDOIDObjectLongWithClassifierImpl.getHashCode(id.value, id.classifierRef);
        }
    }
}

