/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.javaeditor;

import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AnnotationTypeMemberDeclaration;
import org.eclipse.jdt.core.dom.ArrayAccess;
import org.eclipse.jdt.core.dom.CastExpression;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.ConditionalExpression;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.InfixExpression;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.NameQualifiedType;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.PrefixExpression;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditorMessages;
import org.eclipse.jdt.internal.ui.javaeditor.SemanticHighlighting;
import org.eclipse.jdt.internal.ui.javaeditor.SemanticToken;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.RGB;

public class SemanticHighlightings {
    public static final String STATIC_FINAL_FIELD = "staticFinalField";
    public static final String STATIC_FIELD = "staticField";
    public static final String FIELD = "field";
    public static final String METHOD_DECLARATION = "methodDeclarationName";
    public static final String STATIC_METHOD_INVOCATION = "staticMethodInvocation";
    public static final String INHERITED_METHOD_INVOCATION = "inheritedMethodInvocation";
    public static final String ANNOTATION_ELEMENT_REFERENCE = "annotationElementReference";
    public static final String ABSTRACT_METHOD_INVOCATION = "abstractMethodInvocation";
    public static final String LOCAL_VARIABLE_DECLARATION = "localVariableDeclaration";
    public static final String LOCAL_VARIABLE = "localVariable";
    public static final String PARAMETER_VARIABLE = "parameterVariable";
    public static final String DEPRECATED_MEMBER = "deprecatedMember";
    public static final String TYPE_VARIABLE = "typeParameter";
    public static final String METHOD = "method";
    public static final String AUTOBOXING = "autoboxing";
    public static final String CLASS = "class";
    public static final String ENUM = "enum";
    public static final String INTERFACE = "interface";
    public static final String ANNOTATION = "annotation";
    public static final String TYPE_ARGUMENT = "typeArgument";
    public static final String NUMBER = "number";
    public static final String ABSTRACT_CLASS = "abstractClass";
    public static final String INHERITED_FIELD = "inheritedField";
    private static SemanticHighlighting[] fgSemanticHighlightings;

    public static String getColorPreferenceKey(SemanticHighlighting semanticHighlighting) {
        return "semanticHighlighting." + semanticHighlighting.getPreferenceKey() + ".color";
    }

    public static String getBoldPreferenceKey(SemanticHighlighting semanticHighlighting) {
        return "semanticHighlighting." + semanticHighlighting.getPreferenceKey() + ".bold";
    }

    public static String getItalicPreferenceKey(SemanticHighlighting semanticHighlighting) {
        return "semanticHighlighting." + semanticHighlighting.getPreferenceKey() + ".italic";
    }

    public static String getStrikethroughPreferenceKey(SemanticHighlighting semanticHighlighting) {
        return "semanticHighlighting." + semanticHighlighting.getPreferenceKey() + ".strikethrough";
    }

    public static String getUnderlinePreferenceKey(SemanticHighlighting semanticHighlighting) {
        return "semanticHighlighting." + semanticHighlighting.getPreferenceKey() + ".underline";
    }

    public static String getEnabledPreferenceKey(SemanticHighlighting semanticHighlighting) {
        return "semanticHighlighting." + semanticHighlighting.getPreferenceKey() + ".enabled";
    }

    public static SemanticHighlighting[] getSemanticHighlightings() {
        if (fgSemanticHighlightings == null) {
            fgSemanticHighlightings = new SemanticHighlighting[]{new DeprecatedMemberHighlighting(), new AutoboxHighlighting(), new StaticFinalFieldHighlighting(), new StaticFieldHighlighting(), new InheritedFieldHighlighting(), new FieldHighlighting(), new MethodDeclarationHighlighting(), new StaticMethodInvocationHighlighting(), new AbstractMethodInvocationHighlighting(), new AnnotationElementReferenceHighlighting(), new InheritedMethodInvocationHighlighting(), new ParameterVariableHighlighting(), new LocalVariableDeclarationHighlighting(), new LocalVariableHighlighting(), new TypeVariableHighlighting(), new MethodHighlighting(), new TypeArgumentHighlighting(), new AbstractClassHighlighting(), new ClassHighlighting(), new EnumHighlighting(), new AnnotationHighlighting(), new InterfaceHighlighting(), new NumberHighlighting()};
        }
        return fgSemanticHighlightings;
    }

    public static void initDefaults(IPreferenceStore store) {
        SemanticHighlighting[] semanticHighlightings = SemanticHighlightings.getSemanticHighlightings();
        int i = 0;
        int n = semanticHighlightings.length;
        while (i < n) {
            SemanticHighlighting semanticHighlighting = semanticHighlightings[i];
            SemanticHighlightings.setDefaultAndFireEvent(store, SemanticHighlightings.getColorPreferenceKey(semanticHighlighting), semanticHighlighting.getDefaultTextColor());
            store.setDefault(SemanticHighlightings.getBoldPreferenceKey(semanticHighlighting), semanticHighlighting.isBoldByDefault());
            store.setDefault(SemanticHighlightings.getItalicPreferenceKey(semanticHighlighting), semanticHighlighting.isItalicByDefault());
            store.setDefault(SemanticHighlightings.getStrikethroughPreferenceKey(semanticHighlighting), semanticHighlighting.isStrikethroughByDefault());
            store.setDefault(SemanticHighlightings.getUnderlinePreferenceKey(semanticHighlighting), semanticHighlighting.isUnderlineByDefault());
            store.setDefault(SemanticHighlightings.getEnabledPreferenceKey(semanticHighlighting), semanticHighlighting.isEnabledByDefault());
            ++i;
        }
        SemanticHighlightings.convertMethodHighlightingPreferences(store);
        SemanticHighlightings.convertAnnotationHighlightingPreferences(store);
    }

    public static boolean affectsEnablement(IPreferenceStore store, PropertyChangeEvent event) {
        String relevantKey = null;
        SemanticHighlighting[] highlightings = SemanticHighlightings.getSemanticHighlightings();
        int i = 0;
        while (i < highlightings.length) {
            if (event.getProperty().equals(SemanticHighlightings.getEnabledPreferenceKey(highlightings[i]))) {
                relevantKey = event.getProperty();
                break;
            }
            ++i;
        }
        if (relevantKey == null) {
            return false;
        }
        i = 0;
        while (i < highlightings.length) {
            String key = SemanticHighlightings.getEnabledPreferenceKey(highlightings[i]);
            if (!key.equals(relevantKey) && store.getBoolean(key)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isEnabled(IPreferenceStore store) {
        SemanticHighlighting[] highlightings = SemanticHighlightings.getSemanticHighlightings();
        boolean enable = false;
        int i = 0;
        while (i < highlightings.length) {
            String enabledKey = SemanticHighlightings.getEnabledPreferenceKey(highlightings[i]);
            if (store.getBoolean(enabledKey)) {
                enable = true;
                break;
            }
            ++i;
        }
        return enable;
    }

    private static void convertMethodHighlightingPreferences(IPreferenceStore store) {
        String colorkey = "semanticHighlighting.method.color";
        String boldkey = "semanticHighlighting.method.bold";
        String italickey = "semanticHighlighting.method.italic";
        String enabledkey = "semanticHighlighting.method.enabled";
        String oldColorkey = "java_method_name";
        String oldBoldkey = "java_method_name_bold";
        String oldItalickey = "java_method_name_italic";
        if (SemanticHighlightings.conditionalReset(store, oldColorkey, colorkey) || SemanticHighlightings.conditionalReset(store, oldBoldkey, boldkey) || SemanticHighlightings.conditionalReset(store, oldItalickey, italickey)) {
            store.setValue(enabledkey, true);
        }
    }

    private static void convertAnnotationHighlightingPreferences(IPreferenceStore store) {
        String colorkey = "semanticHighlighting.annotation.color";
        String boldkey = "semanticHighlighting.annotation.bold";
        String italickey = "semanticHighlighting.annotation.italic";
        String strikethroughKey = "semanticHighlighting.annotation.strikethrough";
        String underlineKey = "semanticHighlighting.annotation.underline";
        String enabledkey = "semanticHighlighting.annotation.enabled";
        String oldColorkey = "java_annotation";
        String oldBoldkey = "java_annotation_bold";
        String oldItalickey = "java_annotation_italic";
        String oldStrikethroughKey = "java_annotation_strikethrough";
        String oldUnderlineKey = "java_annotation_underline";
        if (SemanticHighlightings.conditionalReset(store, oldColorkey, colorkey) || SemanticHighlightings.conditionalReset(store, oldBoldkey, boldkey) || SemanticHighlightings.conditionalReset(store, oldItalickey, italickey) || SemanticHighlightings.conditionalReset(store, oldStrikethroughKey, strikethroughKey) || SemanticHighlightings.conditionalReset(store, oldUnderlineKey, underlineKey)) {
            store.setValue(enabledkey, true);
        }
    }

    private static boolean conditionalReset(IPreferenceStore store, String oldKey, String newKey) {
        if (!store.isDefault(oldKey)) {
            if (store.isDefault(newKey)) {
                store.setValue(newKey, store.getString(oldKey));
            }
            store.setToDefault(oldKey);
            return true;
        }
        return false;
    }

    private static void setDefaultAndFireEvent(IPreferenceStore store, String key, RGB newValue) {
        RGB oldValue = null;
        if (store.isDefault(key)) {
            oldValue = PreferenceConverter.getDefaultColor((IPreferenceStore)store, (String)key);
        }
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)key, (RGB)newValue);
        if (oldValue != null && !oldValue.equals((Object)newValue)) {
            store.firePropertyChangeEvent(key, (Object)oldValue, (Object)newValue);
        }
    }

    private static IBinding getBinding(SemanticToken token) {
        SimpleName node = token.getNode();
        ASTNode normalized = ASTNodes.getNormalizedNode((ASTNode)node);
        if (normalized.getLocationInParent() == ClassInstanceCreation.TYPE_PROPERTY) {
            return ((ClassInstanceCreation)normalized.getParent()).resolveConstructorBinding();
        }
        return token.getBinding();
    }

    private SemanticHighlightings() {
    }

    private static final class AbstractClassHighlighting
    extends SemanticHighlighting {
        private AbstractClassHighlighting() {
        }

        @Override
        public String getPreferenceKey() {
            return SemanticHighlightings.ABSTRACT_CLASS;
        }

        @Override
        public RGB getDefaultDefaultTextColor() {
            return new RGB(139, 136, 22);
        }

        @Override
        public boolean isBoldByDefault() {
            return false;
        }

        @Override
        public boolean isItalicByDefault() {
            return false;
        }

        @Override
        public boolean isEnabledByDefault() {
            return false;
        }

        @Override
        public String getDisplayName() {
            return JavaEditorMessages.SemanticHighlighting_abstractClasses;
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public boolean consumes(SemanticToken token) {
            name = token.getNode();
            node = name.getParent();
            nodeType = node.getNodeType();
            if (nodeType == 43 || nodeType == 52 || nodeType == 75 || nodeType == 40 || nodeType == 55 || nodeType == 32) ** GOTO lbl9
            return false;
lbl-1000:
            // 1 sources

            {
                nodeType = (node = node.getParent()).getNodeType();
                if (nodeType != 26) continue;
                return false;
lbl9:
                // 2 sources

                ** while (nodeType == 40)
            }
lbl10:
            // 1 sources

            binding = token.getBinding();
            if (binding instanceof ITypeBinding) {
                typeBinding = (ITypeBinding)binding;
                return typeBinding.isClass() != false && (typeBinding.getModifiers() & 1024) != 0;
            }
            return false;
        }
    }

    private static final class AbstractMethodInvocationHighlighting
    extends SemanticHighlighting {
        private AbstractMethodInvocationHighlighting() {
        }

        @Override
        public String getPreferenceKey() {
            return SemanticHighlightings.ABSTRACT_METHOD_INVOCATION;
        }

        @Override
        public RGB getDefaultDefaultTextColor() {
            return new RGB(0, 0, 0);
        }

        @Override
        public boolean isBoldByDefault() {
            return false;
        }

        @Override
        public boolean isItalicByDefault() {
            return false;
        }

        @Override
        public boolean isEnabledByDefault() {
            return false;
        }

        @Override
        public String getDisplayName() {
            return JavaEditorMessages.SemanticHighlighting_abstractMethodInvocation;
        }

        @Override
        public boolean consumes(SemanticToken token) {
            ITypeBinding declaringType;
            boolean isAbstractMethod;
            SimpleName node = token.getNode();
            if (node.isDeclaration()) {
                return false;
            }
            IBinding binding = token.getBinding();
            boolean bl = isAbstractMethod = binding != null && binding.getKind() == 4 && (binding.getModifiers() & 0x400) == 1024;
            if (!isAbstractMethod) {
                return false;
            }
            return binding == null || !(declaringType = ((IMethodBinding)binding).getDeclaringClass()).isAnnotation();
        }
    }

    private static final class AnnotationElementReferenceHighlighting
    extends SemanticHighlighting {
        private AnnotationElementReferenceHighlighting() {
        }

        @Override
        public String getPreferenceKey() {
            return SemanticHighlightings.ANNOTATION_ELEMENT_REFERENCE;
        }

        @Override
        public RGB getDefaultDefaultTextColor() {
            return new RGB(0, 0, 0);
        }

        @Override
        public boolean isBoldByDefault() {
            return false;
        }

        @Override
        public boolean isItalicByDefault() {
            return false;
        }

        @Override
        public boolean isEnabledByDefault() {
            return false;
        }

        @Override
        public String getDisplayName() {
            return JavaEditorMessages.SemanticHighlighting_annotationElementReference;
        }

        @Override
        public boolean consumes(SemanticToken token) {
            SimpleName node = token.getNode();
            if (node.getParent() instanceof MemberValuePair) {
                IBinding binding = token.getBinding();
                boolean isAnnotationElement = binding != null && binding.getKind() == 4;
                return isAnnotationElement;
            }
            return false;
        }
    }

    private static final class AnnotationHighlighting
    extends SemanticHighlighting {
        private AnnotationHighlighting() {
        }

        @Override
        public String getPreferenceKey() {
            return SemanticHighlightings.ANNOTATION;
        }

        @Override
        public RGB getDefaultDefaultTextColor() {
            return new RGB(100, 100, 100);
        }

        @Override
        public boolean isBoldByDefault() {
            return false;
        }

        @Override
        public boolean isItalicByDefault() {
            return false;
        }

        @Override
        public boolean isEnabledByDefault() {
            return true;
        }

        @Override
        public String getDisplayName() {
            return JavaEditorMessages.SemanticHighlighting_annotations;
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public boolean consumes(SemanticToken token) {
            name = token.getNode();
            node = name.getParent();
            nodeType = node.getNodeType();
            if (nodeType == 43 || nodeType == 75 || nodeType == 40 || nodeType == 81 || nodeType == 78 || nodeType == 77 || nodeType == 79) ** GOTO lbl9
            return false;
lbl-1000:
            // 1 sources

            {
                nodeType = (node = node.getParent()).getNodeType();
                if (nodeType != 26) continue;
                return false;
lbl9:
                // 2 sources

                ** while (nodeType == 40)
            }
lbl10:
            // 1 sources

            binding = token.getBinding();
            return binding instanceof ITypeBinding != false && ((ITypeBinding)binding).isAnnotation() != false;
        }
    }

    private static final class AutoboxHighlighting
    extends SemanticHighlighting {
        private AutoboxHighlighting() {
        }

        @Override
        public String getPreferenceKey() {
            return SemanticHighlightings.AUTOBOXING;
        }

        @Override
        public RGB getDefaultDefaultTextColor() {
            return new RGB(171, 48, 0);
        }

        @Override
        public boolean isBoldByDefault() {
            return false;
        }

        @Override
        public boolean isItalicByDefault() {
            return false;
        }

        @Override
        public boolean isEnabledByDefault() {
            return false;
        }

        @Override
        public String getDisplayName() {
            return JavaEditorMessages.SemanticHighlighting_autoboxing;
        }

        @Override
        public boolean consumesLiteral(SemanticToken token) {
            return this.isAutoUnBoxing(token.getLiteral());
        }

        @Override
        public boolean consumes(SemanticToken token) {
            return this.isAutoUnBoxing((Expression)token.getNode());
        }

        private boolean isAutoUnBoxing(Expression node) {
            ASTNode parent;
            if (this.isAutoUnBoxingExpression(node)) {
                return true;
            }
            StructuralPropertyDescriptor desc = node.getLocationInParent();
            if ((desc == ArrayAccess.ARRAY_PROPERTY || desc == InfixExpression.LEFT_OPERAND_PROPERTY || desc == InfixExpression.RIGHT_OPERAND_PROPERTY || desc == ConditionalExpression.THEN_EXPRESSION_PROPERTY || desc == PrefixExpression.OPERAND_PROPERTY || desc == CastExpression.EXPRESSION_PROPERTY || desc == ConditionalExpression.ELSE_EXPRESSION_PROPERTY) && (parent = node.getParent()) instanceof Expression) {
                return this.isAutoUnBoxingExpression((Expression)parent);
            }
            if (desc == QualifiedName.NAME_PROPERTY) {
                node = (Expression)node.getParent();
                desc = node.getLocationInParent();
            }
            if ((desc == SimpleType.NAME_PROPERTY || desc == NameQualifiedType.NAME_PROPERTY) && (parent = node.getParent()) != null && parent.getLocationInParent() == ClassInstanceCreation.TYPE_PROPERTY) {
                parent = parent.getParent();
                return this.isAutoUnBoxingExpression((Expression)((ClassInstanceCreation)parent));
            }
            return false;
        }

        private boolean isAutoUnBoxingExpression(Expression expression) {
            return expression.resolveBoxing() || expression.resolveUnboxing();
        }
    }

    private static final class ClassHighlighting
    extends SemanticHighlighting {
        private ClassHighlighting() {
        }

        @Override
        public String getPreferenceKey() {
            return SemanticHighlightings.CLASS;
        }

        @Override
        public RGB getDefaultDefaultTextColor() {
            return new RGB(0, 80, 50);
        }

        @Override
        public boolean isBoldByDefault() {
            return false;
        }

        @Override
        public boolean isItalicByDefault() {
            return false;
        }

        @Override
        public boolean isEnabledByDefault() {
            return false;
        }

        @Override
        public String getDisplayName() {
            return JavaEditorMessages.SemanticHighlighting_classes;
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public boolean consumes(SemanticToken token) {
            name = token.getNode();
            node = name.getParent();
            nodeType = node.getNodeType();
            if (nodeType == 43 || nodeType == 52 || nodeType == 75 || nodeType == 40 || nodeType == 55 || nodeType == 32) ** GOTO lbl9
            return false;
lbl-1000:
            // 1 sources

            {
                nodeType = (node = node.getParent()).getNodeType();
                if (nodeType != 26) continue;
                return false;
lbl9:
                // 2 sources

                ** while (nodeType == 40)
            }
lbl10:
            // 1 sources

            binding = token.getBinding();
            return binding instanceof ITypeBinding != false && ((ITypeBinding)binding).isClass() != false;
        }
    }

    static final class DeprecatedMemberHighlighting
    extends SemanticHighlighting {
        DeprecatedMemberHighlighting() {
        }

        @Override
        public String getPreferenceKey() {
            return SemanticHighlightings.DEPRECATED_MEMBER;
        }

        @Override
        public RGB getDefaultDefaultTextColor() {
            return new RGB(0, 0, 0);
        }

        @Override
        public boolean isBoldByDefault() {
            return false;
        }

        @Override
        public boolean isItalicByDefault() {
            return false;
        }

        @Override
        public boolean isStrikethroughByDefault() {
            return true;
        }

        @Override
        public boolean isEnabledByDefault() {
            return true;
        }

        @Override
        public String getDisplayName() {
            return JavaEditorMessages.SemanticHighlighting_deprecatedMember;
        }

        @Override
        public boolean consumes(SemanticToken token) {
            IBinding binding = SemanticHighlightings.getBinding(token);
            if (binding != null) {
                if (binding.isDeprecated()) {
                    return true;
                }
                if (binding instanceof IMethodBinding) {
                    IMethodBinding methodBinding = (IMethodBinding)binding;
                    ITypeBinding declaringClass = methodBinding.getDeclaringClass();
                    if (declaringClass == null) {
                        return false;
                    }
                    if (declaringClass.isAnonymous()) {
                        ITypeBinding[] interfaces = declaringClass.getInterfaces();
                        if (interfaces.length > 0) {
                            return interfaces[0].isDeprecated();
                        }
                        return declaringClass.getSuperclass().isDeprecated();
                    }
                    return declaringClass.isDeprecated() && !(token.getNode().getParent() instanceof MethodDeclaration);
                }
                if (binding instanceof IVariableBinding) {
                    IVariableBinding variableBinding = (IVariableBinding)binding;
                    ITypeBinding declaringClass = variableBinding.getDeclaringClass();
                    return declaringClass != null && declaringClass.isDeprecated() && !(token.getNode().getParent() instanceof VariableDeclaration);
                }
            }
            return false;
        }
    }

    private static final class EnumHighlighting
    extends SemanticHighlighting {
        private EnumHighlighting() {
        }

        @Override
        public String getPreferenceKey() {
            return SemanticHighlightings.ENUM;
        }

        @Override
        public RGB getDefaultDefaultTextColor() {
            return new RGB(100, 70, 50);
        }

        @Override
        public boolean isBoldByDefault() {
            return false;
        }

        @Override
        public boolean isItalicByDefault() {
            return false;
        }

        @Override
        public boolean isEnabledByDefault() {
            return false;
        }

        @Override
        public String getDisplayName() {
            return JavaEditorMessages.SemanticHighlighting_enums;
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public boolean consumes(SemanticToken token) {
            name = token.getNode();
            node = name.getParent();
            nodeType = node.getNodeType();
            if (nodeType == 32 || nodeType == 43 || nodeType == 75 || nodeType == 40 || nodeType == 40 || nodeType == 71) ** GOTO lbl9
            return false;
lbl-1000:
            // 1 sources

            {
                nodeType = (node = node.getParent()).getNodeType();
                if (nodeType != 26) continue;
                return false;
lbl9:
                // 2 sources

                ** while (nodeType == 40)
            }
lbl10:
            // 1 sources

            binding = token.getBinding();
            return binding instanceof ITypeBinding != false && ((ITypeBinding)binding).isEnum() != false;
        }
    }

    private static final class FieldHighlighting
    extends SemanticHighlighting {
        private FieldHighlighting() {
        }

        @Override
        public String getPreferenceKey() {
            return SemanticHighlightings.FIELD;
        }

        @Override
        public RGB getDefaultDefaultTextColor() {
            return new RGB(0, 0, 192);
        }

        @Override
        public boolean isBoldByDefault() {
            return false;
        }

        @Override
        public boolean isItalicByDefault() {
            return false;
        }

        @Override
        public boolean isEnabledByDefault() {
            return true;
        }

        @Override
        public String getDisplayName() {
            return JavaEditorMessages.SemanticHighlighting_field;
        }

        @Override
        public boolean consumes(SemanticToken token) {
            IBinding binding = token.getBinding();
            return binding != null && binding.getKind() == 3 && ((IVariableBinding)binding).isField();
        }
    }

    private static final class InheritedFieldHighlighting
    extends SemanticHighlighting {
        private InheritedFieldHighlighting() {
        }

        @Override
        public String getPreferenceKey() {
            return SemanticHighlightings.INHERITED_FIELD;
        }

        @Override
        public RGB getDefaultDefaultTextColor() {
            return new RGB(0, 0, 192);
        }

        @Override
        public boolean isBoldByDefault() {
            return false;
        }

        @Override
        public boolean isItalicByDefault() {
            return false;
        }

        @Override
        public boolean isEnabledByDefault() {
            return false;
        }

        @Override
        public String getDisplayName() {
            return JavaEditorMessages.SemanticHighlighting_inheritedField;
        }

        @Override
        public boolean consumes(SemanticToken token) {
            SimpleName node = token.getNode();
            if (node.isDeclaration()) {
                return false;
            }
            IBinding binding = token.getBinding();
            if (binding == null || binding.getKind() != 3) {
                return false;
            }
            ITypeBinding currentType = Bindings.getBindingOfParentType((ASTNode)node);
            ITypeBinding declaringType = ((IVariableBinding)binding).getDeclaringClass();
            if (declaringType == null || currentType == declaringType) {
                return false;
            }
            return Bindings.isSuperType(declaringType, currentType);
        }
    }

    private static final class InheritedMethodInvocationHighlighting
    extends SemanticHighlighting {
        private InheritedMethodInvocationHighlighting() {
        }

        @Override
        public String getPreferenceKey() {
            return SemanticHighlightings.INHERITED_METHOD_INVOCATION;
        }

        @Override
        public RGB getDefaultDefaultTextColor() {
            return new RGB(0, 0, 0);
        }

        @Override
        public boolean isBoldByDefault() {
            return false;
        }

        @Override
        public boolean isItalicByDefault() {
            return false;
        }

        @Override
        public boolean isEnabledByDefault() {
            return false;
        }

        @Override
        public String getDisplayName() {
            return JavaEditorMessages.SemanticHighlighting_inheritedMethodInvocation;
        }

        @Override
        public boolean consumes(SemanticToken token) {
            ITypeBinding declaringType;
            SimpleName node = token.getNode();
            if (node.isDeclaration()) {
                return false;
            }
            IBinding binding = token.getBinding();
            if (binding == null || binding.getKind() != 4) {
                return false;
            }
            ITypeBinding currentType = Bindings.getBindingOfParentType((ASTNode)node);
            if (currentType == (declaringType = ((IMethodBinding)binding).getDeclaringClass()) || currentType == null) {
                return false;
            }
            return Bindings.isSuperType(declaringType, currentType);
        }
    }

    private static final class InterfaceHighlighting
    extends SemanticHighlighting {
        private InterfaceHighlighting() {
        }

        @Override
        public String getPreferenceKey() {
            return SemanticHighlightings.INTERFACE;
        }

        @Override
        public RGB getDefaultDefaultTextColor() {
            return new RGB(50, 63, 112);
        }

        @Override
        public boolean isBoldByDefault() {
            return false;
        }

        @Override
        public boolean isItalicByDefault() {
            return false;
        }

        @Override
        public boolean isEnabledByDefault() {
            return false;
        }

        @Override
        public String getDisplayName() {
            return JavaEditorMessages.SemanticHighlighting_interfaces;
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public boolean consumes(SemanticToken token) {
            name = token.getNode();
            node = name.getParent();
            nodeType = node.getNodeType();
            if (nodeType == 43 || nodeType == 75 || nodeType == 40 || nodeType == 55) ** GOTO lbl9
            return false;
lbl-1000:
            // 1 sources

            {
                nodeType = (node = node.getParent()).getNodeType();
                if (nodeType != 26) continue;
                return false;
lbl9:
                // 2 sources

                ** while (nodeType == 40)
            }
lbl10:
            // 1 sources

            binding = token.getBinding();
            return binding instanceof ITypeBinding != false && ((ITypeBinding)binding).isInterface() != false;
        }
    }

    private static final class LocalVariableDeclarationHighlighting
    extends SemanticHighlighting {
        private LocalVariableDeclarationHighlighting() {
        }

        @Override
        public String getPreferenceKey() {
            return SemanticHighlightings.LOCAL_VARIABLE_DECLARATION;
        }

        @Override
        public RGB getDefaultDefaultTextColor() {
            return new RGB(106, 62, 62);
        }

        @Override
        public boolean isBoldByDefault() {
            return true;
        }

        @Override
        public boolean isItalicByDefault() {
            return false;
        }

        @Override
        public boolean isEnabledByDefault() {
            return false;
        }

        @Override
        public String getDisplayName() {
            return JavaEditorMessages.SemanticHighlighting_localVariableDeclaration;
        }

        @Override
        public boolean consumes(SemanticToken token) {
            ASTNode parent;
            SimpleName node = token.getNode();
            StructuralPropertyDescriptor location = node.getLocationInParent();
            if ((location == VariableDeclarationFragment.NAME_PROPERTY || location == SingleVariableDeclaration.NAME_PROPERTY) && (parent = node.getParent()) instanceof VariableDeclaration) {
                return (parent = parent.getParent()) == null || !(parent instanceof FieldDeclaration);
            }
            return false;
        }
    }

    private static final class LocalVariableHighlighting
    extends SemanticHighlighting {
        private LocalVariableHighlighting() {
        }

        @Override
        public String getPreferenceKey() {
            return SemanticHighlightings.LOCAL_VARIABLE;
        }

        @Override
        public RGB getDefaultDefaultTextColor() {
            return new RGB(106, 62, 62);
        }

        @Override
        public boolean isBoldByDefault() {
            return false;
        }

        @Override
        public boolean isItalicByDefault() {
            return false;
        }

        @Override
        public boolean isEnabledByDefault() {
            return true;
        }

        @Override
        public String getDisplayName() {
            return JavaEditorMessages.SemanticHighlighting_localVariable;
        }

        @Override
        public boolean consumes(SemanticToken token) {
            IBinding binding = token.getBinding();
            if (binding != null && binding.getKind() == 3 && !((IVariableBinding)binding).isField()) {
                ASTNode decl = token.getRoot().findDeclaringNode(binding);
                return decl instanceof VariableDeclaration;
            }
            return false;
        }
    }

    private static final class MethodDeclarationHighlighting
    extends SemanticHighlighting {
        private MethodDeclarationHighlighting() {
        }

        @Override
        public String getPreferenceKey() {
            return SemanticHighlightings.METHOD_DECLARATION;
        }

        @Override
        public RGB getDefaultDefaultTextColor() {
            return new RGB(0, 0, 0);
        }

        @Override
        public boolean isBoldByDefault() {
            return true;
        }

        @Override
        public boolean isItalicByDefault() {
            return false;
        }

        @Override
        public boolean isEnabledByDefault() {
            return false;
        }

        @Override
        public String getDisplayName() {
            return JavaEditorMessages.SemanticHighlighting_methodDeclaration;
        }

        @Override
        public boolean consumes(SemanticToken token) {
            StructuralPropertyDescriptor location = token.getNode().getLocationInParent();
            return location == MethodDeclaration.NAME_PROPERTY || location == AnnotationTypeMemberDeclaration.NAME_PROPERTY;
        }
    }

    private static final class MethodHighlighting
    extends SemanticHighlighting {
        private MethodHighlighting() {
        }

        @Override
        public String getPreferenceKey() {
            return SemanticHighlightings.METHOD;
        }

        @Override
        public RGB getDefaultDefaultTextColor() {
            return new RGB(0, 0, 0);
        }

        @Override
        public boolean isBoldByDefault() {
            return false;
        }

        @Override
        public boolean isItalicByDefault() {
            return false;
        }

        @Override
        public boolean isEnabledByDefault() {
            return false;
        }

        @Override
        public String getDisplayName() {
            return JavaEditorMessages.SemanticHighlighting_method;
        }

        @Override
        public boolean consumes(SemanticToken token) {
            IBinding binding = SemanticHighlightings.getBinding(token);
            return binding != null && binding.getKind() == 4;
        }
    }

    private static final class NumberHighlighting
    extends SemanticHighlighting {
        private NumberHighlighting() {
        }

        @Override
        public String getPreferenceKey() {
            return SemanticHighlightings.NUMBER;
        }

        @Override
        public RGB getDefaultDefaultTextColor() {
            return new RGB(42, 0, 255);
        }

        @Override
        public boolean isBoldByDefault() {
            return false;
        }

        @Override
        public boolean isItalicByDefault() {
            return false;
        }

        @Override
        public boolean isEnabledByDefault() {
            return false;
        }

        @Override
        public String getDisplayName() {
            return JavaEditorMessages.SemanticHighlighting_numbers;
        }

        @Override
        public boolean consumes(SemanticToken token) {
            return false;
        }

        @Override
        public boolean consumesLiteral(SemanticToken token) {
            Expression expr = token.getLiteral();
            return expr != null && expr.getNodeType() == 34;
        }
    }

    private static final class ParameterVariableHighlighting
    extends SemanticHighlighting {
        private ParameterVariableHighlighting() {
        }

        @Override
        public String getPreferenceKey() {
            return SemanticHighlightings.PARAMETER_VARIABLE;
        }

        @Override
        public RGB getDefaultDefaultTextColor() {
            return new RGB(106, 62, 62);
        }

        @Override
        public boolean isBoldByDefault() {
            return false;
        }

        @Override
        public boolean isItalicByDefault() {
            return false;
        }

        @Override
        public boolean isEnabledByDefault() {
            return false;
        }

        @Override
        public String getDisplayName() {
            return JavaEditorMessages.SemanticHighlighting_parameterVariable;
        }

        @Override
        public boolean consumes(SemanticToken token) {
            IBinding binding = token.getBinding();
            if (binding != null && binding.getKind() == 3 && !((IVariableBinding)binding).isField()) {
                ASTNode decl = token.getRoot().findDeclaringNode(binding);
                return decl != null && decl.getLocationInParent() == MethodDeclaration.PARAMETERS_PROPERTY;
            }
            return false;
        }
    }

    private static final class StaticFieldHighlighting
    extends SemanticHighlighting {
        private StaticFieldHighlighting() {
        }

        @Override
        public String getPreferenceKey() {
            return SemanticHighlightings.STATIC_FIELD;
        }

        @Override
        public RGB getDefaultDefaultTextColor() {
            return new RGB(0, 0, 192);
        }

        @Override
        public boolean isBoldByDefault() {
            return false;
        }

        @Override
        public boolean isItalicByDefault() {
            return true;
        }

        @Override
        public boolean isEnabledByDefault() {
            return true;
        }

        @Override
        public String getDisplayName() {
            return JavaEditorMessages.SemanticHighlighting_staticField;
        }

        @Override
        public boolean consumes(SemanticToken token) {
            IBinding binding = token.getBinding();
            return binding != null && binding.getKind() == 3 && ((IVariableBinding)binding).isField() && (binding.getModifiers() & 8) == 8;
        }
    }

    private static final class StaticFinalFieldHighlighting
    extends SemanticHighlighting {
        private StaticFinalFieldHighlighting() {
        }

        @Override
        public String getPreferenceKey() {
            return SemanticHighlightings.STATIC_FINAL_FIELD;
        }

        @Override
        public RGB getDefaultDefaultTextColor() {
            return new RGB(0, 0, 192);
        }

        @Override
        public boolean isBoldByDefault() {
            return true;
        }

        @Override
        public boolean isItalicByDefault() {
            return true;
        }

        @Override
        public boolean isEnabledByDefault() {
            return true;
        }

        @Override
        public String getDisplayName() {
            return JavaEditorMessages.SemanticHighlighting_staticFinalField;
        }

        @Override
        public boolean consumes(SemanticToken token) {
            IBinding binding = token.getBinding();
            return binding != null && binding.getKind() == 3 && ((IVariableBinding)binding).isField() && (binding.getModifiers() & 0x18) == 24;
        }
    }

    private static final class StaticMethodInvocationHighlighting
    extends SemanticHighlighting {
        private StaticMethodInvocationHighlighting() {
        }

        @Override
        public String getPreferenceKey() {
            return SemanticHighlightings.STATIC_METHOD_INVOCATION;
        }

        @Override
        public RGB getDefaultDefaultTextColor() {
            return new RGB(0, 0, 0);
        }

        @Override
        public boolean isBoldByDefault() {
            return false;
        }

        @Override
        public boolean isItalicByDefault() {
            return true;
        }

        @Override
        public boolean isEnabledByDefault() {
            return true;
        }

        @Override
        public String getDisplayName() {
            return JavaEditorMessages.SemanticHighlighting_staticMethodInvocation;
        }

        @Override
        public boolean consumes(SemanticToken token) {
            SimpleName node = token.getNode();
            if (node.isDeclaration()) {
                return false;
            }
            IBinding binding = token.getBinding();
            return binding != null && binding.getKind() == 4 && (binding.getModifiers() & 8) == 8;
        }
    }

    private static final class TypeArgumentHighlighting
    extends SemanticHighlighting {
        private TypeArgumentHighlighting() {
        }

        @Override
        public String getPreferenceKey() {
            return SemanticHighlightings.TYPE_ARGUMENT;
        }

        @Override
        public RGB getDefaultDefaultTextColor() {
            return new RGB(13, 100, 0);
        }

        @Override
        public boolean isBoldByDefault() {
            return false;
        }

        @Override
        public boolean isItalicByDefault() {
            return false;
        }

        @Override
        public boolean isEnabledByDefault() {
            return false;
        }

        @Override
        public String getDisplayName() {
            return JavaEditorMessages.SemanticHighlighting_typeArguments;
        }

        @Override
        public boolean consumes(SemanticToken token) {
            SimpleName name = token.getNode();
            ASTNode node = name.getParent();
            int nodeType = node.getNodeType();
            if (nodeType != 43 && nodeType != 75) {
                return false;
            }
            StructuralPropertyDescriptor locationInParent = node.getLocationInParent();
            return locationInParent == ParameterizedType.TYPE_ARGUMENTS_PROPERTY;
        }
    }

    private static final class TypeVariableHighlighting
    extends SemanticHighlighting {
        private TypeVariableHighlighting() {
        }

        @Override
        public String getPreferenceKey() {
            return SemanticHighlightings.TYPE_VARIABLE;
        }

        @Override
        public RGB getDefaultDefaultTextColor() {
            return new RGB(100, 70, 50);
        }

        @Override
        public boolean isBoldByDefault() {
            return true;
        }

        @Override
        public boolean isItalicByDefault() {
            return false;
        }

        @Override
        public boolean isEnabledByDefault() {
            return false;
        }

        @Override
        public String getDisplayName() {
            return JavaEditorMessages.SemanticHighlighting_typeVariables;
        }

        @Override
        public boolean consumes(SemanticToken token) {
            SimpleName name = token.getNode();
            ASTNode node = name.getParent();
            if (node.getNodeType() != 43 && node.getNodeType() != 73) {
                return false;
            }
            IBinding binding = token.getBinding();
            return binding instanceof ITypeBinding && ((ITypeBinding)binding).isTypeVariable();
        }
    }
}

