/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.helper;

import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.pivot.util.PivotPlugin;

public class HelperUtil {
    static final int NONE = -1;
    static final String OCL_COMMENT = "--";
    static final String PATH_DELIMETER = "(=> ";
    static final String PACKAGE = "package";
    static final String COLON = ":";
    static final String DOUBLE_COLON = "::";
    static final String DOT = ".";
    static final String ARROW = "->";
    static final String CARET = "^";
    static final String DOUBLE_CARET = "^^";
    static final String EMPTY = "";
    static final String HTTP = "http://";
    public static final @NonNull String EMPTY_STRING = "";
    private static final @NonNull String PREFIX_THROWING = "THROWN ";
    private static final @NonNull String SEPARATOR_SPACE = " ";
    private static final @NonNull String PARENTHESIS_OPEN = "(";
    private static final @NonNull String PARENTHESIS_CLOSE = ")";
    private static final @NonNull String SEPARATOR_METHOD = "#";
    private static final @NonNull String PREFIX_CATCHING = "CAUGHT ";
    private static boolean traceAll = Boolean.getBoolean("org.eclipse.ocl.debug");

    private HelperUtil() {
    }

    static void throwException(RuntimeException exception, Class<?> clazz, String methodName) {
        HelperUtil.throwing(clazz, methodName, exception);
        throw exception;
    }

    static void catchException(Exception exception, Class<?> clazz, String methodName) {
        HelperUtil.catching(clazz, methodName, exception);
    }

    public static void catching(Class<?> clazz, String methodName, Throwable throwable) {
        if (HelperUtil.shouldTrace("org.eclipse.ocl.pivot/debug/exceptions/catching")) {
            HelperUtil.trace(PREFIX_CATCHING + throwable.getMessage() + SEPARATOR_SPACE + PARENTHESIS_OPEN + clazz.getName() + SEPARATOR_METHOD + methodName + PARENTHESIS_CLOSE);
            throwable.printStackTrace(System.err);
        }
    }

    public static void throwing(Class<?> clazz, String methodName, Throwable throwable) {
        if (HelperUtil.shouldTrace("org.eclipse.ocl.pivot/debug/exceptions/throwing")) {
            HelperUtil.trace(PREFIX_THROWING + throwable.getMessage() + SEPARATOR_SPACE + PARENTHESIS_OPEN + clazz.getName() + SEPARATOR_METHOD + methodName + PARENTHESIS_CLOSE);
            throwable.printStackTrace(System.err);
        }
    }

    public static boolean shouldTrace(String option) {
        if (PivotPlugin.getPlugin() != null) {
            if (PivotPlugin.getPlugin().isDebugging()) {
                return Boolean.TRUE.toString().equalsIgnoreCase(Platform.getDebugOption((String)option));
            }
            return false;
        }
        return traceAll || Boolean.getBoolean(option);
    }

    public static void trace(String message) {
        System.out.println("[OCL] " + message);
    }

    public static void error(int code, String message) {
        HelperUtil.error(code, message, null);
    }

    public static void error(int code, String message, Throwable throwable) {
        HelperUtil.log(4, code, message, throwable);
    }

    public static void info(String message) {
        HelperUtil.info(0, message);
    }

    public static void info(int code, String message) {
        HelperUtil.info(code, message, null);
    }

    public static void info(int code, String message, Throwable throwable) {
        HelperUtil.log(1, code, message, throwable);
    }

    public static void warning(int code, String message) {
        HelperUtil.warning(code, message, null);
    }

    public static void warning(int code, String message, Throwable throwable) {
        HelperUtil.log(2, code, message, throwable);
    }

    public static void log(int severity, int code, String message, Throwable throwable) {
        String msg = message == null ? "" : message;
        try {
            if (PivotPlugin.getPlugin() != null) {
                PivotPlugin.getPlugin().log(new Status(severity, "org.eclipse.ocl.pivot", code, msg, throwable));
            } else if (HelperUtil.shouldTrace("org.eclipse.ocl.pivot/debug")) {
                switch (code) {
                    case 2: {
                        System.err.print("WARNING ");
                        break;
                    }
                    case 4: 
                    case 8: {
                        System.err.print("ERROR ");
                        break;
                    }
                    default: {
                        return;
                    }
                }
                System.err.print(code);
                System.err.print(": ");
                System.err.println(message);
                if (throwable != null) {
                    throwable.printStackTrace(System.err);
                }
            }
        }
        catch (IllegalArgumentException iae) {
            HelperUtil.catching(HelperUtil.class, "log", iae);
        }
    }
}

