/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.library;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.CollectionType;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.evaluation.Executor;
import org.eclipse.ocl.pivot.evaluation.ModelManager;
import org.eclipse.ocl.pivot.ids.TypeId;
import org.eclipse.ocl.pivot.library.AbstractProperty;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.values.InvalidValueException;

public class ImplicitNonCompositionProperty
extends AbstractProperty {
    protected @NonNull Property property;

    public ImplicitNonCompositionProperty(@NonNull Property property) {
        this.property = property;
    }

    @Override
    public @Nullable Object evaluate(@NonNull Executor executor, @NonNull TypeId returnTypeId, @Nullable Object sourceValue) {
        ModelManager.ModelManagerExtension modelManager = (ModelManager.ModelManagerExtension)executor.getModelManager();
        Property thatProperty = this.property.getOpposite();
        Type thatType = ClassUtil.nonNullModel(this.property.getType());
        boolean isMany = thatType instanceof CollectionType;
        if (isMany) {
            thatType = ((CollectionType)thatType).getElementType();
        }
        ArrayList<Object> results = new ArrayList<Object>();
        if (thatType instanceof Class) {
            for (Object object : modelManager.get((Class)thatType)) {
                EClass eClass = modelManager.eClass(object);
                EStructuralFeature eFeature = eClass.getEStructuralFeature(thatProperty.getName());
                assert (eFeature != null);
                Object eGet = modelManager.eGet(object, eFeature);
                if (eFeature.isMany()) {
                    assert (eGet != null);
                    for (Object eReference : (List)eGet) {
                        if (eReference != sourceValue) continue;
                        results.add(object);
                    }
                    continue;
                }
                if (eGet != sourceValue) continue;
                results.add(object);
            }
        }
        if (isMany) {
            return executor.getIdResolver().createCollectionOfAll(false, false, returnTypeId, results);
        }
        if (results.size() == 0) {
            return null;
        }
        if (results.size() == 1) {
            return results.get(0);
        }
        throw new InvalidValueException("Multiple opposites for " + this.property, new Object[0]);
    }
}

