/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.core.resource;

import java.util.Collections;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.papyrus.infra.core.Activator;
import org.eclipse.papyrus.infra.core.resource.EMFLogicalModel;
import org.eclipse.papyrus.infra.core.resource.IModel;
import org.eclipse.papyrus.infra.core.resource.IModelSnippet;
import org.eclipse.papyrus.infra.core.resource.ResourceAdapter;

public class AdjunctResourceModelSnippet
implements IModelSnippet {
    private EMFLogicalModel model;
    private Adapter adapter;

    @Override
    public void start(IModel startingModel) {
        if (startingModel instanceof EMFLogicalModel) {
            this.model = (EMFLogicalModel)startingModel;
            this.adapter = new ResourceAdapter(){

                @Override
                protected void handleResourceLoaded(Resource resource) {
                    AdjunctResourceModelSnippet.this.maybeLoadAdjunctResource(resource);
                }
            };
            this.model.getModelManager().eAdapters().add((Object)this.adapter);
        }
    }

    @Override
    public void dispose(IModel stoppingModel) {
        if (stoppingModel == this.model && this.adapter != null) {
            this.model.getModelManager().eAdapters().remove((Object)this.adapter);
            this.adapter = null;
            this.model = null;
        }
    }

    void maybeLoadAdjunctResource(Resource resource) {
        if (this.model != null && !this.model.isRelatedResource(resource)) {
            URIConverter converter;
            URI adjunctURI = resource.getURI().trimFileExtension().appendFileExtension(this.model.getModelFileExtension());
            ResourceSet resourceSet = resource.getResourceSet();
            boolean adjunctAlreadyLoaded = false;
            for (Resource loadedResource : resourceSet.getResources()) {
                if (!loadedResource.getURI().equals(adjunctURI)) continue;
                adjunctAlreadyLoaded = true;
                break;
            }
            if (!adjunctAlreadyLoaded && resourceSet.getURIConverter() != null && (converter = resourceSet.getURIConverter()).exists(adjunctURI, Collections.emptyMap())) {
                try {
                    resourceSet.getResource(adjunctURI, true);
                }
                catch (Exception e) {
                    Activator.log.error(String.format("Failed to load %s resource", this.model.getModelFileExtension()), (Throwable)e);
                }
            }
        }
    }
}

