/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.tools.editor.c.expression.tests;

import com.google.common.base.Charsets;
import com.google.common.io.Files;
import com.google.inject.Inject;
import eu.fbk.tools.editor.c.expression.expression.Expression;
import eu.fbk.tools.editor.c.expression.expression.PostfixExpression;
import eu.fbk.tools.editor.c.expression.tests.ExpressionInjectorProvider;
import java.io.File;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.serializer.ISerializer;
import org.eclipse.xtext.testing.InjectWith;
import org.eclipse.xtext.testing.XtextRunner;
import org.eclipse.xtext.testing.util.ParseHelper;
import org.eclipse.xtext.testing.validation.ValidationTestHelper;
import org.eclipse.xtext.validation.Issue;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ErrorCollector;
import org.junit.runner.RunWith;

@RunWith(value=XtextRunner.class)
@InjectWith(value=ExpressionInjectorProvider.class)
public class ExpressionParsingTest {
    @Inject
    private ParseHelper<Expression> parseHelper;
    @Inject
    private ValidationTestHelper validationHelper;
    @Inject
    private ISerializer serializer;
    @Rule
    public ErrorCollector collector = new ErrorCollector();

    @Before
    public void beforeTest() {
    }

    @Test
    public void testPostfixExpression() {
        try {
            String[] values;
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("A[1]");
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append("A[1][1]");
            StringConcatenation _builder_2 = new StringConcatenation();
            _builder_2.append("A[1+1]");
            StringConcatenation _builder_3 = new StringConcatenation();
            _builder_3.append("A[1>>1]");
            StringConcatenation _builder_4 = new StringConcatenation();
            _builder_4.append("A[i+j]");
            StringConcatenation _builder_5 = new StringConcatenation();
            _builder_5.append("F()");
            StringConcatenation _builder_6 = new StringConcatenation();
            _builder_6.append("F(a,b)");
            StringConcatenation _builder_7 = new StringConcatenation();
            _builder_7.append("F(1,b)");
            StringConcatenation _builder_8 = new StringConcatenation();
            _builder_8.append("F(a+b,c)");
            StringConcatenation _builder_9 = new StringConcatenation();
            _builder_9.append("A.f()");
            StringConcatenation _builder_10 = new StringConcatenation();
            _builder_10.append("A[0].f()");
            StringConcatenation _builder_11 = new StringConcatenation();
            _builder_11.append("A[0].f(a,b)");
            String[] stringArray = values = new String[]{_builder.toString(), _builder_1.toString(), _builder_2.toString(), _builder_3.toString(), _builder_4.toString(), _builder_5.toString(), _builder_6.toString(), _builder_7.toString(), _builder_8.toString(), _builder_9.toString(), _builder_10.toString(), _builder_11.toString()};
            int n = values.length;
            int n2 = 0;
            while (n2 < n) {
                String value = stringArray[n2];
                Expression result = (Expression)this.parseHelper.parse((CharSequence)value);
                Assert.assertTrue((String)(String.valueOf(value) + " : Invalid type"), (boolean)(result instanceof PostfixExpression));
                this.validate(value, (EObject)result, true);
                ++n2;
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    @Test(timeout=300000L)
    public void loadModel() {
        try {
            String userDir = System.getProperty("user.dir");
            String resourceDir = String.valueOf(userDir) + "/resources";
            File folder = new File(resourceDir);
            Object[] listOfFiles = folder.listFiles();
            Arrays.sort(listOfFiles);
            int files = listOfFiles.length;
            System.out.println("Found " + Integer.valueOf(files) + " models to be tested");
            int i = 1;
            Object[] objectArray = listOfFiles;
            int n = listOfFiles.length;
            int n2 = 0;
            while (n2 < n) {
                Object file = objectArray[n2];
                String txt = Files.toString((File)file, (Charset)Charsets.UTF_8);
                Expression model = (Expression)this.parseHelper.parse((CharSequence)txt);
                String _name = ((File)file).getName();
                String _plus = "[" + Integer.valueOf(i) + "/" + Integer.valueOf(files) + "]" + "Processing model: " + _name;
                System.out.println(_plus);
                ++i;
                try {
                    String _name_1 = ((File)file).getName();
                    String _plus_1 = String.valueOf(_name_1) + " : ";
                    String _plus_2 = String.valueOf(_plus_1) + " parse failed";
                    Assert.assertNotNull((String)_plus_2, (Object)model);
                }
                catch (Throwable _t) {
                    if (_t instanceof Throwable) {
                        Throwable t = _t;
                        this.collector.addError(t);
                    }
                    throw Exceptions.sneakyThrow((Throwable)_t);
                }
                if (model != null) {
                    boolean _greaterThan;
                    List issues = this.validationHelper.validate((EObject)model);
                    int _length = ((Object[])Conversions.unwrapArray((Object)issues, Object.class)).length;
                    boolean bl = _greaterThan = _length > 0;
                    if (_greaterThan) {
                        for (Issue issue : issues) {
                            try {
                                String _name_2 = ((File)file).getName();
                                String _plus_3 = String.valueOf(_name_2) + " : ";
                                String _string = issue.toString();
                                String _plus_4 = String.valueOf(_plus_3) + _string;
                                Assert.fail((String)_plus_4);
                            }
                            catch (Throwable _t_1) {
                                if (_t_1 instanceof Throwable) {
                                    Throwable t_1 = _t_1;
                                    this.collector.addError(t_1);
                                    continue;
                                }
                                throw Exceptions.sneakyThrow((Throwable)_t_1);
                            }
                        }
                    }
                }
                ++n2;
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    private void validate(String originalValue, EObject correspondingObject, boolean isValid) {
        if (isValid) {
            List issues = this.validationHelper.validate(correspondingObject);
            Assert.assertTrue((String)(String.valueOf(originalValue) + " : Invalid type. " + issues), (boolean)issues.isEmpty());
            String serializeInput = this.serializer.serialize(correspondingObject);
            Assert.assertEquals((String)("serialization differs from original value:\n" + serializeInput + "\n !=\n" + originalValue), (Object)serializeInput, (Object)originalValue);
        } else {
            List issues_1 = this.validationHelper.validate(correspondingObject);
            Assert.assertFalse((String)(String.valueOf(originalValue) + " : Valid type. Should be invalid "), (boolean)issues_1.isEmpty());
        }
    }
}

