/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.chess.OSSImporter.core.utils;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForEObject;
import org.eclipse.papyrus.infra.services.labelprovider.service.LabelProviderService;
import org.eclipse.papyrus.infra.services.navigation.service.ExtendedNavigableElement;
import org.eclipse.papyrus.infra.services.navigation.service.NavigableElement;
import org.eclipse.papyrus.infra.services.navigation.service.NavigationService;
import org.eclipse.papyrus.infra.services.viewersearch.impl.ViewerSearchService;
import org.eclipse.papyrus.sysml.portandflows.FlowDirection;
import org.eclipse.papyrus.sysml.portandflows.FlowPort;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.FunctionBehavior;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.Type;
import org.polarsys.chess.contracts.profile.chesscontract.Contract;
import org.polarsys.chess.contracts.profile.chesscontract.ContractProperty;
import org.polarsys.chess.contracts.profile.chesscontract.FormalProperty;
import org.polarsys.chess.contracts.profile.chesscontract.util.ContractEntityUtil;
import org.polarsys.chess.contracts.profile.chesscontract.util.EntityUtil;
import org.polarsys.chess.service.core.model.ChessSystemModel;

public class ChessElementsUtil {
    private static final Logger logger = Logger.getLogger(ChessElementsUtil.class);
    private final ChessSystemModel chessSystemModel = ChessSystemModel.getInstance();
    private final EntityUtil entityUtil = EntityUtil.getInstance();
    private final ContractEntityUtil contractEntityUtil = ContractEntityUtil.getInstance();
    private static ChessElementsUtil chessElementsUtilInstance;
    protected static boolean isLocalLabelProvider;

    public static ChessElementsUtil getInstance() {
        if (chessElementsUtilInstance == null) {
            chessElementsUtilInstance = new ChessElementsUtil();
        }
        return chessElementsUtilInstance;
    }

    public void updateUmlFunctionBehaviour(FunctionBehavior functionBehavior, EList<Type> inputTypes, EList<String[]> inputMultiplicities, Type outputType, String[] outputMultiplicity, HashMap<String, Boolean> mapFunctionBehaviorsToKeep) {
        EList existingFunctionBehaviorParameters = functionBehavior.getOwnedParameters();
        BasicEList toRemoveFunctionBehaviorParameters = new BasicEList((Collection)existingFunctionBehaviorParameters);
        for (Parameter parameter : toRemoveFunctionBehaviorParameters) {
            this.entityUtil.removeFunctionBehaviorParameter(existingFunctionBehaviorParameters, parameter.getQualifiedName());
        }
        this.entityUtil.createUmlFunctionBehaviorParameters(functionBehavior, inputTypes, inputMultiplicities, outputType, outputMultiplicity);
        mapFunctionBehaviorsToKeep.put(functionBehavior.getQualifiedName(), Boolean.TRUE);
    }

    public void updateUmlStaticPort(Port port, String[] newMultiplicityRange, HashMap<String, Boolean> mapPortsToKeep) {
        this.entityUtil.updateUmlStaticPort(port, newMultiplicityRange);
        mapPortsToKeep.put(port.getQualifiedName(), Boolean.TRUE);
    }

    public void updateUmlNonStaticPort(Port port, eu.fbk.tools.editor.oss.oss.Port ossPort, Type newType, String[] newMultiplicityRange, FlowDirection portDirection, Stereotype flowPortStereotype, HashMap<String, Boolean> mapPortsToKeep) {
        FlowPort flowPort = (FlowPort)port.getStereotypeApplication(flowPortStereotype);
        if (flowPort.getDirection() != portDirection) {
            flowPort.setDirection(portDirection);
        }
        this.entityUtil.updateUmlNonStaticPort(port, newType, newMultiplicityRange);
        mapPortsToKeep.put(port.getQualifiedName(), Boolean.TRUE);
    }

    public void updateUmlRefinementFormalProperty(Constraint umlConstraint, String updatedText, String language, HashMap<String, Boolean> mapFormalPropertiesToKeep) {
        this.entityUtil.updateUmlConstraint(umlConstraint, updatedText, language);
        mapFormalPropertiesToKeep.put(umlConstraint.getQualifiedName(), Boolean.TRUE);
    }

    public void updateUmlFormalProperty(Constraint umlConstraint, String assertionText, String language, HashMap<String, FormalProperty> hashFormalProperties, HashMap<String, Boolean> mapFormalPropertiesToKeep) {
        String formalPropertyText = this.entityUtil.getConstraintBodyStr(umlConstraint, language);
        if (!assertionText.equals(formalPropertyText)) {
            this.entityUtil.setTextInUMLConstraint(umlConstraint, assertionText, language);
        }
        mapFormalPropertiesToKeep.put(umlConstraint.getQualifiedName(), Boolean.TRUE);
    }

    public void updateUmlContract(Class umlContract, String ossAssumptionText, String ossGuaranteeText, String language, HashMap<String, FormalProperty> hashFormalProperties, HashMap<String, Boolean> mapContractPropertiesToKeep, HashMap<String, Boolean> mapFormalPropertiesToKeep, Class owner) {
        FormalProperty hashGuarantee;
        Contract contract = this.contractEntityUtil.getContract(umlContract);
        FormalProperty contractAssumption = contract.getAssume();
        FormalProperty contractGuarantee = contract.getGuarantee();
        FormalProperty hashAssumption = hashFormalProperties.get(ossAssumptionText);
        if (hashAssumption != null) {
            logger.debug((Object)("assumption already present in the hash = " + hashAssumption));
            if (hashAssumption != contractAssumption) {
                if (contractAssumption.getBase_Constraint().getOwner() == contract.getBase_Class()) {
                    BasicEList fpList = new BasicEList();
                    fpList.add((Object)contractAssumption.getBase_Constraint());
                    this.entityUtil.removeFormalProperty((EList)fpList, contractAssumption.getBase_Constraint().getQualifiedName());
                }
                contract.setAssume(hashAssumption);
            }
        } else {
            logger.debug((Object)"assumption not present in the hash");
            if (contractAssumption.getBase_Constraint().getOwner() == contract.getBase_Class()) {
                this.entityUtil.updateUmlConstraint(contractAssumption.getBase_Constraint(), ossAssumptionText, language);
            } else {
                this.contractEntityUtil.createAssumptionToUmlContract(umlContract);
                FormalProperty assumptionFormalProperty = this.contractEntityUtil.getAssumeFromUmlContract(umlContract);
                this.entityUtil.setTextInUMLConstraint(assumptionFormalProperty.getBase_Constraint(), ossAssumptionText, language);
            }
        }
        if ((hashGuarantee = hashFormalProperties.get(ossGuaranteeText)) != null) {
            logger.debug((Object)("guarantee already present in the hash = " + hashGuarantee));
            if (hashGuarantee != contractGuarantee) {
                if (contractGuarantee.getBase_Constraint().getOwner() == contract.getBase_Class()) {
                    BasicEList fpList = new BasicEList();
                    fpList.add((Object)contractGuarantee.getBase_Constraint());
                    this.entityUtil.removeFormalProperty((EList)fpList, contractGuarantee.getBase_Constraint().getQualifiedName());
                }
                contract.setGuarantee(hashGuarantee);
            }
        } else {
            logger.debug((Object)"guarantee not present in the hash");
            if (contractGuarantee.getBase_Constraint().getOwner() == contract.getBase_Class()) {
                this.entityUtil.updateUmlConstraint(contractGuarantee.getBase_Constraint(), ossGuaranteeText, language);
            } else {
                this.contractEntityUtil.createGuaranteeToUmlContract(umlContract);
                FormalProperty guaranteeFormalProperty = this.contractEntityUtil.getGuaranteeFromUmlContract(umlContract);
                this.entityUtil.setTextInUMLConstraint(guaranteeFormalProperty.getBase_Constraint(), ossGuaranteeText, language);
            }
        }
        ContractProperty contractProperty = (ContractProperty)this.chessSystemModel.getContract((Object)owner, umlContract.getName());
        mapContractPropertiesToKeep.put(contractProperty.getBase_Property().getQualifiedName(), Boolean.TRUE);
    }

    public void updateUmlAssociation(Property componentInstance, Type type, String[] ossSubComponentMultiplicity, HashMap<String, Boolean> mapComponentInstancesToKeep) throws Exception {
        this.entityUtil.updateUmlAssociation(componentInstance, type, ossSubComponentMultiplicity);
        mapComponentInstancesToKeep.put(componentInstance.getQualifiedName(), Boolean.TRUE);
    }

    public Constraint createUmlInterfaceFormalProperty(String assertionName, String assertionText, HashMap<String, FormalProperty> hashFormalProperties, Class owner) {
        Constraint umlConstraint = this.entityUtil.createInterfaceFormalProperty(owner, assertionName, assertionText);
        hashFormalProperties.put(assertionName, this.entityUtil.getFormalProperty(umlConstraint));
        return umlConstraint;
    }

    public Class createUmlContract(String contractName, String ossAssumptionText, String ossGuaranteeText, HashMap<String, FormalProperty> hashFormalProperties, Class owner, Stereotype contractStereotype) {
        Class umlContract = this.contractEntityUtil.createContract(owner, contractName, contractStereotype);
        Contract contract = this.contractEntityUtil.getContract(umlContract);
        FormalProperty assumption = hashFormalProperties.get(ossAssumptionText);
        if (assumption != null) {
            logger.debug((Object)("assumption already present = " + assumption));
            contract.setAssume(assumption);
        } else {
            logger.debug((Object)"assumption not present");
            this.contractEntityUtil.setTextToAssumeOrCreateAssume(ossAssumptionText, umlContract);
        }
        FormalProperty guarantee = hashFormalProperties.get(ossGuaranteeText);
        if (guarantee != null) {
            logger.debug((Object)("guarantee already present = " + guarantee));
            contract.setGuarantee(guarantee);
        } else {
            logger.debug((Object)"guarantee not present");
            this.contractEntityUtil.setTextToGuaranteeOrCreateGuarantee(ossGuaranteeText, umlContract);
        }
        return umlContract;
    }

    public void updateMacroDefinition(Constraint umlConstraint, String macroDefinitionExpression, String language, HashMap<String, Boolean> mapMacroDefinitionsToKeep) {
        this.entityUtil.updateMacroDefinition(umlConstraint, macroDefinitionExpression, language);
        mapMacroDefinitionsToKeep.put(umlConstraint.getQualifiedName(), Boolean.TRUE);
    }

    public Set<String> getInvolvedDiagrams(EList<?> members, String qualifiedElement) {
        HashSet<String> diagramNames = new HashSet<String>();
        for (Object object : members) {
            NamedElement element = null;
            if (object instanceof NamedElement) {
                element = (NamedElement)object;
            } else if (object instanceof ContractProperty) {
                element = ((ContractProperty)object).getBase_Property();
            }
            if (element != null && element instanceof NamedElement) {
                if (!element.getQualifiedName().equals(qualifiedElement)) continue;
                try {
                    List navigableElements;
                    NavigationService navigationService = null;
                    try {
                        ServicesRegistry registry = ServiceUtilsForEObject.getInstance().getServiceRegistry((EObject)element);
                        if (registry != null) {
                            navigationService = (NavigationService)registry.getService(NavigationService.class);
                        }
                    }
                    catch (ServiceException e) {
                        e.printStackTrace();
                    }
                    if (navigationService == null || (navigableElements = navigationService.getNavigableElements((Object)element)) == null) break;
                    for (NavigableElement navigableElement : navigableElements) {
                        List<Object> viewsToSelect = this.getViewsToSelect(navigableElement, false);
                        for (Object view : viewsToSelect) {
                            diagramNames.add(ChessElementsUtil.getText(view));
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                break;
            }
            logger.debug((Object)("cannot find a reprentation for " + qualifiedElement));
        }
        return diagramNames;
    }

    private static String getText(Object element) {
        if (element instanceof NavigableElement) {
            return ((NavigableElement)element).getLabel();
        }
        if (element instanceof EObject) {
            return ChessElementsUtil.getName((EObject)element);
        }
        return element.toString();
    }

    private static String getName(EObject element) {
        ILabelProvider labelProvider = ChessElementsUtil.getLabelProvider(element);
        String name = labelProvider.getText((Object)element);
        if (isLocalLabelProvider) {
            labelProvider.dispose();
        }
        if (name != null) {
            return name;
        }
        return element.toString();
    }

    private static ILabelProvider getLabelProvider(EObject element) {
        ILabelProvider labelProvider = null;
        try {
            labelProvider = ((LabelProviderService)ServiceUtilsForEObject.getInstance().getService(LabelProviderService.class, (Object)element)).getLabelProvider("org.eclipse.papyrus.infra.services.navigation.menu.labelprovider");
        }
        catch (ServiceException e) {
            e.printStackTrace();
        }
        if (labelProvider == null) {
            labelProvider = new LabelProvider();
            isLocalLabelProvider = true;
        } else {
            isLocalLabelProvider = false;
        }
        return labelProvider;
    }

    private List<Object> getViewsToSelect(NavigableElement navElement, boolean onlyOpened) {
        if (navElement == null) {
            return null;
        }
        EObject element = null;
        if (navElement instanceof ExtendedNavigableElement && ((ExtendedNavigableElement)navElement).getSemanticElement() instanceof EObject) {
            element = (EObject)((ExtendedNavigableElement)navElement).getSemanticElement();
        }
        if (element != null) {
            ViewerSearchService viewerSearchService = null;
            try {
                viewerSearchService = (ViewerSearchService)ServiceUtilsForEObject.getInstance().getService(ViewerSearchService.class, element);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (viewerSearchService != null) {
                return viewerSearchService.getViewersInCurrentModel(element, null, false, onlyOpened);
            }
        }
        return new LinkedList<Object>();
    }
}

