/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.eclipse.standardtools.constraintEditor.constraintTab;

import eu.fbk.eclipse.standardtools.utils.core.model.AbstractSystemModel;
import eu.fbk.eclipse.standardtools.xtextService.core.utils.XtextElementsUtil;
import eu.fbk.eclipse.standardtools.xtextService.ui.utils.XTextEditorViewer;
import eu.fbk.eclipse.standardtools.xtextService.ui.utils.XTextEditorViewer_constraint;
import java.io.IOException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.tabbed.AbstractPropertySection;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public abstract class ConstraintEditorTab
extends AbstractPropertySection {
    private Object constraint;
    private XTextEditorViewer_constraint xTextEditorViewer;
    private ISelectionChangedListener postTextChangedListener;
    private Text constraintNameLabel;
    private AbstractSystemModel systemModel = this.getSystemModel();
    private XtextElementsUtil xtextElementsUtil = XtextElementsUtil.getInstance((AbstractSystemModel)this.systemModel);

    public abstract AbstractSystemModel getSystemModel();

    public void setInput(IWorkbenchPart part, ISelection sel) {
        this.cleanEditorView();
        Object constraint = this.returnConstraint(sel);
        if (constraint != null) {
            this.constraint = constraint;
            this.constraintNameLabel.setText(this.systemModel.getConstraintQualifiedName(constraint));
            this.xTextEditorViewer.setEditorText(this.getStrFromConstraint(constraint));
            this.updatePorts();
        }
    }

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedConstraintSheetPage) {
        Composite composite = this.createGUI(parent, aTabbedConstraintSheetPage.getSite().getPage());
        this.xTextEditorViewer = new XTextEditorViewer_constraint(composite, 4);
        this.initEditorListener();
    }

    public abstract String getStrFromConstraint(Object var1);

    public abstract Resource getResourceFromConstraint(Object var1);

    public abstract Object returnConstraint(ISelection var1);

    public abstract void constraintEditorchanged(Object var1, String var2);

    private void initEditorListener() {
        if (this.postTextChangedListener == null) {
            this.postTextChangedListener = new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    if (ConstraintEditorTab.this.xTextEditorViewer.isEditorEditable()) {
                        String textChanged = ConstraintEditorTab.this.xTextEditorViewer.getEditorText();
                        ConstraintEditorTab.this.constraintEditorchanged(ConstraintEditorTab.this.constraint, textChanged);
                        try {
                            ConstraintEditorTab.this.xTextEditorViewer.showRuntimeErrors(textChanged, ConstraintEditorTab.this.constraint, ConstraintEditorTab.this.getResourceFromConstraint(ConstraintEditorTab.this.constraint));
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
            };
        }
        this.xTextEditorViewer.assignPostTextChangedListener(this.postTextChangedListener);
    }

    private void updatePorts() {
        String[] subCompNames;
        Object component = this.systemModel.getNearestOwnerComponent(this.constraint);
        XTextEditorViewer.enableCheckOnVariables();
        XTextEditorViewer.setBooleanCheck((boolean)false);
        XTextEditorViewer.cleanPorts();
        XTextEditorViewer.cleanParameters();
        XTextEditorViewer.addPorts((EList)this.xtextElementsUtil.getXTextPortsFromComponent(component));
        XTextEditorViewer.addParameters((EList)this.xtextElementsUtil.getXTextParametersFromComponent(component));
        String[] stringArray = subCompNames = this.systemModel.getSubComponentsName(component);
        int n = subCompNames.length;
        int n2 = 0;
        while (n2 < n) {
            EList subCompUnintfuncts;
            EList subCompStaticPorts;
            String subCompName = stringArray[n2];
            Object subComp = this.systemModel.getSubComponent(component, subCompName);
            EList subCompPorts = this.systemModel.getNonStaticPorts(subComp);
            if (subCompPorts != null && subCompPorts.size() != 0) {
                XTextEditorViewer_constraint.addPorts((String)subCompName, (EList)this.xtextElementsUtil.getXTextPorts(subCompPorts));
            }
            if ((subCompStaticPorts = this.systemModel.getStaticPorts(subComp)) != null && subCompStaticPorts.size() != 0) {
                XTextEditorViewer_constraint.addParameters((String)subCompName, (EList)this.xtextElementsUtil.getXTextParametersFromStaticPorts(subCompStaticPorts));
            }
            if ((subCompUnintfuncts = this.systemModel.getUninterpretedFunctions(subComp)) != null && subCompUnintfuncts.size() != 0) {
                XTextEditorViewer_constraint.addParameters((String)subCompName, (EList)this.xtextElementsUtil.getXTextParametersFromUninterpretedFunctions(subCompUnintfuncts));
            }
            ++n2;
        }
        XTextEditorViewer.cleanEnumValues();
        XTextEditorViewer.addEnumValues((String[])((String[])this.systemModel.getEnumValuesFromAttributes(component).toArray((Object[])new String[0])));
    }

    private void cleanEditorView() {
        this.constraintNameLabel.setText("no Constraint selected");
        this.xTextEditorViewer.cleanEditor();
    }

    private Composite createGUI(Composite parent, IWorkbenchPage page) {
        GridData gd;
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(4, false));
        composite.setBackgroundMode(2);
        composite.setBackground(Display.getCurrent().getSystemColor(1));
        Object layoutData = parent.getLayoutData();
        if (layoutData != null && layoutData instanceof GridData) {
            gd = (GridData)layoutData;
            gd.grabExcessVerticalSpace = true;
            gd.verticalAlignment = 4;
        }
        gd = new GridData(4, 4, true, false);
        gd.horizontalSpan = 3;
        this.constraintNameLabel = new Text(composite, 0);
        this.constraintNameLabel.setText("no Constraint selected");
        this.constraintNameLabel.setEditable(false);
        this.constraintNameLabel.setLayoutData((Object)gd);
        gd = new GridData(4, 4, false, false);
        Label constraintLabel = new Label(composite, 0);
        constraintLabel.setText("Selected Constraint");
        constraintLabel.setLayoutData((Object)gd);
        constraintLabel.setBackground(Display.getCurrent().getSystemColor(1));
        return composite;
    }
}

