/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.tools.adapter.ui;

import eu.fbk.tools.adapter.ui.Activator;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Writer;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleFactory;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;

public class ToolConsoleFactory
implements IConsoleFactory {
    public static final String LOGGER_NAME = "eu.fbk.tools";
    public static final String TOOL_CONSOLE_NAME = "FBK Tools";

    public synchronized void openConsole() {
        MessageConsole console = new MessageConsole(TOOL_CONSOLE_NAME, Activator.getImageDescriptor("icons/tool_logo.png"));
        ConsolePlugin.getDefault().getConsoleManager().addConsoles(new IConsole[]{console});
        MessageConsoleStream stream = console.newMessageStream();
        PrintStream myS = new PrintStream((OutputStream)stream);
        System.setOut(myS);
        System.setErr(myS);
        ConsoleAppender appender = new ConsoleAppender();
        appender.setName("ToolConsoleAppender");
        appender.setLayout((Layout)new PatternLayout("[%-5p] %d [%t] %c [%L]- %m%n"));
        appender.setWriter((Writer)new PrintWriter((OutputStream)stream));
        Logger.getLogger((String)LOGGER_NAME).addAppender((Appender)appender);
        appender.activateOptions();
        console.activate();
        console.clearConsole();
    }

    public synchronized void showConsole() {
        Boolean showConsole = Activator.getDefault().getPreferenceStore().getBoolean("debug.showConsole");
        if (showConsole == null || !showConsole.booleanValue()) {
            return;
        }
        MessageConsole console = this.findOcraConsole();
        if (console != null) {
            console.clearConsole();
            return;
        }
        this.openConsole();
    }

    public synchronized void closeConsole() {
        MessageConsole console = this.findOcraConsole();
        if (console != null) {
            ConsolePlugin.getDefault().getConsoleManager().removeConsoles(new IConsole[]{console});
            console.destroy();
        }
    }

    private MessageConsole findOcraConsole() {
        IConsole[] consoles = ConsolePlugin.getDefault().getConsoleManager().getConsoles();
        if (consoles == null || consoles.length == 0) {
            return null;
        }
        IConsole[] iConsoleArray = consoles;
        int n = consoles.length;
        int n2 = 0;
        while (n2 < n) {
            IConsole console = iConsoleArray[n2];
            if (console.getName().equals(TOOL_CONSOLE_NAME)) {
                return (MessageConsole)console;
            }
            ++n2;
        }
        return null;
    }
}

