/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.tools.adapter.ui.commands.contract;

import eu.fbk.tools.adapter.FileUtils;
import eu.fbk.tools.adapter.ToolFunction;
import eu.fbk.tools.adapter.ocra.CheckContractRefinement;
import eu.fbk.tools.adapter.ocra.OcraFunction;
import eu.fbk.tools.adapter.ui.commands.contract.AbstractCheckContractCommand;
import eu.fbk.tools.adapter.ui.dialog.contract.ContractRefinementParametersDialog;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckContractRefinementCommand
extends AbstractCheckContractCommand {
    private static final Logger logger = LoggerFactory.getLogger(CheckContractRefinementCommand.class);
    private CheckContractRefinement function;
    private Boolean wholeArchitecture;

    public CheckContractRefinementCommand() {
        super("Check Contract Refinement");
    }

    @Override
    protected boolean initialize() {
        this.function = new CheckContractRefinement();
        return super.initialize();
    }

    @Override
    protected ToolFunction getFunction() {
        return this.function;
    }

    @Override
    protected boolean preprocessEvent(ExecutionEvent event) {
        if (!super.preprocessEvent(event)) {
            return false;
        }
        this.function.setContractModel(FileUtils.stringToURI((String)this.contractFileName));
        this.function.setTimeModel(this.timeModel);
        this.function.setContractName(event.getParameter("contract_name"));
        this.wholeArchitecture = Boolean.valueOf(event.getParameter("whole_architecture"));
        this.function.setWholeArchitecture(this.wholeArchitecture);
        this.function.setDisableAsyncConstraints(this.disableAsyncConstraints);
        if (this.function.getContractName() != null) {
            logger.debug("Set contract name to " + this.function.getContractName());
        }
        logger.debug("Consider the whole architecture: " + this.function.getWholeArchitecture());
        String algorithmType = event.getParameter("algorithm_type");
        if (!StringUtils.isBlank((CharSequence)algorithmType)) {
            try {
                this.function.setAlgorithmType(OcraFunction.AlgorithmType.valueOf((String)algorithmType));
            }
            catch (Exception exception) {
                this.displayError(this.getCommandDescription(), "Invalid algorithm type parameter value, can't execute the command.");
                logger.error("Invalid algorithm type parameter value: " + algorithmType);
                return false;
            }
        }
        if (this.function.getAlgorithmType() != null) {
            logger.debug("Set algorithm type to " + this.function.getAlgorithmType().name());
        }
        if (this.isDevelopmentModeEnabled()) {
            Display display = PlatformUI.getWorkbench().getDisplay();
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    ContractRefinementParametersDialog dialog = new ContractRefinementParametersDialog(CheckContractRefinementCommand.this.activeShell, CheckContractRefinementCommand.this.function, CheckContractRefinementCommand.this.asyncExecution, CheckContractRefinementCommand.this.wholeArchitecture, CheckContractRefinementCommand.this.disableAsyncConstraints);
                    dialog.open();
                    if (dialog.goAhead()) {
                        CheckContractRefinementCommand.this.asyncExecution = dialog.getAsyncExecution();
                        CheckContractRefinementCommand.this.function.setWholeArchitecture(dialog.getWholeArchitecture());
                        CheckContractRefinementCommand.this.function.setDisableAsyncConstraints(dialog.getDisableAsyncConstraints());
                    }
                }
            };
            display.syncExec(runnable);
        }
        return true;
    }
}

