/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.tools.adapter.ui.commands.contract;

import eu.fbk.tools.adapter.FileUtils;
import eu.fbk.tools.adapter.ToolFunction;
import eu.fbk.tools.adapter.ocra.GenerateMiterArchitecture;
import eu.fbk.tools.adapter.ui.commands.contract.AbstractCheckContractCommand;
import eu.fbk.tools.adapter.ui.dialog.contract.GenerateMiterArchitectureParametersDialog;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenerateMiterCommand
extends AbstractCheckContractCommand {
    private static final Logger logger = LoggerFactory.getLogger(GenerateMiterCommand.class);
    public static final String ID_PARAMETER_MAP_FILE = "map_file";
    public static final String ID_PARAMETER_MODEL = "model_type";
    public static final String ID_PARAMETER_RESULT_OSS_MITER_FILE = "result_miter_oss_file";
    public static final String ID_PARAMETER_RESULT_MAP_MITER_FILE = "result_miter_map_file";
    public static final String ID_PARAMETER_RESULT_FAULT_XML_FILE = "result_fault_xml_file";
    public static final String ID_PARAMETER_RESULT_VAR_LIST_FILE = "result_var_list_file";
    private GenerateMiterArchitecture function;

    public GenerateMiterCommand() {
        super("Generate Miter");
    }

    @Override
    protected boolean initialize() {
        this.function = new GenerateMiterArchitecture();
        return super.initialize();
    }

    @Override
    protected ToolFunction getFunction() {
        return this.function;
    }

    @Override
    protected boolean preprocessEvent(ExecutionEvent event) {
        String varListFile;
        String faultXmlFile;
        String miterMappingFile;
        String miterArchitectureFile;
        if (!super.preprocessEvent(event)) {
            return false;
        }
        this.function.setContractModel(FileUtils.stringToURI((String)this.contractFileName));
        this.function.setDisableAsyncConstraints(this.disableAsyncConstraints);
        String mappingFileName = this.getFileNameParameter(event, ID_PARAMETER_MAP_FILE, "txt", "Choose the map file");
        this.function.setComponentsMapping(FileUtils.stringToURI((String)mappingFileName));
        String model_type = event.getParameter(ID_PARAMETER_MODEL);
        if (!StringUtils.isBlank((CharSequence)model_type)) {
            GenerateMiterArchitecture.ModelType modelType = GenerateMiterArchitecture.ModelType.valueOf((String)model_type);
            this.function.setModelType(modelType);
            logger.debug("Set model type to " + model_type);
        }
        if (!StringUtils.isBlank((CharSequence)(miterArchitectureFile = event.getParameter(ID_PARAMETER_RESULT_OSS_MITER_FILE)))) {
            this.function.setMiterArchitecture(FileUtils.stringToURI((String)miterArchitectureFile));
        }
        if (!StringUtils.isBlank((CharSequence)(miterMappingFile = event.getParameter(ID_PARAMETER_RESULT_MAP_MITER_FILE)))) {
            this.function.setMiterMapping(FileUtils.stringToURI((String)miterMappingFile));
        }
        if (!StringUtils.isBlank((CharSequence)(faultXmlFile = event.getParameter(ID_PARAMETER_RESULT_FAULT_XML_FILE)))) {
            this.function.setFaultsDef(FileUtils.stringToURI((String)faultXmlFile));
        }
        if (!StringUtils.isBlank((CharSequence)(varListFile = event.getParameter(ID_PARAMETER_RESULT_VAR_LIST_FILE)))) {
            this.function.setVarList(FileUtils.stringToURI((String)varListFile));
        }
        if (this.isDevelopmentModeEnabled()) {
            Display display = PlatformUI.getWorkbench().getDisplay();
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    GenerateMiterArchitectureParametersDialog dialog = new GenerateMiterArchitectureParametersDialog(GenerateMiterCommand.this.activeShell, GenerateMiterCommand.this.function, GenerateMiterCommand.this.asyncExecution, GenerateMiterCommand.this.disableAsyncConstraints);
                    dialog.open();
                    if (dialog.goAhead()) {
                        GenerateMiterCommand.this.asyncExecution = dialog.getAsyncExecution();
                        GenerateMiterCommand.this.function.setDisableAsyncConstraints(dialog.getDisableAsyncConstraints());
                    }
                }
            };
            display.syncExec(runnable);
        }
        if (this.function.getContractModel() == null) {
            this.displayError(this.getCommandDescription(), "Missing value of architecture oss file parameter, can't execute the command.");
            return false;
        }
        if (this.function.getComponentsMapping() == null) {
            this.displayError(this.getCommandDescription(), "Missing value of map file parameter, can't execute the command.");
            return false;
        }
        return true;
    }
}

