/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.tools.adapter.ui.commands.contract;

import eu.fbk.tools.adapter.FileUtils;
import eu.fbk.tools.adapter.ToolFunction;
import eu.fbk.tools.adapter.ocra.PrintSystemImplementation;
import eu.fbk.tools.adapter.ui.commands.contract.AbstractCheckContractCommand;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.commands.ExecutionEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrintSystemImplementationCommand
extends AbstractCheckContractCommand {
    private static final Logger logger = LoggerFactory.getLogger(PrintSystemImplementationCommand.class);
    private PrintSystemImplementation function;
    private String mapFileName;

    public PrintSystemImplementationCommand() {
        super("Generate system implementation");
    }

    @Override
    protected boolean initialize() {
        this.function = new PrintSystemImplementation();
        this.mapFileName = null;
        return super.initialize();
    }

    @Override
    protected ToolFunction getFunction() {
        return this.function;
    }

    @Override
    protected boolean preprocessEvent(ExecutionEvent event) {
        if (!super.preprocessEvent(event)) {
            return false;
        }
        this.function.setContractModel(FileUtils.stringToURI((String)this.contractFileName));
        this.mapFileName = this.getFileNameParameter(event, "map_file", "txt", "Choose the map file");
        if (StringUtils.isBlank((CharSequence)this.mapFileName)) {
            this.displayError(this.getCommandDescription(), "Map file has not been specified, can't execute the command.");
            logger.error("Map file has not been specified, can't execute the command.");
            return false;
        }
        logger.debug("Set map file name to " + this.mapFileName);
        this.function.setComponentsMapping(FileUtils.stringToURI((String)this.mapFileName));
        this.function.setTimeModel(this.timeModel);
        this.function.setDisableAsyncConstraints(this.disableAsyncConstraints);
        String oldModelFormat = event.getParameter("old_model_format");
        if (!StringUtils.isBlank((CharSequence)oldModelFormat)) {
            try {
                this.function.setOldSmvFormat(Boolean.valueOf(oldModelFormat));
            }
            catch (Exception exception) {
                logger.error("Invalid old model parameter value: " + oldModelFormat);
            }
        }
        return true;
    }
}

