/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.tools.adapter.ui.commands.safety;

import eu.fbk.tools.adapter.FileUtils;
import eu.fbk.tools.adapter.ToolFunction;
import eu.fbk.tools.adapter.ui.commands.safety.AbstractSafetyAnalysisCommand;
import eu.fbk.tools.adapter.ui.dialog.safety.ComputeFaultTreeParametersDialog;
import eu.fbk.tools.adapter.xsap.ComputeFaultTree;
import eu.fbk.tools.adapter.xsap.XsapFunction;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ComputeFaultTreeCommand
extends AbstractSafetyAnalysisCommand {
    private static final Logger logger = LoggerFactory.getLogger(ComputeFaultTreeCommand.class);
    public static final String ID_PARAMETER_RESULT_FT_FILE = "result_ft_file";
    public static final String ID_PARAMETER_RESULT_GATES_FILE = "result_gates_file";
    public static final String ID_PARAMETER_RESULT_EVENTS_FILE = "result_events_file";
    private ComputeFaultTree function;

    public ComputeFaultTreeCommand() {
        this("Compute Fault Tree");
    }

    protected ComputeFaultTreeCommand(String commandDescription) {
        super(commandDescription);
    }

    @Override
    protected boolean initialize() {
        super.initialize();
        this.function = new ComputeFaultTree();
        return true;
    }

    @Override
    protected ToolFunction getFunction() {
        return this.function;
    }

    @Override
    protected boolean preprocessEvent(ExecutionEvent event) {
        String gatesFileName;
        String eventsFileName;
        String boundLength;
        if (!super.preprocessEvent(event)) {
            return false;
        }
        this.function.setBehaviourModel(FileUtils.stringToURI((String)this.behaviourFileName));
        String faultModesFileName = this.getFileNameParameter(event, "fault_modes", "xml", "Choose the fault modes file");
        if (StringUtils.isBlank((CharSequence)faultModesFileName)) {
            this.displayError(this.getCommandDescription(), "Fault modes file has not been specified, can't execute the command.");
            logger.error("Fault modes file has not been specified, can't execute the command.");
            return false;
        }
        this.function.setFaultModes(FileUtils.stringToURI((String)faultModesFileName));
        logger.debug("Set fault modes file to " + faultModesFileName);
        this.function.setProperties(event.getParameter("properties"));
        this.function.setPropertyName(event.getParameter("propertyName"));
        String algorithmType = event.getParameter("algorithm_type");
        if (algorithmType != null) {
            try {
                this.function.setAlgorithmType(XsapFunction.AlgorithmType.valueOf((String)algorithmType));
            }
            catch (Exception exception) {
                this.displayError(this.getCommandDescription(), "Invalid algorithm type parameter value, can't execute the command.");
                logger.error("Invalid algorithm type parameter value: " + algorithmType);
                return false;
            }
        }
        if (!StringUtils.isBlank((CharSequence)(boundLength = event.getParameter("bound_length")))) {
            try {
                this.function.setBoundLength(Integer.decode(boundLength));
            }
            catch (NumberFormatException numberFormatException) {
                String errMsg = "Invalid bound_length parameter value: " + boundLength + " , can't execute the command.";
                this.displayError(this.getCommandDescription(), errMsg);
                logger.error(errMsg);
                return false;
            }
        }
        Boolean computeProbability = false;
        String computeProbabilityParameter = event.getParameter("compute_probability");
        if (!StringUtils.isBlank((CharSequence)computeProbabilityParameter)) {
            try {
                computeProbability = Boolean.valueOf(computeProbabilityParameter);
                logger.debug("Set compute probability to: " + computeProbabilityParameter);
            }
            catch (Exception e) {
                String msg = "Internal error: unexpected value of compute_probability parameter: " + computeProbabilityParameter + ". Allowed values are: true, false.";
                this.displayError(this.getCommandDescription(), String.valueOf(msg) + "\nCan't execute the command.");
                logger.error(msg, (Throwable)e);
                return false;
            }
        }
        this.function.setComputeProbability(computeProbability);
        String faultTreeFileName = event.getParameter(ID_PARAMETER_RESULT_FT_FILE);
        if (!StringUtils.isBlank((CharSequence)faultTreeFileName)) {
            this.function.setFaultTree(FileUtils.stringToURI((String)faultTreeFileName));
        }
        if (!StringUtils.isBlank((CharSequence)(eventsFileName = event.getParameter(ID_PARAMETER_RESULT_EVENTS_FILE)))) {
            this.function.setEvents(FileUtils.stringToURI((String)eventsFileName));
        }
        if (!StringUtils.isBlank((CharSequence)(gatesFileName = event.getParameter(ID_PARAMETER_RESULT_GATES_FILE)))) {
            this.function.setGates(FileUtils.stringToURI((String)gatesFileName));
        }
        if (this.isDevelopmentModeEnabled()) {
            Display display = PlatformUI.getWorkbench().getDisplay();
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    ComputeFaultTreeParametersDialog dialog = new ComputeFaultTreeParametersDialog(ComputeFaultTreeCommand.this.activeShell, ComputeFaultTreeCommand.this.function, ComputeFaultTreeCommand.this.asyncExecution);
                    dialog.open();
                    if (dialog.goAhead()) {
                        ComputeFaultTreeCommand.this.asyncExecution = dialog.getAsyncExecution();
                    }
                }
            };
            display.syncExec(runnable);
        }
        if (StringUtils.isBlank((CharSequence)this.function.getProperties()) && StringUtils.isBlank((CharSequence)this.function.getPropertyName())) {
            this.displayError(this.getCommandDescription(), "Properties is missing, can't execute the command.");
            logger.error("Properties is missing");
            return false;
        }
        return true;
    }
}

