/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.tools.adapter.ui.commands.safety;

import eu.fbk.tools.adapter.FileUtils;
import eu.fbk.tools.adapter.ToolFunction;
import eu.fbk.tools.adapter.ui.commands.safety.AbstractSafetyAnalysisCommand;
import eu.fbk.tools.adapter.xsap.OptimizeObservables;
import eu.fbk.tools.adapter.xsap.XsapFunction;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.commands.ExecutionEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OptimizeObservablesCommand
extends AbstractSafetyAnalysisCommand {
    private static final Logger logger = LoggerFactory.getLogger(OptimizeObservablesCommand.class);
    private OptimizeObservables function;
    public static final String ID_PARAMETER_ALARM_PATTERN = "alarm_pattern";
    public static final String ID_PARAMETER_ALARM_PATH = "alarm_path";
    public static final String ID_PARAMETER_OBSERVABLES = "observables";
    public static final String ID_PARAMETER_DELAY_BOUND = "delay_bound";
    public static final String ID_PARAMETER_CONDITION = "conditions";
    public static final String ID_PARAMETER_CONTEXT = "context";
    public static final String ID_PARAMETER_NEED_MSAT = "need_msat";
    public static final String ID_PARAMETER_BMC_LENGTH = "bmc_length";

    public OptimizeObservablesCommand() {
        this("Optimize Observables");
    }

    protected OptimizeObservablesCommand(String commandDescription) {
        super(commandDescription);
    }

    @Override
    protected boolean initialize() {
        super.initialize();
        this.function = new OptimizeObservables();
        return true;
    }

    @Override
    protected ToolFunction getFunction() {
        return this.function;
    }

    @Override
    protected boolean preprocessEvent(ExecutionEvent event) {
        String bmcLength;
        String needMsat;
        String delayBound;
        String context;
        String condition;
        String observables;
        String alarmPath;
        String alarmPattern;
        if (!super.preprocessEvent(event)) {
            return false;
        }
        this.function.setBehaviourModel(FileUtils.stringToURI((String)this.behaviourFileName));
        String algorithmType = event.getParameter("algorithm_type");
        if (algorithmType != null) {
            try {
                this.function.setAlgorithmType(XsapFunction.AlgorithmType.valueOf((String)algorithmType));
            }
            catch (Exception exception) {
                this.displayError(this.getCommandDescription(), "Invalid algorithm type parameter value, can't execute the command.");
                logger.error("Invalid algorithm type parameter value: " + algorithmType);
                return false;
            }
        }
        if (!StringUtils.isBlank((CharSequence)(alarmPattern = event.getParameter(ID_PARAMETER_ALARM_PATTERN)))) {
            this.function.setAlarmPattern(alarmPattern);
        }
        if (!StringUtils.isBlank((CharSequence)(alarmPath = event.getParameter(ID_PARAMETER_ALARM_PATH)))) {
            this.function.setAlarmPath(FileUtils.stringToURI((String)alarmPath));
        }
        if (!StringUtils.isBlank((CharSequence)(observables = event.getParameter(ID_PARAMETER_OBSERVABLES)))) {
            this.function.setObservables(FileUtils.stringToURI((String)observables));
        }
        if (!StringUtils.isBlank((CharSequence)(condition = event.getParameter(ID_PARAMETER_CONDITION)))) {
            this.function.setCondition(condition);
        }
        if (!StringUtils.isBlank((CharSequence)(context = event.getParameter(ID_PARAMETER_CONTEXT)))) {
            this.function.setContext(context);
        }
        if (!StringUtils.isBlank((CharSequence)(delayBound = event.getParameter(ID_PARAMETER_DELAY_BOUND)))) {
            try {
                this.function.setDelayBound(Integer.decode(delayBound).intValue());
            }
            catch (NumberFormatException numberFormatException) {
                String errMsg = "Invalid delay bound parameter value: " + delayBound + " , can't execute the command.";
                this.displayError(this.getCommandDescription(), errMsg);
                logger.error(errMsg);
                return false;
            }
        }
        if (!StringUtils.isBlank((CharSequence)(needMsat = event.getParameter(ID_PARAMETER_NEED_MSAT)))) {
            this.function.setNeedMsat(Boolean.valueOf(needMsat));
        }
        if (!StringUtils.isBlank((CharSequence)(bmcLength = event.getParameter(ID_PARAMETER_BMC_LENGTH)))) {
            try {
                this.function.setBmcLength(Integer.decode(bmcLength));
            }
            catch (NumberFormatException numberFormatException) {
                String errMsg = "Invalid BMC length parameter value: " + bmcLength + " , can't execute the command.";
                this.displayError(this.getCommandDescription(), errMsg);
                logger.error(errMsg);
                return false;
            }
        }
        return true;
    }
}

