/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.tools.adapter.ui.commands.safety;

import eu.fbk.tools.adapter.FileUtils;
import eu.fbk.tools.adapter.ToolFunction;
import eu.fbk.tools.adapter.ui.commands.safety.AbstractSafetyAnalysisCommand;
import eu.fbk.tools.adapter.ui.dialog.safety.RedundancyAnalysisComputeFaultTreeParametersDialog;
import eu.fbk.tools.adapter.xsap.RedundancyAnalysisComputeFaultTree;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedundancyAnalysisComputeFaultTreeCommand
extends AbstractSafetyAnalysisCommand {
    private static final Logger logger = LoggerFactory.getLogger(RedundancyAnalysisComputeFaultTreeCommand.class);
    public static final String ID_PARAMETER_KIND = "kind";
    public static final String ID_PARAMETER_MODEL = "model_type";
    public static final String ID_PARAMETER_VAR_ORDER_LIST_FILE = "var_order_list_file";
    public static final String ID_PARAMETER_RESULT_FT_FILE = "result_ft_file";
    public static final String ID_PARAMETER_RESULT_GATES_FILE = "result_gates_file";
    public static final String ID_PARAMETER_RESULT_EVENTS_FILE = "result_events_file";
    public static final String ID_PARAMETER_RESULT_SYMBOLIC_FORMULA_PYTHON_FILE = "result_simbolic_formula_python_file";
    public static final String ID_PARAMETER_RESULT_SYMBOLIC_FORMULA_MATLAB_FILE = "result_simbolic_formula_matlab_file";
    private RedundancyAnalysisComputeFaultTree function;

    public RedundancyAnalysisComputeFaultTreeCommand() {
        super("Compute Fault Tree for Redundancy Analysis");
    }

    @Override
    protected boolean initialize() {
        super.initialize();
        this.function = new RedundancyAnalysisComputeFaultTree();
        return true;
    }

    @Override
    protected ToolFunction getFunction() {
        return this.function;
    }

    @Override
    protected boolean preprocessEvent(ExecutionEvent event) {
        String symbolicFormulaMatlabFileName;
        String symbolicFormulaPythonFileName;
        String gatesFileName;
        String eventsFileName;
        String faultTreeFileName;
        String model_type;
        String architectureType;
        if (!super.preprocessEvent(event)) {
            return false;
        }
        this.function.setBehaviourModel(FileUtils.stringToURI((String)this.behaviourFileName));
        String faultModesFileName = this.getFileNameParameter(event, "fault_modes", "xml", "Choose the fault modes file");
        if (StringUtils.isBlank((CharSequence)faultModesFileName)) {
            this.displayError(this.getCommandDescription(), "Fault modes file has not been specified, can't execute the command.");
            logger.error("Fault modes file has not been specified, can't execute the command.");
            return false;
        }
        this.function.setFaultModes(FileUtils.stringToURI((String)faultModesFileName));
        String varOrderListName = this.getFileNameParameter(event, ID_PARAMETER_VAR_ORDER_LIST_FILE, "ord", "Choose the var list file");
        if (!StringUtils.isBlank((CharSequence)varOrderListName)) {
            this.function.setVarOrderList(FileUtils.stringToURI((String)varOrderListName));
        }
        if (!StringUtils.isBlank((CharSequence)(architectureType = event.getParameter(ID_PARAMETER_KIND)))) {
            try {
                this.function.setArchitectureType(RedundancyAnalysisComputeFaultTree.RedundantArchitectureType.valueOf((String)architectureType));
            }
            catch (Exception exception) {
                this.displayError(this.getCommandDescription(), "Invalid value of architecture kind parameter, can't execute the command.");
                logger.error("Invalid architecture type parameter value: " + architectureType);
                return false;
            }
            logger.debug("Set architecture type to " + this.function.getArchitectureType().name());
        }
        if (!StringUtils.isBlank((CharSequence)(model_type = event.getParameter(ID_PARAMETER_MODEL)))) {
            this.function.setModelType(RedundancyAnalysisComputeFaultTree.ModelType.valueOf((String)model_type));
            logger.debug("Set model type to " + model_type);
        }
        if (!StringUtils.isBlank((CharSequence)(faultTreeFileName = event.getParameter(ID_PARAMETER_RESULT_FT_FILE)))) {
            this.function.setFaultTree(FileUtils.stringToURI((String)faultTreeFileName));
        }
        if (!StringUtils.isBlank((CharSequence)(eventsFileName = event.getParameter(ID_PARAMETER_RESULT_EVENTS_FILE)))) {
            this.function.setEvents(FileUtils.stringToURI((String)eventsFileName));
        }
        if (!StringUtils.isBlank((CharSequence)(gatesFileName = event.getParameter(ID_PARAMETER_RESULT_GATES_FILE)))) {
            this.function.setGates(FileUtils.stringToURI((String)gatesFileName));
        }
        if (!StringUtils.isBlank((CharSequence)(symbolicFormulaPythonFileName = event.getParameter(ID_PARAMETER_RESULT_SYMBOLIC_FORMULA_PYTHON_FILE)))) {
            this.function.setPythonSymbolicFormula(FileUtils.stringToURI((String)symbolicFormulaPythonFileName));
        }
        if (!StringUtils.isBlank((CharSequence)(symbolicFormulaMatlabFileName = event.getParameter(ID_PARAMETER_RESULT_SYMBOLIC_FORMULA_MATLAB_FILE)))) {
            this.function.setMatlabSymbolicFormula(FileUtils.stringToURI((String)symbolicFormulaMatlabFileName));
        }
        if (this.isDevelopmentModeEnabled()) {
            Display display = PlatformUI.getWorkbench().getDisplay();
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    RedundancyAnalysisComputeFaultTreeParametersDialog dialog = new RedundancyAnalysisComputeFaultTreeParametersDialog(RedundancyAnalysisComputeFaultTreeCommand.this.activeShell, RedundancyAnalysisComputeFaultTreeCommand.this.function, RedundancyAnalysisComputeFaultTreeCommand.this.asyncExecution);
                    dialog.open();
                    if (dialog.goAhead()) {
                        RedundancyAnalysisComputeFaultTreeCommand.this.asyncExecution = dialog.getAsyncExecution();
                    }
                }
            };
            display.syncExec(runnable);
        }
        return true;
    }
}

