/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.tools.adapter.ui.commands.satisfiability;

import eu.fbk.tools.adapter.FileUtils;
import eu.fbk.tools.adapter.ToolFunction;
import eu.fbk.tools.adapter.mathsat.CheckSatisfiability;
import eu.fbk.tools.adapter.ui.commands.AbstractToolCommand;
import org.eclipse.core.commands.ExecutionEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckSatisfiabilityCommand
extends AbstractToolCommand {
    private static final Logger logger = LoggerFactory.getLogger(CheckSatisfiabilityCommand.class);
    public static String ID_PARAMETER_SMT_QUERY = "smt_query";
    private CheckSatisfiability function;

    public CheckSatisfiabilityCommand() {
        super("CheckSatisfiability", "Check Satisfiability", "tools.mathsat.executable", "tools.mathsat.timeout");
    }

    @Override
    protected ToolFunction getFunction() {
        return this.function;
    }

    @Override
    protected boolean initialize() {
        this.function = new CheckSatisfiability();
        return super.initialize();
    }

    @Override
    protected boolean preprocessEvent(ExecutionEvent event) {
        if (!super.preprocessEvent(event)) {
            return false;
        }
        String smtQueryFileName = this.getFileNameParameter(event, ID_PARAMETER_SMT_QUERY, "smt2", "Choose the smt file");
        logger.debug("SMT Query file name " + smtQueryFileName);
        this.function.setSmtQuery(FileUtils.stringToURI((String)smtQueryFileName));
        this.isDevelopmentModeEnabled();
        return true;
    }
}

