/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.tools.adapter.ui.dialog.safety;

import eu.fbk.tools.adapter.xsap.ComputeFaultTree;
import eu.fbk.tools.adapter.xsap.XsapFunction;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;

public class ComputeFaultTreeParametersDialog
extends Dialog {
    private ComputeFaultTree function;
    private Combo algorithmTypeCombo;
    private Text propertyNameText;
    private Text propertiesText;
    private Spinner boundLengthSpinner;
    private Button computeProbabilityCheckBox;
    private Button asyncCheckBox;
    private Boolean asyncExecution = false;
    private String[] algorithmTypes = new String[]{"", "bdd", "bmc", "ic3", "msat"};
    private boolean goAhead = false;

    public ComputeFaultTreeParametersDialog(Shell parentShell) {
        super(parentShell);
        this.setShellStyle(32);
    }

    public ComputeFaultTreeParametersDialog(Shell parentShell, ComputeFaultTree function, Boolean asyncExecution) {
        this(parentShell);
        this.function = function;
        this.asyncExecution = asyncExecution == null ? false : asyncExecution;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Compute Fault Tree Parameters");
    }

    protected void okPressed() {
        try {
            this.function.setAlgorithmType(XsapFunction.AlgorithmType.valueOf((String)this.algorithmTypeCombo.getItems()[this.algorithmTypeCombo.getSelectionIndex()]));
        }
        catch (Exception exception) {}
        this.function.setProperties(this.propertiesText.getText());
        this.function.setPropertyName(this.propertyNameText.getText());
        this.function.setBoundLength(Integer.valueOf(this.boundLengthSpinner.getSelection()));
        this.function.setComputeProbability(Boolean.valueOf(this.computeProbabilityCheckBox.getSelection()));
        this.asyncExecution = this.asyncCheckBox.getSelection();
        this.goAhead = true;
        super.okPressed();
    }

    protected void cancelPressed() {
        this.goAhead = false;
        super.cancelPressed();
    }

    protected Control createDialogArea(Composite parent) {
        parent.setToolTipText("");
        Composite container = (Composite)super.createDialogArea(parent);
        Composite container2 = new Composite(container, 0);
        container2.setLayout((Layout)new GridLayout(2, false));
        GridData gd_combo = new GridData(16384, 0x1000000, true, false, 1, 1);
        gd_combo.widthHint = 200;
        Label lblProperties = new Label(container2, 0);
        lblProperties.setText("Properties");
        this.propertiesText = new Text(container2, 2052);
        this.propertiesText.setLayoutData((Object)new GridData(768));
        if (!StringUtils.isBlank((CharSequence)this.function.getProperties())) {
            this.propertiesText.setText(this.function.getProperties());
        }
        Label lblPropertyName = new Label(container2, 0);
        lblPropertyName.setText("Property Name");
        this.propertyNameText = new Text(container2, 2052);
        this.propertyNameText.setLayoutData((Object)new GridData(768));
        if (!StringUtils.isBlank((CharSequence)this.function.getPropertyName())) {
            this.propertyNameText.setText(this.function.getPropertyName());
        }
        Label lblAlgorithm = new Label(container2, 0);
        lblAlgorithm.setText("Algorithm Type");
        this.algorithmTypeCombo = new Combo(container2, 8);
        this.algorithmTypeCombo.setLayoutData((Object)gd_combo);
        this.setComboValues(this.algorithmTypeCombo, this.algorithmTypes, this.function.getAlgorithmType() == null ? "" : this.function.getAlgorithmType().name());
        Label lblBoundLength = new Label(container2, 0);
        lblBoundLength.setText("Bound Length");
        this.boundLengthSpinner = new Spinner(container2, 2048);
        this.boundLengthSpinner.setMinimum(0);
        this.boundLengthSpinner.setMaximum(50);
        this.boundLengthSpinner.setSelection(0);
        this.boundLengthSpinner.setIncrement(1);
        this.boundLengthSpinner.setPageIncrement(5);
        if (this.function.getBoundLength() != null) {
            this.boundLengthSpinner.setSelection(this.function.getBoundLength().intValue());
        }
        this.computeProbabilityCheckBox = new Button(container, 32);
        this.computeProbabilityCheckBox.setText("Compute Probability");
        this.computeProbabilityCheckBox.setSelection(BooleanUtils.isTrue((Boolean)this.function.getComputeProbability()));
        this.asyncCheckBox = new Button(container, 32);
        this.asyncCheckBox.setText("OSLC Asynchronous Execution");
        this.asyncCheckBox.setSelection(this.asyncExecution.booleanValue());
        return container;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Point getInitialSize() {
        return new Point(400, 350);
    }

    public boolean goAhead() {
        return this.goAhead;
    }

    public Boolean getAsyncExecution() {
        return this.asyncExecution;
    }

    private void setComboValues(Combo combo, String[] admittedValues, String currentValue) {
        combo.setItems(admittedValues);
        combo.select(0);
        if (currentValue != null) {
            int i = 0;
            while (i < admittedValues.length) {
                if (admittedValues[i].equals(currentValue)) {
                    combo.select(i);
                    break;
                }
                ++i;
            }
        }
    }
}

