/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.tools.adapter.ui.preferences.tools;

import eu.fbk.tools.adapter.ToolRunner;
import eu.fbk.tools.adapter.ToolRunnerFactory;
import eu.fbk.tools.adapter.ui.Activator;
import java.io.File;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.SystemUtils;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.DirectoryFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FileFieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalToolPreferences {
    private static final Logger logger = LoggerFactory.getLogger(LocalToolPreferences.class);
    private final Map<String, ToolInfo> toolInfos = new Hashtable<String, ToolInfo>();
    private final List<FieldEditor> fieldEditors = new ArrayList<FieldEditor>();
    private Composite parentComposite;
    private final IPreferenceStore preferenceStore = Activator.getDefault().getPreferenceStore();
    private Group toolInfoGroup;
    private Composite executableAndScriptParent;
    private FileFieldEditor executableFieldEditor;
    private Button testToolButton;
    private Label isToolValidLabel;
    private IntegerFieldEditor executionTimeoutFieldEditor;
    private TestToolButtonSelectionListener testToolButtonSelectionListener;
    private ExecutableEditorPropertyChangeListener executableEditorPropertyChangeListener;

    public Composite create(Composite parent) {
        this.parentComposite = parent;
        Composite composite1 = new Composite(this.parentComposite, 2048);
        composite1.setLayout((Layout)new GridLayout(1, true));
        composite1.setLayoutData((Object)new GridData(4, 0, true, false));
        Composite composite1_1 = new Composite(composite1, 0);
        composite1_1.setLayout((Layout)new GridLayout(1, true));
        composite1_1.setLayoutData((Object)new GridData(4, 0, true, false));
        this.fieldEditors.add((FieldEditor)new DirectoryFieldEditor("tools.workspace", "Workspace dir", composite1_1));
        Composite composite1_2 = new Composite(composite1, 0);
        composite1_2.setLayout((Layout)new GridLayout(1, true));
        composite1_2.setLayoutData((Object)new GridData(4, 0, true, false));
        this.fieldEditors.add((FieldEditor)new BooleanFieldEditor("tools.workspace.cleanup", "Cleanup workspace at next startup", composite1_2));
        Composite composite2 = new Composite(this.parentComposite, 2048);
        composite2.setLayout((Layout)new GridLayout(1, true));
        composite2.setLayoutData((Object)new GridData(4, 0, true, false));
        final Button localToolButton = new Button(composite2, 32);
        localToolButton.setText("Use local tools");
        localToolButton.setSelection(!this.preferenceStore.getBoolean("oslc.serviceprovider.enables"));
        localToolButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                LocalToolPreferences.this.preferenceStore.setValue("oslc.serviceprovider.enables", !localToolButton.getSelection());
            }
        });
        Label toolsLabel = new Label(composite2, 0);
        toolsLabel.setText("Available Tools");
        GridData toolsLabelGridData = new GridData();
        toolsLabelGridData.horizontalIndent = 8;
        toolsLabel.setLayoutData((Object)toolsLabelGridData);
        org.eclipse.swt.widgets.List toolList = new org.eclipse.swt.widgets.List(composite2, 2816);
        GridData listGridData = new GridData(768);
        toolList.setLayoutData((Object)listGridData);
        this.drawToolInfo(parent);
        this.addTool(toolList, "OCRA", "tools.ocra.executable", "tools.ocra.timeout", "tools.ocra.executable.isvalid");
        this.addTool(toolList, "nuXmv", "tools.nuxmv.executable", "tools.nuxmv.timeout", "tools.nuxmv.executable.isvalid");
        this.addTool(toolList, "xSAP", "tools.xsap.executable", "tools.xsap.timeout", "tools.xsap.executable.isvalid");
        this.addTool(toolList, "FaultExtensionExpander", "tools.fei_expander.executable", "tools.fei_expander.timeout", "tools.fei_expander.executable.isvalid");
        this.addTool(toolList, "ic3ia", "tools.ic3ia.executable", "tools.ic3ia.timeout", "tools.ic3ia.executable.isvalid");
        this.addTool(toolList, "mathsat", "tools.mathsat.executable", "tools.mathsat.timeout", "tools.mathsat.executable.isvalid");
        this.addTool(toolList, "kratos", "tools.kratos.executable", "tools.kratos.timeout", "tools.kratos.executable.isvalid");
        this.addTool(toolList, "kratos_property_injector", "tools.kratos_property_injector.executable", "tools.kratos_property_injector.timeout", "tools.kratos_property_injector.executable.isvalid");
        this.addTool(toolList, "python", "python.executable", "python.mathsat.timeout", "python.executable.isvalid");
        this.addScript(toolList, "RedundantArchitectureGenerator", "tools.redundant_architecture_generator.pyscript", "tools.redundant_architecture_generator.timeout", "tools.redundant_architecture_generator.isvalid");
        return parent;
    }

    public List<FieldEditor> getFieldEditors() {
        return this.fieldEditors;
    }

    private void addTool(org.eclipse.swt.widgets.List toolList, String toolName, String keyExecutable, String keyExecutionTimeout, String keyIsValid) {
        this.addToolOrScript(toolList, toolName, keyExecutable, keyExecutionTimeout, keyIsValid, false);
    }

    private void addScript(org.eclipse.swt.widgets.List toolList, String toolName, String keyExecutable, String keyExecutionTimeout, String keyIsValid) {
        this.addToolOrScript(toolList, toolName, keyExecutable, keyExecutionTimeout, keyIsValid, true);
    }

    private void addToolOrScript(org.eclipse.swt.widgets.List toolList, String toolName, String keyExecutable, String keyExecutionTimeout, String keyIsValid, boolean isScript) {
        ToolInfo toolInfo = new ToolInfo();
        toolInfo.name = toolName;
        toolInfo.executablePreferenceKey = keyExecutable;
        toolInfo.executionTimeoutPreferenceKey = keyExecutionTimeout;
        toolInfo.isValidPreferenceKey = keyIsValid;
        toolInfo.isScript = isScript;
        this.toolInfos.put(toolName, toolInfo);
        toolList.add(toolName);
        toolList.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                org.eclipse.swt.widgets.List toolList = (org.eclipse.swt.widgets.List)e.widget;
                String selection = toolList.getSelection()[0];
                if (selection != null) {
                    LocalToolPreferences.this.updateToolInfo(selection);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private void drawToolInfo(Composite parent) {
        this.toolInfoGroup = new Group(parent, 16);
        this.toolInfoGroup.setLayout((Layout)new GridLayout(1, true));
        this.toolInfoGroup.setLayoutData((Object)new GridData(768));
        this.toolInfoGroup.setText("");
        this.toolInfoGroup.setEnabled(false);
        Composite composite = new Composite((Composite)this.toolInfoGroup, 0);
        composite.setLayout((Layout)new GridLayout(1, true));
        composite.setLayoutData((Object)new GridData(768));
        this.executableAndScriptParent = new Composite(composite, 0);
        this.executableAndScriptParent.setLayout((Layout)new GridLayout(1, true));
        this.executableAndScriptParent.setLayoutData((Object)new GridData(768));
        this.executableFieldEditor = new FileFieldEditor("", "Executable/Script", true, 0, this.executableAndScriptParent);
        this.executableFieldEditor.setPreferenceStore(this.preferenceStore);
        this.executableEditorPropertyChangeListener = new ExecutableEditorPropertyChangeListener();
        this.executableFieldEditor.setPropertyChangeListener((IPropertyChangeListener)this.executableEditorPropertyChangeListener);
        this.testToolButton = new Button(this.executableAndScriptParent, 8);
        this.testToolButton.setAlignment(0x1000000);
        this.testToolButton.setText("Test");
        this.testToolButton.setToolTipText("Test if the executable is runnable and it is the right version");
        this.testToolButtonSelectionListener = new TestToolButtonSelectionListener();
        this.testToolButton.addSelectionListener((SelectionListener)this.testToolButtonSelectionListener);
        this.isToolValidLabel = new Label(this.executableAndScriptParent, 0);
        Composite composite2 = new Composite(composite, 0);
        this.executionTimeoutFieldEditor = new IntegerFieldEditor("", "Execution Timeout (seconds)", composite2, 4);
        this.executionTimeoutFieldEditor.setPreferenceStore(this.preferenceStore);
        this.executionTimeoutFieldEditor.setValidRange(1, 28800);
        this.executionTimeoutFieldEditor.setEmptyStringAllowed(false);
    }

    private void updateToolInfo(String name) {
        this.toolInfoGroup.setEnabled(true);
        this.toolInfoGroup.setText(name);
        ToolInfo toolInfo = this.toolInfos.get(name);
        toolInfo.isValid = this.preferenceStore.getBoolean(toolInfo.isValidPreferenceKey);
        this.updateIsValidLabel(toolInfo.isValid);
        this.testToolButtonSelectionListener.toolName = name;
        this.executionTimeoutFieldEditor.setPreferenceName(toolInfo.executionTimeoutPreferenceKey);
        this.executionTimeoutFieldEditor.load();
        this.executableEditorPropertyChangeListener.toolName = name;
        this.executableFieldEditor.setPreferenceName(toolInfo.executablePreferenceKey);
        this.executableFieldEditor.load();
        if (toolInfo.isScript) {
            this.executableFieldEditor.setLabelText("Script");
            this.executableFieldEditor.setFileExtensions(new String[]{"*.py", "*"});
        } else {
            String[] stringArray;
            this.executableFieldEditor.setLabelText("Executable");
            if (SystemUtils.IS_OS_WINDOWS) {
                String[] stringArray2 = new String[2];
                stringArray2[0] = "*.exe";
                stringArray = stringArray2;
                stringArray2[1] = "*";
            } else {
                String[] stringArray3 = new String[2];
                stringArray3[0] = "*";
                stringArray = stringArray3;
                stringArray3[1] = "*.sh";
            }
            this.executableFieldEditor.setFileExtensions(stringArray);
        }
        this.parentComposite.getShell().pack();
    }

    protected void performApply() {
        for (ToolInfo toolInfo : this.toolInfos.values()) {
            this.preferenceStore.setValue(toolInfo.isValidPreferenceKey, toolInfo.isValid);
        }
        this.executableFieldEditor.store();
        this.executionTimeoutFieldEditor.store();
    }

    protected void performDefaults() {
        for (ToolInfo toolInfo : this.toolInfos.values()) {
            this.preferenceStore.setValue(toolInfo.executablePreferenceKey, "");
            toolInfo.isValid = false;
            this.preferenceStore.setValue(toolInfo.isValidPreferenceKey, toolInfo.isValid);
        }
        this.executableFieldEditor.loadDefault();
        this.executionTimeoutFieldEditor.loadDefault();
        this.executionTimeoutFieldEditor.store();
        this.updateIsValidLabel(false);
    }

    private void setExecutableFieldEditorFilter(FileFieldEditor executableFileNameEditor) {
        String currentValue = executableFileNameEditor.getStringValue();
        if (!StringUtils.isBlank((String)currentValue)) {
            File currentFile = new File(currentValue);
            if (currentFile.exists() && currentFile.isDirectory()) {
                executableFileNameEditor.setFilterPath(currentFile);
            } else {
                String parentDir = currentFile.getParent();
                if (!StringUtils.isBlank((String)parentDir) && new File(parentDir).exists()) {
                    executableFileNameEditor.setFilterPath(new File(parentDir));
                }
            }
        }
    }

    private void updateIsValidLabel(boolean isValid) {
        if (isValid) {
            this.isToolValidLabel.setText("Tool executable was successfully tested");
            this.isToolValidLabel.setForeground(Display.getCurrent().getSystemColor(2));
        } else {
            this.isToolValidLabel.setText("Tool executable has to be tested");
            this.isToolValidLabel.setForeground(Display.getCurrent().getSystemColor(3));
        }
        this.isToolValidLabel.pack();
    }

    private class ExecutableEditorPropertyChangeListener
    implements IPropertyChangeListener {
        String toolName = null;

        private ExecutableEditorPropertyChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent event) {
            if (this.toolName == null) {
                return;
            }
            ToolInfo toolInfo = (ToolInfo)LocalToolPreferences.this.toolInfos.get(this.toolName);
            if (LocalToolPreferences.this.preferenceStore.getString(toolInfo.executablePreferenceKey).equals(event.getNewValue())) {
                return;
            }
            toolInfo.isValid = false;
            LocalToolPreferences.this.updateIsValidLabel(toolInfo.isValid);
        }
    }

    private class TestToolButtonSelectionListener
    implements SelectionListener {
        String toolName = null;

        private TestToolButtonSelectionListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            if (this.toolName == null) {
                logger.error("Tool Name is null");
                return;
            }
            ToolInfo toolInfo = (ToolInfo)LocalToolPreferences.this.toolInfos.get(this.toolName);
            if (toolInfo == null) {
                logger.error("Tool Info for " + this.toolName + " is null");
                return;
            }
            String toolExecutable = LocalToolPreferences.this.executableFieldEditor.getStringValue();
            if (StringUtils.isBlank((String)toolExecutable)) {
                MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)("Local Tool - Test of " + this.toolName), (String)(String.valueOf(this.toolName) + " executable/script is not set."));
                return;
            }
            ToolRunner runner = ToolRunnerFactory.getToolRunner((String)this.toolName, (File)new File(toolExecutable));
            if (runner == null) {
                logger.error("Can not find the ToolRunner for the tool " + this.toolName);
                return;
            }
            runner.setWorkspaceDir(new File(LocalToolPreferences.this.preferenceStore.getString("tools.workspace")));
            runner.setupExecutionEnvironment();
            toolInfo.isValid = false;
            LocalToolPreferences.this.updateIsValidLabel(toolInfo.isValid);
            if (!runner.testToolExistence()) {
                LocalToolPreferences.this.isToolValidLabel.setText("Executable/Script file not exist.");
                LocalToolPreferences.this.isToolValidLabel.setForeground(Display.getCurrent().getSystemColor(3));
                return;
            }
            if (!runner.testToolInstallation()) {
                LocalToolPreferences.this.isToolValidLabel.setText("Invalid installation.");
                LocalToolPreferences.this.isToolValidLabel.setForeground(Display.getCurrent().getSystemColor(3));
                return;
            }
            if (!toolInfo.isScript) {
                if (!runner.testToolExecutionPermission()) {
                    LocalToolPreferences.this.isToolValidLabel.setText("Wrong execution permissions.");
                    LocalToolPreferences.this.isToolValidLabel.setForeground(Display.getCurrent().getSystemColor(3));
                    return;
                }
                String version = runner.getToolVersion();
                if (version == null || version.isEmpty()) {
                    MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)("Tool - Test " + this.toolName), (String)"Tool not found.");
                    return;
                }
                if (!runner.testToolVersion(version)) {
                    LocalToolPreferences.this.isToolValidLabel.setText("Unsupported version.");
                    LocalToolPreferences.this.isToolValidLabel.setForeground(Display.getCurrent().getSystemColor(3));
                    MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)("Tool - Test " + this.toolName), (String)("Unsupported version " + version + ". Expected >= " + runner.getMinToolVersion()));
                } else {
                    MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)("Tool - Test " + this.toolName), (String)(" Found " + this.toolName + ", version " + (version.equals("0.0.0") ? "???" : version)));
                }
            }
            toolInfo.isValid = true;
            LocalToolPreferences.this.updateIsValidLabel(toolInfo.isValid);
            LocalToolPreferences.this.parentComposite.getShell().pack();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }

    private class ToolInfo {
        String name;
        String executablePreferenceKey;
        String executionTimeoutPreferenceKey;
        String isValidPreferenceKey;
        boolean isValid = false;
        boolean isScript = false;

        private ToolInfo() {
        }
    }
}

