/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.tools.adapter.ui.preferences.tools;

import eu.fbk.tools.adapter.oslc.OslcAutomationServiceConsumer;
import eu.fbk.tools.adapter.oslc.OslcServiceProviderCatalogConsumer;
import eu.fbk.tools.adapter.ui.Activator;
import eu.fbk.tools.adapter.ui.preferences.PreferenceUtils;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.DirectoryFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.lyo.oslc4j.automation.AutomationPlan;
import org.eclipse.lyo.oslc4j.automation.AutomationResource;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class OslcToolPreferences {
    private StringFieldEditor baseUrlFieldEditor;
    private StringFieldEditor catalogPathFieldEditor;
    private final Set<String> checkedServiceProviderIds = new HashSet<String>();
    private final Map<String, String> checkedAutomationPlanIdToServiceProviderId = new Hashtable<String, String>();
    private final Set<String> automationPlanIdsToBeRemoved = new HashSet<String>();
    private String selectedServiceProviderId;
    private List<OslcServiceProviderCatalogConsumer.ServiceDescription> serviceDescriptions;
    private final List<FieldEditor> fieldEditors = new ArrayList<FieldEditor>();
    private Composite parentComposite;
    private final IPreferenceStore preferenceStore = Activator.getDefault().getPreferenceStore();
    private static final int SERVICE_PROVIDER_ID_COLUMN = 0;
    private Table serviceProviderTable;
    private static final int AUTOMATION_PLANS_ID_COLUMN = 0;
    private Table automationPlanTable;
    private Button selectAllButton;

    public Composite create(Composite parent) {
        this.parentComposite = parent;
        Composite composite1 = new Composite(parent, 2048);
        composite1.setLayout((Layout)new GridLayout(1, true));
        composite1.setLayoutData((Object)new GridData(4, 0, true, false));
        Composite composite1_1 = new Composite(composite1, 0);
        composite1_1.setLayout((Layout)new GridLayout(1, true));
        composite1_1.setLayoutData((Object)new GridData(4, 0, true, false));
        DirectoryFieldEditor workspaceFieldEditor = new DirectoryFieldEditor("tools.workspace", "Workspace dir", composite1_1);
        this.fieldEditors.add((FieldEditor)workspaceFieldEditor);
        Composite composite1_2 = new Composite(composite1, 0);
        composite1_2.setLayout((Layout)new GridLayout(1, true));
        composite1_2.setLayoutData((Object)new GridData(4, 0, true, false));
        this.fieldEditors.add((FieldEditor)new BooleanFieldEditor("tools.workspace.cleanup", "Cleanup workspace at next startup", composite1_2));
        Composite composite2 = new Composite(parent, 2048);
        composite2.setLayout((Layout)new GridLayout(1, true));
        composite2.setLayoutData((Object)new GridData(4, 0, true, false));
        Composite composite2_1 = new Composite(composite2, 0);
        composite2_1.setLayout((Layout)new GridLayout(1, true));
        composite2_1.setLayoutData((Object)new GridData(4, 0, true, false));
        BooleanFieldEditor oslcEnabled = new BooleanFieldEditor("oslc.serviceprovider.enables", "OSLC Enabled", composite2_1);
        oslcEnabled.getDescriptionControl(composite2_1).setToolTipText("Enable oslc");
        this.fieldEditors.add((FieldEditor)oslcEnabled);
        Composite composite2_2 = new Composite(composite2, 0);
        composite2_2.setLayout((Layout)new GridLayout(1, true));
        composite2_2.setLayoutData((Object)new GridData(4, 0, true, false));
        this.baseUrlFieldEditor = new StringFieldEditor("oslc.serviceprovider.catalog.baseurl", "Service catalog base url", composite2_2);
        this.fieldEditors.add((FieldEditor)this.baseUrlFieldEditor);
        this.catalogPathFieldEditor = new StringFieldEditor("oslc.serviceprovider.catalog.path", "Service catalog path", composite2_2);
        this.fieldEditors.add((FieldEditor)this.catalogPathFieldEditor);
        Composite composite2_3 = new Composite(composite2, 0);
        composite2_3.setLayout((Layout)new GridLayout(2, false));
        composite2_3.setLayoutData((Object)new GridData(4, 0, true, false));
        this.createShowServiceProviderCatalogButton(composite2_3);
        this.createServiceProviderTable(composite2_3);
        this.createAutomationPlanTable(composite2_3);
        return this.parentComposite;
    }

    private void createShowServiceProviderCatalogButton(Composite parent) {
        Button loadButton = new Button(parent, 8);
        loadButton.setAlignment(0x1000000);
        loadButton.setText("Show services catalog");
        loadButton.setToolTipText("Show the service provider catalog");
        loadButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OslcToolPreferences.this.loadServiceProvidersCatalog();
            }
        });
    }

    private void loadServiceProvidersCatalog() {
        try {
            URL url = this.getCatalogUrl();
            OslcServiceProviderCatalogConsumer catalogServiceProvider = new OslcServiceProviderCatalogConsumer(url.toString());
            this.serviceDescriptions = catalogServiceProvider.getServiceDescriptions();
            if (this.serviceDescriptions == null) {
                MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"OSCL Service Provider Catalog", (String)("Loading catalog at " + catalogServiceProvider.getServiceProviderCatalogURL().toString() + " has failed.\n\nPlease, check the connection parameters and the oslc registry availability."));
                return;
            }
            this.checkedServiceProviderIds.clear();
            this.showServiceProviders();
        }
        catch (MalformedURLException malformedURLException) {
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"OSCL Service Provider Catalog", (String)"Invalid service catalog url");
        }
    }

    private void createServiceProviderTable(Composite parent) {
        this.serviceProviderTable = new Table(parent, 67616);
        this.serviceProviderTable.setLayoutData((Object)new GridData(4, 0, true, false));
        this.serviceProviderTable.setHeaderVisible(true);
        this.serviceProviderTable.setLinesVisible(true);
        String[] titles = new String[]{"ID", "Description", "Publisher", "OSLC Domain"};
        Integer[] sizes = new Integer[]{50, 150, 200, 400};
        int loopIndex = 0;
        while (loopIndex < titles.length) {
            TableColumn column = new TableColumn(this.serviceProviderTable, 0);
            column.setText(titles[loopIndex]);
            column.setWidth(sizes[loopIndex].intValue());
            column.setResizable(true);
            ++loopIndex;
        }
        this.serviceProviderTable.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (e != null && e.getSource() instanceof Table) {
                    TableItem tableItem = (TableItem)e.item;
                    OslcToolPreferences.this.selectedServiceProviderId = tableItem.getText(0);
                    if (e.detail == 32) {
                        if (((TableItem)e.item).getChecked()) {
                            OslcToolPreferences.this.checkedServiceProviderIds.add(OslcToolPreferences.this.selectedServiceProviderId);
                        } else {
                            OslcToolPreferences.this.checkedServiceProviderIds.remove(OslcToolPreferences.this.selectedServiceProviderId);
                            OslcToolPreferences.this.clearAutomationPlansByServiceProviderId(OslcToolPreferences.this.selectedServiceProviderId);
                        }
                    }
                    OslcToolPreferences.this.updateServiceProviderSelection(OslcToolPreferences.this.serviceProviderTable);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private void createAutomationPlanTable(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        Label label = new Label(composite, 0);
        label.setText("Automation Plans");
        this.selectAllButton = new Button(composite, 32);
        this.selectAllButton.setEnabled(false);
        this.selectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (e != null && e.getSource() instanceof Button) {
                    OslcToolPreferences.this.selectAllButton.setGrayed(false);
                    TableItem[] tableItemArray = OslcToolPreferences.this.automationPlanTable.getItems();
                    int n = tableItemArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TableItem tableItem = tableItemArray[n2];
                        String automationPlanId = tableItem.getText(0);
                        if (OslcToolPreferences.this.selectAllButton.getSelection() && !tableItem.getChecked()) {
                            OslcToolPreferences.this.traceAutomationPlanCheck(automationPlanId, OslcToolPreferences.this.selectedServiceProviderId);
                        }
                        if (!OslcToolPreferences.this.selectAllButton.getSelection() && tableItem.getChecked()) {
                            OslcToolPreferences.this.untraceAutomationPlanCheck(automationPlanId);
                        }
                        tableItem.setChecked(OslcToolPreferences.this.selectAllButton.getSelection());
                        ++n2;
                    }
                }
            }
        });
        this.automationPlanTable = new Table(parent, 67616);
        this.automationPlanTable.setLayoutData((Object)new GridData(4, 0, true, false));
        this.automationPlanTable.setHeaderVisible(true);
        this.automationPlanTable.setLinesVisible(true);
        String[] titles = new String[]{"ID", "Description"};
        Integer[] sizes = new Integer[]{50, 750};
        int loopIndex = 0;
        while (loopIndex < titles.length) {
            TableColumn column = new TableColumn(this.automationPlanTable, 0);
            column.setText(titles[loopIndex]);
            column.setWidth(sizes[loopIndex].intValue());
            column.setResizable(true);
            ++loopIndex;
        }
        this.automationPlanTable.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (e != null && e.getSource() instanceof Table) {
                    TableItem tableItem = (TableItem)e.item;
                    String automationPlanId = tableItem.getText(0);
                    if (e.detail == 32) {
                        String relatedServiceProviderId = (String)OslcToolPreferences.this.checkedAutomationPlanIdToServiceProviderId.get(automationPlanId);
                        if (relatedServiceProviderId != null && !relatedServiceProviderId.equals(OslcToolPreferences.this.selectedServiceProviderId)) {
                            tableItem.setChecked(false);
                        }
                        if (((TableItem)e.item).getChecked()) {
                            OslcToolPreferences.this.traceAutomationPlanCheck(automationPlanId, OslcToolPreferences.this.selectedServiceProviderId);
                        } else {
                            OslcToolPreferences.this.untraceAutomationPlanCheck(automationPlanId);
                        }
                        OslcToolPreferences.this.updateAutomationPlanSelectAllButton();
                    }
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    public List<FieldEditor> getFieldEditors() {
        return this.fieldEditors;
    }

    public void performApply() {
        try {
            this.validateCatalogUrl();
            this.persistCheckedServiceProviders();
            this.persistCheckedAutomationPlans();
        }
        catch (MalformedURLException malformedURLException) {
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"OSCL Service Provider Catalog", (String)"Invalid service catalog url");
        }
    }

    public void performDefaults() {
    }

    private URL validateCatalogUrl() throws MalformedURLException {
        String catalogPath = this.catalogPathFieldEditor.getStringValue();
        if (!catalogPath.startsWith("/")) {
            this.catalogPathFieldEditor.setStringValue("/" + catalogPath);
        }
        return new URL(String.valueOf(this.baseUrlFieldEditor.getStringValue()) + this.catalogPathFieldEditor.getStringValue());
    }

    private URL getCatalogUrl() throws MalformedURLException {
        return new URL(String.valueOf(this.baseUrlFieldEditor.getStringValue()) + this.catalogPathFieldEditor.getStringValue());
    }

    private void updateServiceProviderSelection(Table table) {
        try {
            this.showAutomationPlans(this.getCatalogUrl(), this.selectedServiceProviderId);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
    }

    private void showServiceProviders() {
        this.serviceProviderTable.removeAll();
        if (this.serviceDescriptions == null) {
            return;
        }
        this.checkedServiceProviderIds.clear();
        String joinedServiceProviderIds = this.preferenceStore.getString("oslc.serviceprovider.ids");
        Set<String> serviceProviderIds = PreferenceUtils.deserializeServiceProvidersIds(joinedServiceProviderIds);
        for (OslcServiceProviderCatalogConsumer.ServiceDescription serviceDescription : this.serviceDescriptions) {
            if (!serviceProviderIds.contains(serviceDescription.serviceProviderId)) continue;
            this.checkedServiceProviderIds.add(serviceDescription.serviceProviderId);
        }
        for (OslcServiceProviderCatalogConsumer.ServiceDescription serviceDescription : this.serviceDescriptions) {
            TableItem item = new TableItem(this.serviceProviderTable, 0);
            item.setText(0, serviceDescription.serviceProviderId);
            item.setText(1, serviceDescription.title);
            item.setText(2, serviceDescription.publisher);
            item.setText(3, serviceDescription.domain);
            item.setChecked(false);
            if (this.checkedServiceProviderIds.contains(serviceDescription.serviceProviderId)) {
                item.setChecked(true);
                continue;
            }
            if (this.serviceDescriptions.size() != 1) continue;
            this.checkedServiceProviderIds.add(serviceDescription.serviceProviderId);
            item.setChecked(true);
        }
        this.persistCheckedServiceProviders();
        TableColumn[] tableColumnArray = this.serviceProviderTable.getColumns();
        int n = tableColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableColumn column = tableColumnArray[n2];
            column.pack();
            ++n2;
        }
        this.serviceProviderTable.pack();
        this.automationPlanTable.requestLayout();
    }

    private void showAutomationPlans(URL catalogUrl, String serviceProviderId) {
        OslcAutomationServiceConsumer oslcAutomationServiceConsumer = new OslcAutomationServiceConsumer(catalogUrl.toString(), serviceProviderId);
        AutomationResource[] automationPlans = oslcAutomationServiceConsumer.getAutomationPlans();
        this.automationPlanTable.removeAll();
        if (automationPlans == null) {
            return;
        }
        this.selectAllButton.setEnabled(true);
        if (this.checkedServiceProviderIds.contains(serviceProviderId)) {
            AutomationResource[] automationResourceArray = automationPlans;
            int n = automationPlans.length;
            int n2 = 0;
            while (n2 < n) {
                AutomationResource automationPlan = automationResourceArray[n2];
                String storedServiceProviderId = this.preferenceStore.getString(automationPlan.getIdentifier());
                if (storedServiceProviderId != null && storedServiceProviderId.equals(serviceProviderId)) {
                    this.checkedAutomationPlanIdToServiceProviderId.put(automationPlan.getIdentifier(), serviceProviderId);
                }
                ++n2;
            }
            this.automationPlanTable.setEnabled(true);
        } else {
            this.automationPlanTable.setEnabled(false);
            this.selectAllButton.setEnabled(false);
        }
        List<AutomationResource> sortedAutomatioPlans = Arrays.asList(automationPlans);
        sortedAutomatioPlans.sort((ar1, ar2) -> ar1.getIdentifier().compareTo(ar2.getIdentifier()));
        for (AutomationResource automationPlan : sortedAutomatioPlans) {
            TableItem item = new TableItem(this.automationPlanTable, 0);
            item.setText(0, automationPlan.getIdentifier());
            item.setText(1, ((AutomationPlan)automationPlan).getDescription());
            item.setChecked(false);
            String serviceProviderIdOfCheckedAutomationPlan = this.checkedAutomationPlanIdToServiceProviderId.get(automationPlan.getIdentifier());
            if (serviceProviderIdOfCheckedAutomationPlan == null || !serviceProviderIdOfCheckedAutomationPlan.equals(serviceProviderId)) continue;
            item.setChecked(true);
        }
        this.updateAutomationPlanSelectAllButton();
        TableColumn[] tableColumnArray = this.automationPlanTable.getColumns();
        int n = tableColumnArray.length;
        int n3 = 0;
        while (n3 < n) {
            TableColumn column = tableColumnArray[n3];
            column.pack();
            ++n3;
        }
        this.automationPlanTable.pack();
        this.automationPlanTable.getShell().pack();
    }

    private void persistCheckedServiceProviders() {
        String joinedServiceProviderIds = this.checkedServiceProviderIds.stream().collect(Collectors.joining(","));
        this.preferenceStore.setValue("oslc.serviceprovider.ids", joinedServiceProviderIds);
    }

    private void persistCheckedAutomationPlans() {
        for (String string : this.automationPlanIdsToBeRemoved) {
            this.preferenceStore.setValue(string, "");
        }
        for (Map.Entry entry : this.checkedAutomationPlanIdToServiceProviderId.entrySet()) {
            this.preferenceStore.setValue((String)entry.getKey(), (String)entry.getValue());
        }
    }

    private void clearAutomationPlansByServiceProviderId(String serviceProviderId) {
        for (Map.Entry<String, String> entrySet : new Hashtable<String, String>(this.checkedAutomationPlanIdToServiceProviderId).entrySet()) {
            if (!entrySet.getValue().equals(this.selectedServiceProviderId)) continue;
            this.untraceAutomationPlanCheck(entrySet.getKey());
        }
    }

    private void traceAutomationPlanCheck(String automationPlanId, String serviceProviderId) {
        this.checkedAutomationPlanIdToServiceProviderId.put(automationPlanId, serviceProviderId);
        this.automationPlanIdsToBeRemoved.remove(automationPlanId);
    }

    private void untraceAutomationPlanCheck(String automationPlanId) {
        this.checkedAutomationPlanIdToServiceProviderId.remove(automationPlanId);
        this.automationPlanIdsToBeRemoved.add(automationPlanId);
    }

    private void updateAutomationPlanSelectAllButton() {
        int amountOfCheckedPlans = 0;
        TableItem[] tableItemArray = this.automationPlanTable.getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem tableItem = tableItemArray[n2];
            if (tableItem.getChecked()) {
                ++amountOfCheckedPlans;
            }
            ++n2;
        }
        this.selectAllButton.setGrayed(false);
        if (amountOfCheckedPlans == 0) {
            this.selectAllButton.setSelection(false);
        } else if (amountOfCheckedPlans == this.automationPlanTable.getItemCount()) {
            this.selectAllButton.setSelection(true);
        } else if (amountOfCheckedPlans < this.automationPlanTable.getItemCount()) {
            this.selectAllButton.setGrayed(true);
            this.selectAllButton.setSelection(true);
        }
    }
}

