/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.tools.adapter.ui.views.tree;

import eu.fbk.tools.adapter.ui.Activator;
import eu.fbk.tools.adapter.ui.views.tree.TreeObject;
import eu.fbk.tools.adapter.ui.views.tree.TreeViewContentProvider;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.part.ViewPart;

public abstract class TreeView
extends ViewPart {
    private TreeViewer viewer;
    private Cursor cursor = null;
    private final ModelChangeListener modelChangeListener = new ModelChangeListener();

    public void setViewer(TreeViewer viewer) {
        this.viewer = viewer;
        this.cursor = new Cursor((Device)viewer.getControl().getDisplay(), 1);
    }

    public TreeViewer getTreeViewer() {
        return this.viewer;
    }

    protected void enableModelChangeListener(boolean enable) {
        TreeViewContentProvider treeViewContentProvider = (TreeViewContentProvider)this.getTreeViewer().getContentProvider();
        if (treeViewContentProvider == null) {
            return;
        }
        if (enable) {
            treeViewContentProvider.addListener(this.modelChangeListener);
        } else {
            treeViewContentProvider.removeListener(this.modelChangeListener);
        }
    }

    protected ModelChangeListener getModelChangeListener() {
        return this.modelChangeListener;
    }

    protected void setWaitCursor(boolean enable) {
        Shell shell = this.viewer.getControl().getShell();
        if (shell.isDisposed()) {
            return;
        }
        if (enable) {
            shell.setCursor(this.cursor);
        } else {
            shell.setCursor(null);
        }
    }

    protected void hookContextMenu() {
        MenuManager menuMgr = new MenuManager(null);
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                TreeView.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    protected void fillContextMenu(IMenuManager manager) {
        this.addRefreshMenu(manager);
        this.addMenuSeparator(manager);
    }

    public void asyncRefresh(final boolean force) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                TreeView.this.refresh(force);
            }
        });
    }

    public synchronized void refresh(boolean force) {
        if (!force) {
            if (this.viewer.getControl().isDisposed()) {
                return;
            }
            if (!this.viewer.getControl().isVisible()) {
                return;
            }
        }
        try {
            this.setWaitCursor(true);
            Object[] expandedObjects = this.viewer.getExpandedElements();
            ((TreeViewContentProvider)this.viewer.getContentProvider()).refresh();
            this.viewer.refresh();
            int i = 0;
            while (i < expandedObjects.length) {
                String id = ((TreeObject)expandedObjects[i]).getId();
                TreeObject object = ((TreeViewContentProvider)this.viewer.getContentProvider()).getElementById(id);
                if (object != null) {
                    this.viewer.setExpandedState((Object)object, true);
                }
                ++i;
            }
        }
        finally {
            this.setWaitCursor(false);
        }
    }

    protected void addRefreshMenu(IMenuManager manager) {
        Action refresh = new Action(){

            public void run() {
                TreeView.this.refresh(false);
            }
        };
        ImageDescriptor image = Activator.getImageDescriptor("icons/update.png");
        if (image != null) {
            refresh.setImageDescriptor(image);
        }
        refresh.setText("Refresh");
        manager.add((IAction)refresh);
    }

    protected void addMenuSeparator(IMenuManager manager) {
        manager.add((IContributionItem)new Separator());
        manager.add((IContributionItem)new Separator("additions"));
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    public void dispose() {
        super.dispose();
        if (this.cursor != null) {
            this.cursor.dispose();
            this.cursor = null;
        }
        this.enableModelChangeListener(false);
    }

    private class ModelChangeListener
    implements IPropertyChangeListener {
        private ModelChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent event) {
            TreeView.this.asyncRefresh(true);
        }
    }
}

