/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.engine.internal.evaluation;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.Calendar;
import org.eclipse.acceleo.engine.AcceleoEngineMessages;
import org.eclipse.acceleo.engine.AcceleoEnginePlugin;
import org.eclipse.emf.codegen.merge.java.JControlModel;
import org.eclipse.emf.codegen.merge.java.JMerger;
import org.eclipse.emf.codegen.merge.java.facade.FacadeHelper;
import org.eclipse.emf.codegen.merge.java.facade.ast.ASTFacadeHelper;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;

public final class JMergeUtil {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");

    private JMergeUtil() {
    }

    public static String mergeFileContent(File target, String content, String charset) throws IOException {
        if (!EMFPlugin.IS_ECLIPSE_RUNNING) {
            return content;
        }
        String newContent = content;
        if (target.getName().endsWith(".java")) {
            String jmergeFile = URI.createPlatformPluginURI((String)"org.eclipse.emf.codegen.ecore/templates/emf-merge.xml", (boolean)false).toString();
            JControlModel model = new JControlModel();
            model.initialize((FacadeHelper)new ASTFacadeHelper(), jmergeFile);
            if (model.canMerge()) {
                try {
                    JMerger jMerger = new JMerger(model);
                    jMerger.setSourceCompilationUnit(jMerger.createCompilationUnitForContents(content));
                    jMerger.setTargetCompilationUnit(jMerger.createCompilationUnitForInputStream((InputStream)new FileInputStream(target), charset));
                    jMerger.merge();
                    newContent = jMerger.getTargetCompilationUnit().getContents();
                }
                catch (WrappedException wrappedException) {
                    try {
                        JMergeUtil.createLostFile(target);
                    }
                    catch (IOException iOException) {}
                    AcceleoEnginePlugin.log(AcceleoEngineMessages.getString("JMergeUtilError", target.getName()), false);
                }
            }
        }
        return newContent;
    }

    private static void createLostFile(File file) throws IOException {
        FileChannel source = null;
        AbstractInterruptibleChannel destination = null;
        try {
            source = new FileInputStream(file).getChannel();
            destination = new FileOutputStream(file.toString().concat(".lost"), true).getChannel();
            StringBuilder timestamp = new StringBuilder();
            timestamp.append(LINE_SEPARATOR).append(Calendar.getInstance().getTime().toString()).append(LINE_SEPARATOR);
            timestamp.append("================================================================================");
            timestamp.append(LINE_SEPARATOR);
            ((FileChannel)destination).write(ByteBuffer.wrap(timestamp.toString().getBytes()));
            source.transferTo(0L, source.size(), (WritableByteChannel)((Object)destination));
        }
        finally {
            if (destination != null) {
                destination.close();
            }
            if (source != null) {
                source.close();
            }
        }
    }

    public static String mergeContent(File target, String content, String oldContent) throws IOException {
        if (!EMFPlugin.IS_ECLIPSE_RUNNING) {
            return content;
        }
        String newContent = content;
        if (target.getName().endsWith(".java")) {
            String jmergeFile = URI.createPlatformPluginURI((String)"org.eclipse.emf.codegen.ecore/templates/emf-merge.xml", (boolean)false).toString();
            JControlModel model = new JControlModel();
            model.initialize((FacadeHelper)new ASTFacadeHelper(), jmergeFile);
            if (model.canMerge()) {
                try {
                    JMerger jMerger = new JMerger(model);
                    jMerger.setSourceCompilationUnit(jMerger.createCompilationUnitForContents(content));
                    jMerger.setTargetCompilationUnit(jMerger.createCompilationUnitForContents(oldContent));
                    jMerger.merge();
                    newContent = jMerger.getTargetCompilationUnit().getContents();
                }
                catch (WrappedException wrappedException) {
                    AcceleoEnginePlugin.log(AcceleoEngineMessages.getString("JMergeUtilError", target.getName()), false);
                }
            }
        }
        return newContent;
    }
}

