/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.internal.cdo.object;

import org.eclipse.emf.cdo.CDOElement;
import org.eclipse.emf.cdo.CDOLock;
import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.lock.CDOLockState;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.security.CDOPermission;
import org.eclipse.emf.cdo.util.CDOUtil;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.internal.cdo.object.CDOElementTester;
import org.eclipse.net4j.util.properties.DefaultPropertyTester;
import org.eclipse.net4j.util.properties.IProperties;
import org.eclipse.net4j.util.properties.Properties;
import org.eclipse.net4j.util.properties.Property;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectProperties
extends Properties<EObject> {
    public static final IProperties<EObject> INSTANCE = new ObjectProperties();
    public static final String NAMESPACE = "org.eclipse.emf.cdo.object";
    private static final String CATEGORY_CDO = "CDO";

    private ObjectProperties() {
        super(EObject.class);
        this.add((Property)new Property<EObject>("isCDO"){

            protected Object eval(EObject object) {
                if (ObjectProperties.getCDOObject(object) != null) {
                    return true;
                }
                return false;
            }
        });
        this.add((Property)new Property<EObject>("id", "ID", "The technical CDOID of this object.", CATEGORY_CDO){

            protected Object eval(EObject object) {
                CDOObject cdoObject = ObjectProperties.getCDOObject(object);
                if (cdoObject == null) {
                    return null;
                }
                return cdoObject.cdoID();
            }
        });
        this.add((Property)new Property<EObject>("version", "Version", "The version of this object.", CATEGORY_CDO){

            protected Object eval(EObject object) {
                CDOObject cdoObject = ObjectProperties.getCDOObject(object);
                if (cdoObject == null) {
                    return 0;
                }
                CDORevision revision = cdoObject.cdoRevision();
                if (revision == null) {
                    return 0;
                }
                return revision.getVersion();
            }
        });
        this.add((Property)new Property<EObject>("branch", "Branch", "The branch of this object.", CATEGORY_CDO){

            protected Object eval(EObject object) {
                CDOObject cdoObject = ObjectProperties.getCDOObject(object);
                if (cdoObject == null) {
                    return null;
                }
                CDORevision revision = cdoObject.cdoRevision();
                if (revision == null) {
                    return null;
                }
                return revision.getBranch().getPathName();
            }
        });
        this.add((Property)new Property<EObject>("state", "State", "The current state of this object.", CATEGORY_CDO){

            protected Object eval(EObject object) {
                CDOObject cdoObject = ObjectProperties.getCDOObject(object);
                if (cdoObject == null) {
                    return null;
                }
                return cdoObject.cdoState();
            }
        });
        this.add((Property)new Property<EObject>("transactional"){

            protected Object eval(EObject object) {
                CDOObject cdoObject = ObjectProperties.getCDOObject(object);
                if (cdoObject == null) {
                    return false;
                }
                CDOView view = cdoObject.cdoView();
                if (view == null) {
                    return false;
                }
                return !view.isReadOnly();
            }
        });
        this.add((Property)new Property<EObject>("readable"){

            protected Object eval(EObject object) {
                CDOObject cdoObject = ObjectProperties.getCDOObject(object);
                if (cdoObject == null) {
                    return true;
                }
                if (cdoObject.cdoPermission() != CDOPermission.NONE) {
                    return true;
                }
                return false;
            }
        });
        this.add((Property)new Property<EObject>("writable"){

            protected Object eval(EObject object) {
                CDOObject cdoObject = ObjectProperties.getCDOObject(object);
                if (cdoObject == null) {
                    return true;
                }
                CDOView view = cdoObject.cdoView();
                if (view == null) {
                    return true;
                }
                if (!view.isReadOnly() && cdoObject.cdoPermission() == CDOPermission.WRITE) {
                    return true;
                }
                return false;
            }
        });
        this.add((Property)new Property<EObject>("writableContainer"){

            protected Object eval(EObject object) {
                EObject container = CDOElement.getParentOf(object);
                if (container == null) {
                    return true;
                }
                CDOObject cdoContainer = ObjectProperties.getCDOObject(container);
                if (cdoContainer == null) {
                    return true;
                }
                CDOView view = cdoContainer.cdoView();
                if (view == null) {
                    return true;
                }
                if (!view.isReadOnly() && cdoContainer.cdoPermission() == CDOPermission.WRITE) {
                    return true;
                }
                return false;
            }
        });
        this.add((Property)new Property<EObject>("container"){

            protected Object eval(EObject object) {
                EObject container = CDOElement.getParentOf(object);
                if (container == null) {
                    return false;
                }
                CDOObject cdoContainer = ObjectProperties.getCDOObject(container);
                if (cdoContainer == null) {
                    return false;
                }
                return true;
            }
        });
        this.add((Property)new Property<EObject>("children"){

            protected Object eval(EObject object) {
                return !object.eContents().isEmpty();
            }
        });
        this.add((Property)new Property<EObject>("permission", "Permission", "The permission the current user has for this object.", CATEGORY_CDO){

            protected Object eval(EObject object) {
                CDOObject cdoObject = ObjectProperties.getCDOObject(object);
                if (cdoObject == null) {
                    return null;
                }
                return cdoObject.cdoPermission();
            }
        });
        this.add((Property)new Property<EObject>("permissionContainer"){

            protected Object eval(EObject object) {
                Resource resource;
                CDOObject cdoObject = null;
                EObject eContainer = object.eContainer();
                if (eContainer != null) {
                    cdoObject = ObjectProperties.getCDOObject(eContainer);
                }
                if (cdoObject == null && (resource = object.eResource()) instanceof CDOObject) {
                    cdoObject = (CDOObject)resource;
                }
                if (cdoObject == null) {
                    return null;
                }
                return cdoObject.cdoPermission();
            }
        });
        this.add((Property)new Property<EObject>("readLocks", "Read Locks", "The owner of read locks on this object.", CATEGORY_CDO){

            protected Object eval(EObject object) {
                CDOObject cdoObject = ObjectProperties.getCDOObject(object);
                if (cdoObject == null) {
                    return null;
                }
                CDOLockState lockState = cdoObject.cdoLockState();
                if (lockState == null) {
                    return null;
                }
                return lockState.getReadLockOwners();
            }
        });
        this.add((Property)new Property<EObject>("readLocked"){

            protected Object eval(EObject object) {
                CDOObject cdoObject = ObjectProperties.getCDOObject(object);
                if (cdoObject == null) {
                    return false;
                }
                CDOView view = cdoObject.cdoView();
                if (view == null) {
                    return false;
                }
                CDOLock lock = cdoObject.cdoReadLock();
                if (lock == null) {
                    return false;
                }
                return lock.isLocked();
            }
        });
        this.add((Property)new Property<EObject>("readLockedByOthers"){

            protected Object eval(EObject object) {
                CDOObject cdoObject = ObjectProperties.getCDOObject(object);
                if (cdoObject == null) {
                    return false;
                }
                CDOView view = cdoObject.cdoView();
                if (view == null) {
                    return false;
                }
                CDOLock lock = cdoObject.cdoReadLock();
                if (lock == null) {
                    return false;
                }
                return lock.isLockedByOthers();
            }
        });
        this.add((Property)new Property<EObject>("writeLock", "Write Lock", "The owner of a write lock on this object.", CATEGORY_CDO){

            protected Object eval(EObject object) {
                CDOObject cdoObject = ObjectProperties.getCDOObject(object);
                if (cdoObject == null) {
                    return null;
                }
                CDOLockState lockState = cdoObject.cdoLockState();
                if (lockState == null) {
                    return null;
                }
                return lockState.getWriteLockOwner();
            }
        });
        this.add((Property)new Property<EObject>("writeLocked"){

            protected Object eval(EObject object) {
                CDOObject cdoObject = ObjectProperties.getCDOObject(object);
                if (cdoObject == null) {
                    return false;
                }
                CDOView view = cdoObject.cdoView();
                if (view == null) {
                    return false;
                }
                CDOLock lock = cdoObject.cdoWriteLock();
                if (lock == null) {
                    return false;
                }
                return lock.isLocked();
            }
        });
        this.add((Property)new Property<EObject>("writeLockedByOthers"){

            protected Object eval(EObject object) {
                CDOObject cdoObject = ObjectProperties.getCDOObject(object);
                if (cdoObject == null) {
                    return false;
                }
                CDOView view = cdoObject.cdoView();
                if (view == null) {
                    return false;
                }
                CDOLock lock = cdoObject.cdoWriteLock();
                if (lock == null) {
                    return false;
                }
                return lock.isLockedByOthers();
            }
        });
        this.add((Property)new Property<EObject>("writeOption", "Write Option", "The owner of a write option on this object.", CATEGORY_CDO){

            protected Object eval(EObject object) {
                CDOObject cdoObject = ObjectProperties.getCDOObject(object);
                if (cdoObject == null) {
                    return null;
                }
                CDOLockState lockState = cdoObject.cdoLockState();
                if (lockState == null) {
                    return null;
                }
                return lockState.getWriteOptionOwner();
            }
        });
        this.add((Property)new Property<EObject>("writeOptioned"){

            protected Object eval(EObject object) {
                CDOObject cdoObject = ObjectProperties.getCDOObject(object);
                if (cdoObject == null) {
                    return false;
                }
                CDOView view = cdoObject.cdoView();
                if (view == null) {
                    return false;
                }
                CDOLock lock = cdoObject.cdoWriteOption();
                if (lock == null) {
                    return false;
                }
                return lock.isLocked();
            }
        });
        this.add((Property)new Property<EObject>("writeOptionedByOthers"){

            protected Object eval(EObject object) {
                CDOObject cdoObject = ObjectProperties.getCDOObject(object);
                if (cdoObject == null) {
                    return false;
                }
                CDOView view = cdoObject.cdoView();
                if (view == null) {
                    return false;
                }
                CDOLock lock = cdoObject.cdoWriteOption();
                if (lock == null) {
                    return false;
                }
                return lock.isLockedByOthers();
            }
        });
        this.add((Property)new Property<EObject>("viewHistorical"){

            protected Object eval(EObject object) {
                CDOObject cdoObject = ObjectProperties.getCDOObject(object);
                if (cdoObject == null) {
                    return false;
                }
                CDOView view = cdoObject.cdoView();
                if (view == null) {
                    return false;
                }
                if (view.getTimeStamp() != 0L) {
                    return true;
                }
                return false;
            }
        });
        this.add((Property)new Property<EObject>("uri", "URI", "The URI of this object.", CATEGORY_CDO){

            protected Object eval(EObject object) {
                CDOObject cdoObject = ObjectProperties.getCDOObject(object);
                if (cdoObject == null) {
                    return null;
                }
                Resource resource = cdoObject.eResource();
                if (resource == null) {
                    return null;
                }
                CDOID id = cdoObject.cdoID();
                String fragment = id != null ? id.toURIFragment() : resource.getURIFragment((EObject)cdoObject);
                return resource.getURI().appendFragment(fragment).toString();
            }
        });
    }

    private static CDOObject getCDOObject(EObject object) {
        return CDOUtil.getCDOObject(object, false);
    }

    public static void main(String[] args) {
        new Tester().dumpContributionMarkup();
        new ElementTester().dumpContributionMarkup();
    }

    public static final class ElementTester
    extends CDOElementTester {
        public ElementTester() {
            super(ObjectProperties.NAMESPACE, INSTANCE);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Tester
    extends DefaultPropertyTester<EObject> {
        public Tester() {
            super(ObjectProperties.NAMESPACE, INSTANCE);
        }
    }
}

