/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.tools.editor.oss.validation;

import com.google.inject.Injector;
import eu.fbk.tools.editor.contract.contract.Contract;
import eu.fbk.tools.editor.contract.expression.expression.ComponentId;
import eu.fbk.tools.editor.contract.expression.expression.IteratorBounds;
import eu.fbk.tools.editor.contract.expression.expression.PortId;
import eu.fbk.tools.editor.contract.expression.expression.VariableId;
import eu.fbk.tools.editor.oss.OssStandaloneSetup;
import eu.fbk.tools.editor.oss.oss.AbstractComponent;
import eu.fbk.tools.editor.oss.oss.Component;
import eu.fbk.tools.editor.oss.oss.Connection;
import eu.fbk.tools.editor.oss.oss.Entailment;
import eu.fbk.tools.editor.oss.oss.FullContractIdList;
import eu.fbk.tools.editor.oss.oss.IterativeCondition;
import eu.fbk.tools.editor.oss.oss.OSS;
import eu.fbk.tools.editor.oss.oss.RefinementInstance;
import eu.fbk.tools.editor.oss.oss.SubComponent;
import eu.fbk.tools.editor.oss.oss.SystemComponent;
import eu.fbk.tools.editor.oss.oss.Variable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.resource.SaveOptions;
import org.eclipse.xtext.serializer.ISerializer;

public class ModelUtil {
    static Injector injector;
    static SaveOptions noValidOptions;

    private static String serialize(EObject object) {
        if (injector == null) {
            injector = new OssStandaloneSetup().createInjector();
            noValidOptions = SaveOptions.newBuilder().noValidation().getOptions();
        }
        ISerializer serializer = (ISerializer)injector.getInstance(ISerializer.class);
        return serializer.serialize(object, noValidOptions).trim();
    }

    protected static String getVariableIdAsStr(VariableId variableId) {
        if (variableId instanceof PortId && !((PortId)variableId).getIndexes().isEmpty()) {
            return ModelUtil.serialize((EObject)variableId);
        }
        return variableId.getName();
    }

    protected static String getSubCompIdAsStr(ComponentId subComponentId) {
        if (subComponentId.getIndexes().isEmpty()) {
            return subComponentId.getName();
        }
        return ModelUtil.serialize((EObject)subComponentId);
    }

    public static OSS getRoot(EObject item) {
        if (item == null) {
            return null;
        }
        if (item instanceof OSS) {
            return (OSS)item;
        }
        if (item.eContainer() instanceof OSS) {
            return (OSS)item.eContainer();
        }
        return ModelUtil.getRoot(item.eContainer());
    }

    public static AbstractComponent getComponentType(OSS oss, String name) {
        if (oss.getComponents() != null) {
            for (AbstractComponent component : oss.getComponents()) {
                if (!component.getType().equals(name)) continue;
                return component;
            }
        }
        return null;
    }

    public static AbstractComponent getParentComponentType(EObject item) {
        if (item == null) {
            return null;
        }
        if (item.eContainer() instanceof Component || item.eContainer() instanceof SystemComponent) {
            return (AbstractComponent)item.eContainer();
        }
        return ModelUtil.getParentComponentType(item.eContainer());
    }

    public static boolean isChildComponent(AbstractComponent parentComponent, AbstractComponent component) {
        return ModelUtil.isChildComponent(parentComponent, component, new HashSet<String>());
    }

    private static boolean isChildComponent(AbstractComponent parentComponent, AbstractComponent component, Set<String> traversedNodes) {
        if (parentComponent == null || component == null) {
            return false;
        }
        if (component instanceof SystemComponent) {
            return false;
        }
        traversedNodes.add(parentComponent.getType());
        for (SubComponent subComponent : ModelUtil.getSubComponents(parentComponent)) {
            String subComponentType;
            if (subComponent.getType().equals(component.getType())) {
                return true;
            }
            OSS root = ModelUtil.getRoot(component);
            AbstractComponent tmpComponent = ModelUtil.getComponentType(root, subComponentType = subComponent.getType().getComponentTypeName() != null ? subComponent.getType().getComponentTypeName() : subComponent.getType().getArrayComponentTypeName());
            if (traversedNodes.contains(tmpComponent.getType()) || !ModelUtil.isChildComponent(tmpComponent, component, traversedNodes)) continue;
            return true;
        }
        return false;
    }

    public static List<SubComponent> getSubComponents(AbstractComponent component) {
        ArrayList<SubComponent> subComponents = new ArrayList<SubComponent>();
        if (component == null) {
            return subComponents;
        }
        if (component.getRefinement() == null) {
            return subComponents;
        }
        if (component.getRefinement().getRefinements() == null) {
            return subComponents;
        }
        for (RefinementInstance refinement : component.getRefinement().getRefinements()) {
            if (refinement.getSubcomponent() == null) continue;
            subComponents.add(refinement.getSubcomponent());
        }
        return subComponents;
    }

    public static boolean belongsToEntailment(EObject item) {
        if (item == null) {
            return false;
        }
        if (item instanceof Entailment || item.eContainer() instanceof Entailment) {
            return true;
        }
        return ModelUtil.belongsToEntailment(item.eContainer());
    }

    public static boolean belongsToContract(EObject item) {
        if (item == null) {
            return false;
        }
        if (item instanceof Contract || item.eContainer() instanceof Contract) {
            return true;
        }
        return ModelUtil.belongsToContract(item.eContainer());
    }

    public static boolean belongsToRefinementInstance(EObject item) {
        if (item == null) {
            return false;
        }
        if (item instanceof RefinementInstance || item.eContainer() instanceof RefinementInstance) {
            return true;
        }
        return ModelUtil.belongsToRefinementInstance(item.eContainer());
    }

    public static boolean belongsToConnection(EObject item) {
        if (item == null) {
            return false;
        }
        if (item.eContainer() instanceof Connection) {
            return true;
        }
        return ModelUtil.belongsToConnection(item.eContainer());
    }

    public static boolean belongsToFullContractIdList(EObject item) {
        if (item == null) {
            return false;
        }
        if (item.eContainer() instanceof FullContractIdList) {
            return true;
        }
        return ModelUtil.belongsToFullContractIdList(item.eContainer());
    }

    public static boolean belongsToIteratorCondition(EObject item) {
        if (item == null) {
            return false;
        }
        if (item.eContainer() instanceof IterativeCondition) {
            return true;
        }
        return ModelUtil.belongsToIteratorCondition(item.eContainer());
    }

    public static Connection getParentConnection(EObject item) {
        if (item == null) {
            return null;
        }
        if (item.eContainer() instanceof Connection) {
            return (Connection)item.eContainer();
        }
        return ModelUtil.getParentConnection(item.eContainer());
    }

    public static FullContractIdList getParentFullContractIdList(EObject item) {
        if (item == null) {
            return null;
        }
        if (item.eContainer() instanceof FullContractIdList) {
            return (FullContractIdList)item.eContainer();
        }
        return ModelUtil.getParentFullContractIdList(item.eContainer());
    }

    public static IteratorBounds getIteratorBoundsFromConnection(Connection item) {
        if (item == null || item.getConstraint() == null || item.getIterativeCondition() == null) {
            return null;
        }
        return item.getIterativeCondition().getIteratorBounds();
    }

    public static IteratorBounds getIteratorBoundsFromFullContractIdList(FullContractIdList item) {
        if (item == null || item.getIteratorBounds() == null) {
            return null;
        }
        return (IteratorBounds)item.getIteratorBounds().get(0);
    }

    public static boolean belongsToSubComponent(EObject item) {
        if (item == null) {
            return false;
        }
        if (item instanceof SubComponent || item.eContainer() instanceof SubComponent) {
            return true;
        }
        return ModelUtil.belongsToSubComponent(item.eContainer());
    }

    public static boolean belongsToVariableInterface(EObject item) {
        if (item == null) {
            return false;
        }
        if (item instanceof Variable || item.eContainer() instanceof Variable) {
            return true;
        }
        return ModelUtil.belongsToVariableInterface(item.eContainer());
    }
}

