/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.chess.service.gui.utils;

import eu.fbk.eclipse.standardtools.utils.ui.utils.DirectoryUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class DialogUtils {
    private DirectoryUtil directoryUtils = DirectoryUtil.getInstance();
    private static DialogUtils exportDialogUtils;

    public static DialogUtils getInstance() {
        if (exportDialogUtils == null) {
            exportDialogUtils = new DialogUtils();
        }
        return exportDialogUtils;
    }

    public String getDirectoryNameFromDialog() throws Exception {
        return this.getDirectoryNameFromDialog("Select the directory");
    }

    public String getDirectoryNameFromDialog(String title) throws Exception {
        return this.getDirectoryNameFromDialog(title, this.directoryUtils.getCurrentProjectDir());
    }

    public String getDirectoryNameFromDialog(String title, String path) throws Exception {
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        DirectoryDialog directoryDialog = new DirectoryDialog(shell);
        directoryDialog.setText(title);
        directoryDialog.setFilterPath(path);
        String directoryName = directoryDialog.open();
        return directoryName;
    }

    public String getFileNameFromDialog() throws Exception {
        return this.getFileNameFromDialog("Select the file", null);
    }

    public String getFileNameFromDialog(String title, String filterExtension) throws Exception {
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        FileDialog fileDialog = new FileDialog(shell);
        fileDialog.setText(title);
        fileDialog.setFilterPath(this.directoryUtils.getCurrentProjectDir());
        if (filterExtension != null) {
            String[] extensions = new String[]{filterExtension};
            fileDialog.setFilterExtensions(extensions);
        }
        String directoryName = fileDialog.open();
        return directoryName;
    }

    public List<String> getFileNamesFromDialog(String title, String filterExtension) throws Exception {
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        FileDialog fileDialog = new FileDialog(shell, 2);
        ArrayList<String> files = new ArrayList<String>();
        fileDialog.setText(title);
        fileDialog.setFilterPath(this.directoryUtils.getCurrentProjectDir());
        if (filterExtension != null) {
            String[] extensions = new String[]{filterExtension};
            fileDialog.setFilterExtensions(extensions);
        }
        if (fileDialog.open() != null) {
            String[] names = fileDialog.getFileNames();
            int i = 0;
            int n = names.length;
            while (i < n) {
                StringBuffer buf = new StringBuffer(fileDialog.getFilterPath());
                if (buf.charAt(buf.length() - 1) != File.separatorChar) {
                    buf.append(File.separatorChar);
                }
                buf.append(names[i]);
                files.add(buf.toString());
                ++i;
            }
        }
        return files;
    }
}

