/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.eclipse.standardtools.xtextService.core.utils;

import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.validation.CheckMode;
import org.eclipse.xtext.validation.IResourceValidator;
import org.eclipse.xtext.validation.Issue;

public class XTextValidation {
    static XTextValidation xTextUtilInstance;
    private static final Logger logger;

    static {
        logger = Logger.getLogger(XTextValidation.class);
    }

    public static XTextValidation getInstance() {
        if (xTextUtilInstance == null) {
            xTextUtilInstance = new XTextValidation();
        }
        return xTextUtilInstance;
    }

    public List<Diagnostic> emfValidation(XtextResource xTextResource) {
        if (xTextResource.getContents().size() == 0) {
            return null;
        }
        return this.emfValidation((EObject)xTextResource.getContents().get(0));
    }

    public List<Diagnostic> emfValidation(EObject xtextElement) {
        Diagnostic diagnostic = Diagnostician.INSTANCE.validate(xtextElement);
        if (diagnostic.getChildren().size() > 0) {
            return diagnostic.getChildren();
        }
        return null;
    }

    public List<Issue> xTextValidation(XtextResource xTextResource) {
        IResourceValidator validator = xTextResource.getResourceServiceProvider().getResourceValidator();
        List issues = validator.validate((Resource)xTextResource, CheckMode.ALL, null);
        for (Issue issue : issues) {
            logger.debug((Object)("issue: " + issue));
        }
        return issues;
    }

    public String[] convertXtextErrorsAsStrings(XtextResource xTextRes) {
        List<Issue> issues = this.xTextValidation(xTextRes);
        String[] errors = new String[issues.size()];
        int i = 0;
        for (Issue issue : issues) {
            errors[i] = issue.getMessage();
            ++i;
        }
        return errors;
    }

    public String[] convertEmfDiagnosticErrorsAsStrings(List<Diagnostic> diagnostics) {
        String[] errors = null;
        if (diagnostics != null && diagnostics.size() > 0) {
            errors = new String[diagnostics.size()];
            int i = 0;
            for (Diagnostic d : diagnostics) {
                errors[i] = d.getMessage();
                ++i;
            }
        }
        return errors;
    }
}

