/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.eclipse.standardtools.xtextService.ui.utils;

import eu.fbk.eclipse.standardtools.xtextService.ui.type.Parameter;
import eu.fbk.eclipse.standardtools.xtextService.ui.type.Port;
import eu.fbk.eclipse.standardtools.xtextService.ui.utils.XtextErrorUtil;
import eu.fbk.tools.editor.contract.expression.validation.DefineProposalProvider;
import eu.fbk.tools.editor.contract.expression.validation.EnumValueProposalProvider;
import eu.fbk.tools.editor.contract.expression.validation.ExpressionValidator;
import eu.fbk.tools.editor.contract.expression.validation.ParameterProposalProvider;
import eu.fbk.tools.editor.contract.expression.validation.PortProposalProvider;
import eu.fbk.tools.editor.contract.expression.validation.ValidatorUtil;
import java.io.IOException;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.XtextSourceViewer;

public abstract class XTextEditorViewer {
    private XtextSourceViewer editorViewer;
    private static final Logger logger = Logger.getLogger(XTextEditorViewer.class);
    private static final int COLOR_NOT_EDITABLE_EDITOR = 22;
    private static final int COLOR_EDITABLE_EDITOR = 20;

    public XTextEditorViewer(Composite composite, int numCols) {
        Composite xTextEditorComposite = this.createCompositeEditor(composite, numCols);
        this.editorViewer = this.applyXTextLanguageToEditor(xTextEditorComposite);
    }

    public abstract XtextSourceViewer applyXTextLanguageToEditor(Composite var1);

    public abstract XtextResource createXTextResource(String var1) throws IOException;

    private Composite createCompositeEditor(Composite composite, int numCols) {
        GridData gd = new GridData(4, 4, true, true);
        gd.horizontalSpan = numCols;
        Composite compositeEditor = new Composite(composite, 2048);
        GridLayout compositeLayout = new GridLayout();
        compositeEditor.setLayout((Layout)compositeLayout);
        compositeEditor.setLayoutData((Object)gd);
        return compositeEditor;
    }

    public void setEditorText(String editorText) {
        if (editorText != null) {
            this.setEditorText(this.editorViewer, editorText);
        } else {
            this.cleanEditor();
        }
    }

    public void cleanEditor() {
        this.cleanEditor(this.editorViewer);
    }

    public void assignPostTextChangedListener(ISelectionChangedListener editorListener) {
        this.editorViewer.addPostSelectionChangedListener(editorListener);
    }

    public String getEditorText() {
        return this.editorViewer.getDocument().get();
    }

    public boolean isEditorEditable() {
        return this.editorViewer.isEditable();
    }

    public static void cleanPorts() {
        PortProposalProvider.getInstance().clearPorts();
    }

    public static void addPorts(EList<Port> ports) {
        if (ports != null) {
            for (Port port : ports) {
                PortProposalProvider.PortInfo portInfo = new PortProposalProvider.PortInfo(port.getDirection(), port.getType());
                PortProposalProvider.getInstance().addPort(port.getPortName(), portInfo);
            }
        }
    }

    public static void addEnumValues(String[] enumValues) {
        if (enumValues != null) {
            String[] stringArray = enumValues;
            int n = enumValues.length;
            int n2 = 0;
            while (n2 < n) {
                String value = stringArray[n2];
                EnumValueProposalProvider.getInstance().add(value);
                ++n2;
            }
        }
    }

    public static void addDefines(String[] defines) {
        if (defines != null) {
            String[] stringArray = defines;
            int n = defines.length;
            int n2 = 0;
            while (n2 < n) {
                String value = stringArray[n2];
                logger.debug((Object)("addDefines: " + value));
                DefineProposalProvider.getInstance().add(value);
                ++n2;
            }
        }
    }

    public static void cleanEnumValues() {
        EnumValueProposalProvider.getInstance().clear();
    }

    public static void cleanParameters() {
        ParameterProposalProvider.getInstance().clearParameters();
    }

    public static void cleanDefines() {
        DefineProposalProvider.getInstance().clear();
    }

    public static void addParameters(EList<Parameter> attributes) {
        if (attributes != null) {
            for (Parameter attribute : attributes) {
                ParameterProposalProvider.ParameterInfo parameterInfo = new ParameterProposalProvider.ParameterInfo(attribute.getOutType(), attribute.getInTypes());
                ParameterProposalProvider.getInstance().addParameter(attribute.getParameterName(), parameterInfo);
            }
        }
    }

    public void showRuntimeErrors(String editorText, Object constraint, Resource resource) throws IOException {
        XtextResource xTextResource = this.createXTextResource(editorText);
        XtextErrorUtil.getInstance().emfValidation(resource, constraint, xTextResource);
    }

    private void cleanEditor(XtextSourceViewer editorViewer) {
        this.setEditor(editorViewer, "", false, 22);
    }

    private void setEditorText(XtextSourceViewer editorViewer, String text) {
        this.setEditor(editorViewer, text, true, 20);
    }

    private void setEditor(XtextSourceViewer editorViewer, String text, boolean isEditable, int color) {
        if (editorViewer != null) {
            editorViewer.getDocument().set(text);
            editorViewer.setEditable(isEditable);
            this.setEditorColor(editorViewer, color);
        }
    }

    private void setEditorColor(XtextSourceViewer editorViewer, int color) {
        Display display = Display.getCurrent();
        Color c = display.getSystemColor(color);
        Canvas t = (Canvas)editorViewer.getControl();
        t.setBackgroundMode(2);
        t.setBackground(c);
    }

    public static void setBooleanCheck(boolean booleanCheck) {
        ExpressionValidator.predicate = booleanCheck;
    }

    public static void enableCheckOnVariables() {
        ValidatorUtil.enableDeclaredVariableCheck();
    }

    public static void disableCheckOnVariables() {
        ValidatorUtil.disableDeclaredVariableCheck();
    }
}

