/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.eclipse.standardtools.xtextService.ui.utils;

import eu.fbk.eclipse.standardtools.utils.core.exceptions.NoIFileFoundException;
import eu.fbk.eclipse.standardtools.utils.core.utils.FileSystemUtil;
import eu.fbk.eclipse.standardtools.utils.ui.utils.DirectoryUtil;
import eu.fbk.eclipse.standardtools.utils.ui.utils.ErrorsDialogUtil;
import eu.fbk.eclipse.standardtools.xtextService.core.utils.XTextResourceUtil;
import eu.fbk.eclipse.standardtools.xtextService.core.utils.XTextValidation;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.ui.action.ValidateAction;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.MarkerTypes;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.validation.CheckType;
import org.eclipse.xtext.validation.Issue;

public class XtextErrorUtil {
    private static final Logger logger = Logger.getLogger(XtextErrorUtil.class);
    private static XtextErrorUtil xtextErrorUtil;
    private XTextValidation xtextValidation = XTextValidation.getInstance();
    private ErrorsDialogUtil errorsDialogUtil = ErrorsDialogUtil.getInstance();
    private XTextResourceUtil xTextResourceUtil = XTextResourceUtil.getInstance();
    private ValidateAction.EclipseResourcesUtil eclipseResourcesUtil = new ValidateAction.EclipseResourcesUtil();

    public static XtextErrorUtil getInstance() {
        if (xtextErrorUtil == null) {
            xtextErrorUtil = new XtextErrorUtil();
        }
        return xtextErrorUtil;
    }

    public boolean xTextValidationOSS(File ossFile, Resource resource, boolean usexTextValidation, boolean showNoErrorPopup, IProgressMonitor monitor) throws Exception {
        XtextResource xTextResource = this.xTextResourceUtil.createOSSResourceFromFile(ossFile.getPath());
        return this.xTextValidation(xTextResource, ossFile, resource, usexTextValidation, showNoErrorPopup, monitor);
    }

    public boolean xTextValidationSMV(File smvFile, Resource resource, boolean usexTextValidation, boolean showNoErrorPopup, IProgressMonitor monitor) throws Exception {
        XtextResource xTextResource = this.xTextResourceUtil.createNuXmvResourceFromFile(smvFile.getPath());
        return this.xTextValidation(xTextResource, smvFile, resource, usexTextValidation, showNoErrorPopup, monitor);
    }

    private boolean xTextValidation(XtextResource xTextResource, File file, Resource resource, boolean usexTextValidation, boolean showNoErrorPopup, IProgressMonitor monitor) throws Exception {
        monitor.subTask("XText Validation");
        boolean isValid = false;
        isValid = usexTextValidation ? this.xTextValidation(xTextResource, file, resource, showNoErrorPopup) : this.emfValidation(xTextResource, file.getName(), resource, showNoErrorPopup);
        monitor.worked(1);
        return isValid;
    }

    private boolean emfValidation(XtextResource xTextResource, String fileName, Resource resource, boolean showNoErrorPopup) {
        List<Diagnostic> diagnostics = this.xtextValidation.emfValidation(xTextResource);
        if (diagnostics != null && !diagnostics.isEmpty()) {
            String[] emfErrors = this.xtextValidation.convertEmfDiagnosticErrorsAsStrings(diagnostics);
            this.errorsDialogUtil.showMessage_RuntimeErrors(fileName, emfErrors, showNoErrorPopup);
            this.createEmfDiagnosticMarkers(resource, diagnostics);
            return false;
        }
        if (showNoErrorPopup) {
            this.errorsDialogUtil.showMessage_NoErrors(fileName);
        }
        return true;
    }

    private boolean xTextValidation(XtextResource xTextResource, File file, Resource resource, boolean showNoErrorPopup) throws Exception {
        List<Issue> issues = this.xtextValidation.xTextValidation(xTextResource);
        if (issues != null && !issues.isEmpty()) {
            String[] xTextErrors = this.xtextValidation.convertXtextErrorsAsStrings(xTextResource);
            this.errorsDialogUtil.showMessage_RuntimeErrors(file.getName(), xTextErrors, showNoErrorPopup);
            IProject project = DirectoryUtil.getInstance().getCurrentProject();
            this.createEmfDiagnosticMarkers(issues, FileSystemUtil.convert((File)file, (IProject)project), resource);
            return false;
        }
        if (showNoErrorPopup) {
            this.errorsDialogUtil.showMessage_NoErrors(file.getName());
        }
        return true;
    }

    public void emfValidation(Resource resource, Object object, XtextResource xTextResource) throws IOException {
        List<Diagnostic> diagnostics = this.xtextValidation.emfValidation(xTextResource);
        this.createEmfDiagnosticMarkers(diagnostics, object, resource);
    }

    private void createEmfDiagnosticMarkers(List<Diagnostic> diagnostics, Object object, Resource resource) throws IOException {
        logger.debug((Object)("Resource: " + resource));
        logger.debug((Object)("DIAGNOSTICS: " + diagnostics));
        this.eclipseResourcesUtil.deleteMarkers((Object)resource);
        if (diagnostics != null && diagnostics.size() > 0) {
            for (Diagnostic d : diagnostics) {
                logger.debug((Object)("DIAGNOSTIC: " + d));
                logger.debug((Object)(" source : " + d.getSource()));
                BasicDiagnostic newD = new BasicDiagnostic(d.getSeverity(), d.getSource(), d.getCode(), d.getMessage(), new Object[]{object});
                logger.debug((Object)("new DIAGNOSTIC: " + newD));
                this.eclipseResourcesUtil.createMarkers(resource, (Diagnostic)newD);
            }
        }
    }

    private void createEmfDiagnosticMarkers(List<Issue> issues, IFile file, Resource resource) throws IOException, CoreException, NoIFileFoundException {
        if (file == null) {
            throw new NoIFileFoundException();
        }
        logger.debug((Object)("Resource: " + resource));
        logger.debug((Object)("issues: " + issues));
        this.eclipseResourcesUtil.deleteMarkers((Object)file);
        if (issues.size() > 0) {
            for (Issue issue : issues) {
                this.createMarker(issue, file, resource, MarkerTypes.forCheckType((CheckType)issue.getType()));
            }
        }
    }

    private void createMarker(Issue issue, IFile file, Resource resource, String markerType) throws CoreException {
        IMarker marker = file.createMarker(markerType);
        this.setMarkerAttributes(issue, resource, marker);
    }

    private void setMarkerAttributes(Issue issue, Resource resource, IMarker marker) throws CoreException {
        String lineNR = "";
        if (issue.getLineNumber() != null) {
            lineNR = "line: " + issue.getLineNumber() + " ";
        }
        marker.setAttribute("location", (Object)(String.valueOf(lineNR) + resource.getURI().toString()));
        marker.setAttribute("CODE_KEY", (Object)issue.getCode());
        marker.setAttribute("severity", this.getSeverity(issue));
        marker.setAttribute("charStart", (Object)issue.getOffset());
        if (issue.getOffset() != null && issue.getLength() != null) {
            marker.setAttribute("charEnd", issue.getOffset() + issue.getLength());
        }
        marker.setAttribute("lineNumber", (Object)issue.getLineNumber());
        marker.setAttribute("COLUMN_KEY", (Object)issue.getColumn());
        marker.setAttribute("message", (Object)issue.getMessage());
        if (issue.getUriToProblem() != null) {
            marker.setAttribute("URI_KEY", (Object)issue.getUriToProblem().toString());
        }
        if (issue.getData() != null && issue.getData().length > 0) {
            marker.setAttribute("DATA_KEY", (Object)Strings.pack((String[])issue.getData()));
        }
    }

    private Object getSeverity(Issue issue) {
        switch (issue.getSeverity()) {
            case ERROR: {
                return 2;
            }
            case WARNING: {
                return 1;
            }
            case INFO: {
                return 0;
            }
        }
        throw new IllegalArgumentException(String.valueOf(issue.getSeverity()));
    }

    private void createEmfDiagnosticMarkers(Resource resource, List<Diagnostic> diagnostics) {
        this.eclipseResourcesUtil.deleteMarkers((Object)resource);
        if (diagnostics != null) {
            for (Diagnostic d : diagnostics) {
                logger.debug((Object)("DIAGNOSTIC: " + d));
                this.eclipseResourcesUtil.createMarkers(resource, d);
            }
        }
    }
}

