/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.chess.fla.flamm;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.EObjectResolvingEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.polarsys.chess.fla.flamm.Component;
import org.polarsys.chess.fla.flamm.Connection;
import org.polarsys.chess.fla.flamm.Failure;
import org.polarsys.chess.fla.flamm.FlammPackage;
import org.polarsys.chess.fla.flamm.NamedElement;

public class Port
extends NamedElement {
    protected EList<Port> connectedPorts;
    protected EList<Failure> failures;
    protected EList<Failure> newFailures;
    protected Component owner;
    protected Connection incomingConnections;
    protected Connection outgoingConnections;

    public Port() {
    }

    public Port(String name, String id, Component owner) {
        this.setName(name);
        this.setId(id);
        this.setOwner(owner);
    }

    @Override
    protected EClass eStaticClass() {
        return FlammPackage.Literals.PORT;
    }

    public List<Port> getConnectedPorts() {
        if (this.connectedPorts == null) {
            this.connectedPorts = new EObjectResolvingEList(Port.class, (InternalEObject)this, 2);
        }
        return this.connectedPorts;
    }

    public List<Failure> getFailures() {
        if (this.failures == null) {
            this.failures = new EObjectContainmentEList(Failure.class, (InternalEObject)this, 3);
        }
        return this.failures;
    }

    public List<Failure> getNewFailures() {
        if (this.newFailures == null) {
            this.newFailures = new EObjectContainmentEList(Failure.class, (InternalEObject)this, 4);
        }
        return this.newFailures;
    }

    public Component getOwner() {
        if (this.owner != null && this.owner.eIsProxy()) {
            Component oldOwner = this.owner;
            this.owner = (Component)this.eResolveProxy((InternalEObject)oldOwner);
            if (this.owner != oldOwner && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 5, (Object)oldOwner, (Object)this.owner));
            }
        }
        return this.owner;
    }

    public Component basicGetOwner() {
        return this.owner;
    }

    public void setOwner(Component newOwner) {
        Component oldOwner = this.owner;
        this.owner = newOwner;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 5, (Object)oldOwner, (Object)this.owner));
        }
    }

    public Connection getIncomingConnections() {
        if (this.incomingConnections != null && this.incomingConnections.eIsProxy()) {
            Connection oldIncomingConnections = this.incomingConnections;
            this.incomingConnections = (Connection)this.eResolveProxy((InternalEObject)oldIncomingConnections);
            if (this.incomingConnections != oldIncomingConnections && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 6, (Object)oldIncomingConnections, (Object)this.incomingConnections));
            }
        }
        return this.incomingConnections;
    }

    public Connection basicGetIncomingConnections() {
        return this.incomingConnections;
    }

    public NotificationChain basicSetIncomingConnections(Connection newIncomingConnections, NotificationChain msgs) {
        Connection oldIncomingConnections = this.incomingConnections;
        this.incomingConnections = newIncomingConnections;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 6, (Object)oldIncomingConnections, (Object)newIncomingConnections);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    public void setIncomingConnections(Connection newIncomingConnections) {
        if (newIncomingConnections != this.incomingConnections) {
            NotificationChain msgs = null;
            if (this.incomingConnections != null) {
                msgs = this.incomingConnections.eInverseRemove((InternalEObject)this, 1, Connection.class, msgs);
            }
            if (newIncomingConnections != null) {
                msgs = newIncomingConnections.eInverseAdd((InternalEObject)this, 1, Connection.class, msgs);
            }
            if ((msgs = this.basicSetIncomingConnections(newIncomingConnections, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 6, (Object)newIncomingConnections, (Object)newIncomingConnections));
        }
    }

    public Connection getOutgoingConnections() {
        if (this.outgoingConnections != null && this.outgoingConnections.eIsProxy()) {
            Connection oldOutgoingConnections = this.outgoingConnections;
            this.outgoingConnections = (Connection)this.eResolveProxy((InternalEObject)oldOutgoingConnections);
            if (this.outgoingConnections != oldOutgoingConnections && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 7, (Object)oldOutgoingConnections, (Object)this.outgoingConnections));
            }
        }
        return this.outgoingConnections;
    }

    public Connection basicGetOutgoingConnections() {
        return this.outgoingConnections;
    }

    public NotificationChain basicSetOutgoingConnections(Connection newOutgoingConnections, NotificationChain msgs) {
        Connection oldOutgoingConnections = this.outgoingConnections;
        this.outgoingConnections = newOutgoingConnections;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 7, (Object)oldOutgoingConnections, (Object)newOutgoingConnections);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    public void setOutgoingConnections(Connection newOutgoingConnections) {
        if (newOutgoingConnections != this.outgoingConnections) {
            NotificationChain msgs = null;
            if (this.outgoingConnections != null) {
                msgs = this.outgoingConnections.eInverseRemove((InternalEObject)this, 0, Connection.class, msgs);
            }
            if (newOutgoingConnections != null) {
                msgs = newOutgoingConnections.eInverseAdd((InternalEObject)this, 0, Connection.class, msgs);
            }
            if ((msgs = this.basicSetOutgoingConnections(newOutgoingConnections, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 7, (Object)newOutgoingConnections, (Object)newOutgoingConnections));
        }
    }

    public boolean hasNewFailures() {
        return !this.getNewFailures().isEmpty();
    }

    public void propagateFailures() {
        throw new UnsupportedOperationException();
    }

    public void clearNewFailures() {
        this.getFailures().addAll(this.getNewFailures());
        this.getNewFailures().clear();
    }

    public void initialize() {
        this.getFailures().clear();
        this.getNewFailures().clear();
    }

    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 6: {
                if (this.incomingConnections != null) {
                    msgs = this.incomingConnections.eInverseRemove((InternalEObject)this, 1, Connection.class, msgs);
                }
                return this.basicSetIncomingConnections((Connection)otherEnd, msgs);
            }
            case 7: {
                if (this.outgoingConnections != null) {
                    msgs = this.outgoingConnections.eInverseRemove((InternalEObject)this, 0, Connection.class, msgs);
                }
                return this.basicSetOutgoingConnections((Connection)otherEnd, msgs);
            }
        }
        return super.eInverseAdd(otherEnd, featureID, msgs);
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 3: {
                return ((InternalEList)this.getFailures()).basicRemove((Object)otherEnd, msgs);
            }
            case 4: {
                return ((InternalEList)this.getNewFailures()).basicRemove((Object)otherEnd, msgs);
            }
            case 6: {
                return this.basicSetIncomingConnections(null, msgs);
            }
            case 7: {
                return this.basicSetOutgoingConnections(null, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public boolean addFailure(Failure failure) {
        if (Failure.doCollectionContainFailure(this.getFailures(), failure) || Failure.doCollectionContainFailure(this.getNewFailures(), failure)) {
            return false;
        }
        return this.getNewFailures().add(new Failure(failure));
    }

    public boolean addFailure(Failure failure, Failure previousFailure) {
        if (Failure.doCollectionContainFailure(this.getFailures(), failure)) {
            Failure existingFailure = Failure.getFailureInCollection(this.getFailures(), failure);
            existingFailure.addPreviousFailure(previousFailure);
            return false;
        }
        if (Failure.doCollectionContainFailure(this.getNewFailures(), failure)) {
            Failure existingFailure = Failure.getFailureInCollection(this.getNewFailures(), failure);
            existingFailure.addPreviousFailure(previousFailure);
            return false;
        }
        return this.getNewFailures().add(new Failure(failure, previousFailure));
    }

    public boolean addFailure(Failure failure, Collection<Failure> previousFailures) {
        if (Failure.doCollectionContainFailure(this.getFailures(), failure)) {
            Failure existingFailure = Failure.getFailureInCollection(this.getFailures(), failure);
            existingFailure.addPreviousFailures(previousFailures);
            return false;
        }
        if (Failure.doCollectionContainFailure(this.getNewFailures(), failure)) {
            Failure existingFailure = Failure.getFailureInCollection(this.getNewFailures(), failure);
            existingFailure.addPreviousFailures(previousFailures);
            return false;
        }
        return this.getNewFailures().add(new Failure(failure, previousFailures));
    }

    public boolean addFailures(Collection<Failure> failures) {
        boolean hasFailureBeenAdded = false;
        for (Failure failure : failures) {
            if (!this.addFailure(failure)) continue;
            hasFailureBeenAdded = true;
        }
        return hasFailureBeenAdded;
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 2: {
                return this.getConnectedPorts();
            }
            case 3: {
                return this.getFailures();
            }
            case 4: {
                return this.getNewFailures();
            }
            case 5: {
                if (resolve) {
                    return this.getOwner();
                }
                return this.basicGetOwner();
            }
            case 6: {
                if (resolve) {
                    return this.getIncomingConnections();
                }
                return this.basicGetIncomingConnections();
            }
            case 7: {
                if (resolve) {
                    return this.getOutgoingConnections();
                }
                return this.basicGetOutgoingConnections();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 2: {
                this.getConnectedPorts().clear();
                this.getConnectedPorts().addAll((Collection)newValue);
                return;
            }
            case 3: {
                this.getFailures().clear();
                this.getFailures().addAll((Collection)newValue);
                return;
            }
            case 4: {
                this.getNewFailures().clear();
                this.getNewFailures().addAll((Collection)newValue);
                return;
            }
            case 5: {
                this.setOwner((Component)newValue);
                return;
            }
            case 6: {
                this.setIncomingConnections((Connection)newValue);
                return;
            }
            case 7: {
                this.setOutgoingConnections((Connection)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 2: {
                this.getConnectedPorts().clear();
                return;
            }
            case 3: {
                this.getFailures().clear();
                return;
            }
            case 4: {
                this.getNewFailures().clear();
                return;
            }
            case 5: {
                this.setOwner(null);
                return;
            }
            case 6: {
                this.setIncomingConnections(null);
                return;
            }
            case 7: {
                this.setOutgoingConnections(null);
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 2: {
                return this.connectedPorts != null && !this.connectedPorts.isEmpty();
            }
            case 3: {
                return this.failures != null && !this.failures.isEmpty();
            }
            case 4: {
                return this.newFailures != null && !this.newFailures.isEmpty();
            }
            case 5: {
                return this.owner != null;
            }
            case 6: {
                return this.incomingConnections != null;
            }
            case 7: {
                return this.outgoingConnections != null;
            }
        }
        return super.eIsSet(featureID);
    }

    public Object eInvoke(int operationID, EList<?> arguments) throws InvocationTargetException {
        switch (operationID) {
            case 0: {
                this.propagateFailures();
                return null;
            }
            case 1: {
                this.initialize();
                return null;
            }
        }
        return super.eInvoke(operationID, arguments);
    }
}

