/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.chess.fla.flamm;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.MinimalEObjectImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.polarsys.chess.fla.flamm.Expression;
import org.polarsys.chess.fla.flamm.Failure;
import org.polarsys.chess.fla.flamm.FailureTypes.FailureType;
import org.polarsys.chess.fla.flamm.FlammPackage;
import org.polarsys.chess.fla.flamm.Port;
import org.polarsys.chess.fla.flamm.PortFailureTuple;
import org.polarsys.chess.fla.flamm.analysis.FlaSystem;

public class Rule
extends MinimalEObjectImpl.Container
implements EObject {
    protected EList<Expression> inputExpression;
    protected EList<Expression> outputExpression;
    private transient Map<String, Failure> variableAssignments = new HashMap<String, Failure>();
    protected static final int SPECIFICITY_EDEFAULT = -1;
    protected int specificity = -1;

    protected EClass eStaticClass() {
        return FlammPackage.Literals.RULE;
    }

    public List<Expression> getInputExpression() {
        if (this.inputExpression == null) {
            this.inputExpression = new EObjectContainmentEList(Expression.class, (InternalEObject)this, 0);
        }
        return this.inputExpression;
    }

    public List<Expression> getOutputExpression() {
        if (this.outputExpression == null) {
            this.outputExpression = new EObjectContainmentEList(Expression.class, (InternalEObject)this, 1);
        }
        return this.outputExpression;
    }

    public int getSpecificity() {
        if (this.specificity == -1) {
            this.calculateSpecificity();
        }
        return this.specificity;
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 0: {
                return ((InternalEList)this.getInputExpression()).basicRemove((Object)otherEnd, msgs);
            }
            case 1: {
                return ((InternalEList)this.getOutputExpression()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    protected void calculateSpecificity() {
        int calculatedSpecificity = 0;
        for (Expression inputExpression : this.inputExpression) {
            if (this.expressionContainsVariableOrWildcard(inputExpression)) continue;
            ++calculatedSpecificity;
        }
        this.specificity = calculatedSpecificity;
    }

    private boolean expressionContainsVariableOrWildcard(Expression expression) {
        for (Failure failure : expression.getFailures()) {
            if (FailureType.WILDCARD != failure.getType() && FailureType.VARIABLE != failure.getType()) continue;
            return true;
        }
        return false;
    }

    public boolean matchFailure(List<PortFailureTuple> failuresetToMatch) {
        this.variableAssignments.clear();
        for (PortFailureTuple failureTupleToMatch : failuresetToMatch) {
            Expression portInputExpression = this.getInputExpressionForPort(failureTupleToMatch.getPort());
            if (portInputExpression == null || portInputExpression.getFailures().isEmpty()) {
                if (FlaSystem.treatUnmentionedPortsAsWildcards()) continue;
                return false;
            }
            List<Failure> rulePortFailures = portInputExpression.getFailures();
            boolean match = false;
            for (Failure ruleFailure : rulePortFailures) {
                if (ruleFailure.getType() == FailureType.WILDCARD) {
                    match = true;
                    break;
                }
                if (ruleFailure.getType() == FailureType.VARIABLE) {
                    Failure prevVariableAssignment = this.variableAssignments.get(ruleFailure.getId());
                    if (prevVariableAssignment != null && !prevVariableAssignment.isSameFailure(failureTupleToMatch.getFailure())) continue;
                    this.variableAssignments.put(ruleFailure.getId(), failureTupleToMatch.getFailure());
                    match = true;
                    break;
                }
                if (!ruleFailure.isSameFailure(failureTupleToMatch.getFailure())) continue;
                match = true;
                break;
            }
            if (match) continue;
            return false;
        }
        return true;
    }

    protected Expression getInputExpressionForPort(Port port) {
        return this.getExpressionForPort((List<Expression>)this.inputExpression, port);
    }

    protected Expression getOutputExpressionForPort(Port port) {
        return this.getExpressionForPort((List<Expression>)this.outputExpression, port);
    }

    private Expression getExpressionForPort(List<Expression> expressions, Port port) {
        if (port != null) {
            for (Expression expression : expressions) {
                if (!((Object)((Object)port)).equals((Object)expression.getPort())) continue;
                return expression;
            }
        }
        return null;
    }

    public void fire() {
        for (Expression expression : this.getOutputExpression()) {
            Port port = expression.getPort();
            for (Failure failure : expression.getFailures()) {
                if (failure.getType() == FailureType.VARIABLE) {
                    port.addFailure(this.variableAssignments.get(failure.getId()));
                    continue;
                }
                port.addFailure(failure);
            }
        }
    }

    public void fire(Collection<Failure> previousFailures) {
        for (Expression expression : this.getOutputExpression()) {
            Port port = expression.getPort();
            for (Failure failure : expression.getFailures()) {
                if (failure.getType() == FailureType.VARIABLE) {
                    port.addFailure(this.variableAssignments.get(failure.getId()), previousFailures);
                    continue;
                }
                port.addFailure(failure, previousFailures);
            }
        }
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.getInputExpression();
            }
            case 1: {
                return this.getOutputExpression();
            }
            case 2: {
                return this.getSpecificity();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 0: {
                this.getInputExpression().clear();
                this.getInputExpression().addAll((Collection)newValue);
                return;
            }
            case 1: {
                this.getOutputExpression().clear();
                this.getOutputExpression().addAll((Collection)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 0: {
                this.getInputExpression().clear();
                return;
            }
            case 1: {
                this.getOutputExpression().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return this.inputExpression != null && !this.inputExpression.isEmpty();
            }
            case 1: {
                return this.outputExpression != null && !this.outputExpression.isEmpty();
            }
            case 2: {
                return this.specificity != -1;
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (specificity: ");
        result.append(this.specificity);
        result.append(')');
        return result.toString();
    }
}

