/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.extensionpoints.editors.definition;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.extensionpoints.editors.Activator;
import org.eclipse.papyrus.extensionpoints.editors.configuration.DefaultDirectEditorConfiguration;
import org.eclipse.papyrus.extensionpoints.editors.configuration.IAdvancedEditorConfiguration;
import org.eclipse.papyrus.extensionpoints.editors.configuration.IDirectEditorConfiguration;
import org.eclipse.papyrus.extensionpoints.editors.configuration.IDirectEditorConstraint;
import org.eclipse.papyrus.extensionpoints.editors.definition.DirectEditorRegistry;
import org.eclipse.papyrus.extensionpoints.editors.definition.IDirectEditorExtensionPoint;
import org.eclipse.papyrus.extensionpoints.editors.utils.DirectEditorsUtil;
import org.eclipse.papyrus.infra.constraints.constraints.JavaQuery;
import org.eclipse.swt.graphics.Image;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectEditorExtensionPoint
implements IDirectEditorExtensionPoint {
    private static IDirectEditorExtensionPoint[] configurations;
    private static DirectEditorRegistry directEditorProvider;
    private String language;
    private boolean superType;
    private IDirectEditorConfiguration directEditorConfiguration;
    private Class<? extends EObject> objectClassToEdit;
    private Integer extensionPriority;
    private IDirectEditorConstraint constraint;

    public static IDirectEditorExtensionPoint[] getDirectEditorConfigurations() {
        IConfigurationElement[] configElements;
        if (configurations != null) {
            return configurations;
        }
        ArrayList<DirectEditorExtensionPoint> directEditorExtensionPoints = new ArrayList<DirectEditorExtensionPoint>();
        IConfigurationElement[] iConfigurationElementArray = configElements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.papyrus.extensionpoints.editors.DirectEditor");
        int n = configElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement configElement = iConfigurationElementArray[n2];
            try {
                DirectEditorExtensionPoint proxy = DirectEditorExtensionPoint.parseDirectEditorConfiguration(configElement);
                if (proxy != null) {
                    directEditorExtensionPoints.add(proxy);
                }
            }
            catch (Throwable ex) {
                Activator.log.error(ex);
            }
            ++n2;
        }
        configurations = directEditorExtensionPoints.toArray(new DirectEditorExtensionPoint[directEditorExtensionPoints.size()]);
        directEditorProvider = new DirectEditorRegistry();
        directEditorProvider.init(configurations);
        return configurations;
    }

    public static DirectEditorRegistry getDirectEditorProvider() {
        if (directEditorProvider != null) {
            return directEditorProvider;
        }
        directEditorProvider = new DirectEditorRegistry();
        directEditorProvider.init(DirectEditorExtensionPoint.getDirectEditorConfigurations());
        return directEditorProvider;
    }

    @Deprecated
    public static DirectEditorExtensionPoint getDefautDirectEditorConfiguration(EObject semanticObjectToEdit, Object selectedObject) {
        return (DirectEditorExtensionPoint)DirectEditorsUtil.getDefautDirectEditorConfiguration(semanticObjectToEdit, selectedObject);
    }

    @Deprecated
    public static Collection<DirectEditorExtensionPoint> getDirectEditorConfigurations(EObject semanticObjectToEdit, Object selectedObject) {
        Collection<IDirectEditorExtensionPoint> directEditorConfigurations = DirectEditorsUtil.getDirectEditorConfigurations(semanticObjectToEdit, selectedObject);
        ArrayList<DirectEditorExtensionPoint> returnList = new ArrayList<DirectEditorExtensionPoint>();
        for (IDirectEditorExtensionPoint extension : directEditorConfigurations) {
            if (!(extension instanceof DirectEditorExtensionPoint)) continue;
            returnList.add((DirectEditorExtensionPoint)extension);
        }
        return returnList;
    }

    public static DirectEditorExtensionPoint parseDirectEditorConfiguration(IConfigurationElement configElt) {
        if (!"DirectEditor".equals(configElt.getName())) {
            return null;
        }
        try {
            return new DirectEditorExtensionPoint(configElt);
        }
        catch (Exception e) {
            Activator.log(e);
            return null;
        }
    }

    public DirectEditorExtensionPoint(IConfigurationElement configElt) {
        String attribute = DirectEditorExtensionPoint.getAttribute(configElt, "superType", "false", false);
        this.superType = attribute.equals("true");
        this.language = DirectEditorExtensionPoint.getAttribute(configElt, "language", "undefined", true);
        String objectToEdit = DirectEditorExtensionPoint.getAttribute(configElt, "objectToEdit", EObject.class.getCanonicalName(), true);
        this.directEditorConfiguration = DirectEditorExtensionPoint.getDirectEditorConfigurationClass(configElt);
        this.extensionPriority = DirectEditorExtensionPoint.getPriority(configElt);
        if (this.directEditorConfiguration == null) {
            this.directEditorConfiguration = DirectEditorExtensionPoint.getAdvancedDirectEditorConfigurationClass(configElt);
        }
        if (this.directEditorConfiguration == null) {
            this.directEditorConfiguration = DirectEditorExtensionPoint.getPopupDirectEditorConfigurationClass(configElt);
        }
        this.directEditorConfiguration.setLanguage(this.language);
        this.directEditorConfiguration.setSuperType(this.superType);
        try {
            String pluginID = configElt.getContributor().getName();
            this.objectClassToEdit = Platform.getBundle((String)pluginID).loadClass(objectToEdit).asSubclass(EObject.class);
        }
        catch (ClassNotFoundException e) {
            Activator.log.error((Throwable)e);
        }
        catch (ClassCastException e) {
            Activator.log.error((Throwable)e);
        }
        if (configElt.getAttribute("additionalConstraint") != null) {
            try {
                this.constraint = (IDirectEditorConstraint)configElt.createExecutableExtension("additionalConstraint");
            }
            catch (CoreException ex) {
                Activator.log.error((Throwable)ex);
            }
            catch (ClassCastException ex) {
                Activator.log.error((Throwable)ex);
            }
        }
    }

    protected static IDirectEditorConfiguration getDirectEditorConfigurationClass(IConfigurationElement configElement) {
        IDirectEditorConfiguration configuration = null;
        try {
            Object config;
            if (configElement.getChildren("simpleeditor").length > 0 && (config = configElement.getChildren("simpleeditor")[0].createExecutableExtension("editorConfiguration")) instanceof IDirectEditorConfiguration) {
                configuration = (IDirectEditorConfiguration)config;
            }
        }
        catch (CoreException e) {
            Activator.log((Exception)((Object)e));
            configuration = new DefaultDirectEditorConfiguration();
        }
        return configuration;
    }

    protected static JavaQuery getJavaQueryClass(IConfigurationElement configElement) {
        JavaQuery javaQuery;
        block4: {
            javaQuery = null;
            if (configElement.getAttribute("constraint") != null) break block4;
            return null;
        }
        try {
            Object config = configElement.createExecutableExtension("constraint");
            if (config instanceof JavaQuery) {
                javaQuery = (JavaQuery)config;
            }
        }
        catch (CoreException e) {
            Activator.log((Exception)((Object)e));
        }
        return javaQuery;
    }

    protected static Integer getPriority(IConfigurationElement configElement) {
        try {
            IConfigurationElement[] iConfigurationElementArray = configElement.getChildren("Priority");
            int n = iConfigurationElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement childConfigElement = iConfigurationElementArray[n2];
                String config = DirectEditorExtensionPoint.getAttribute(childConfigElement, "name", null, true);
                if (config.equals("Highest")) {
                    return new Integer(0);
                }
                if (config.equals("High")) {
                    return new Integer(1);
                }
                if (config.equals("Medium")) {
                    return new Integer(2);
                }
                if (config.equals("Low")) {
                    return new Integer(3);
                }
                if (config.equals("Lowest")) {
                    return new Integer(4);
                }
                ++n2;
            }
        }
        catch (Exception e) {
            Activator.log.error((Throwable)e);
        }
        return new Integer(3);
    }

    protected static IAdvancedEditorConfiguration getAdvancedDirectEditorConfigurationClass(IConfigurationElement configElement) {
        IAdvancedEditorConfiguration configuration = null;
        try {
            IConfigurationElement[] iConfigurationElementArray = configElement.getChildren("advancededitor");
            int n = iConfigurationElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement childConfigElement = iConfigurationElementArray[n2];
                String[] stringArray = childConfigElement.getAttributeNames();
                int n3 = stringArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    String attname = stringArray[n4];
                    Activator.log.debug(attname);
                    ++n4;
                }
                Object config = childConfigElement.createExecutableExtension("editorConfiguration");
                if (config instanceof IAdvancedEditorConfiguration) {
                    configuration = (IAdvancedEditorConfiguration)config;
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            Activator.log.error((Throwable)e);
            configuration = null;
        }
        return configuration;
    }

    protected static IDirectEditorConfiguration getPopupDirectEditorConfigurationClass(IConfigurationElement configElement) {
        IDirectEditorConfiguration configuration = null;
        try {
            IConfigurationElement[] iConfigurationElementArray = configElement.getChildren("popupeditor");
            int n = iConfigurationElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement childConfigElement = iConfigurationElementArray[n2];
                String[] stringArray = childConfigElement.getAttributeNames();
                int n3 = stringArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    String attname = stringArray[n4];
                    Activator.log.debug(attname);
                    ++n4;
                }
                Object config = childConfigElement.createExecutableExtension("editorConfiguration");
                if (config instanceof IDirectEditorConfiguration) {
                    configuration = (IDirectEditorConfiguration)config;
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            Activator.log((Exception)((Object)e));
            configuration = null;
        }
        return configuration;
    }

    protected static String getAttribute(IConfigurationElement configElt, String name, String defaultValue, boolean isRequired) {
        String value = configElt.getAttribute(name);
        if (value != null) {
            return value;
        }
        if (defaultValue != null) {
            return defaultValue;
        }
        if (isRequired) {
            throw new IllegalArgumentException("Missing " + name + " attribute");
        }
        return null;
    }

    protected Image getImage(String iconPath, IConfigurationElement configElement) {
        if (iconPath == null) {
            return null;
        }
        IExtension extension = configElement.getDeclaringExtension();
        String extensionPluginId = extension.getContributor().getName();
        return Activator.getImage(extensionPluginId, iconPath);
    }

    @Override
    public String getLanguage() {
        return this.language;
    }

    @Override
    public String getObjectToEdit() {
        return this.objectClassToEdit.getCanonicalName();
    }

    @Override
    public Class<? extends EObject> getObjectClassToEdit() {
        return this.objectClassToEdit;
    }

    @Override
    public IDirectEditorConfiguration getDirectEditorConfiguration() {
        return this.directEditorConfiguration;
    }

    @Override
    public void setDirectEditorConfiguration(IDirectEditorConfiguration directEditorConfiguration) {
        this.directEditorConfiguration = directEditorConfiguration;
    }

    @Override
    public Integer getPriority() {
        int preferencePriority = this.getPreferencePriority();
        return preferencePriority != -1 ? preferencePriority : this.extensionPriority;
    }

    private int getPreferencePriority() {
        int preferencePriority = -1;
        int preference = Activator.getDefault().getPreferenceStore().getInt("papyrus.directeditor." + this.getObjectToEdit() + '.' + this.language);
        if (preference != 0) {
            preferencePriority = preference;
        }
        return preferencePriority;
    }

    @Override
    public void setPriority(Integer priority) {
        this.extensionPriority = priority;
    }

    @Override
    public IDirectEditorConstraint getAdditionalConstraint() {
        return this.constraint;
    }

    @Override
    public Image getIcon() {
        return null;
    }

    @Override
    public boolean isSuperType() {
        return this.superType;
    }
}

