/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.views.modelexplorer.handler;

import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.infra.core.clipboard.PapyrusClipboard;
import org.eclipse.papyrus.views.modelexplorer.handler.AbstractCommandHandler;
import org.eclipse.papyrus.views.modelexplorer.handler.CopyHandler;
import org.eclipse.papyrus.views.modelexplorer.handler.DeleteCommandHandler;

public class CutHandler
extends AbstractCommandHandler {
    @Override
    protected Command getCommand() {
        CompoundCommand cutInModelExplorerCommand = new CompoundCommand("Cut in Model Explorer Command");
        Command copyCommand = CopyHandler.buildCopyCommand(this.getEditingDomain(), this.getSelectedElements());
        cutInModelExplorerCommand.append(copyCommand);
        Command deleteCommand = DeleteCommandHandler.buildDeleteCommand(this.getSelectedElements());
        cutInModelExplorerCommand.append(deleteCommand);
        return cutInModelExplorerCommand;
    }

    @Override
    protected boolean computeEnabled() {
        List<EObject> selectedElements = this.getSelectedElements();
        return CopyHandler.isCopyEnabled(selectedElements) && DeleteCommandHandler.isDeleteEnabled(selectedElements);
    }

    @Override
    public void setEnabled(Object evaluationContext) {
        PapyrusClipboard instance = PapyrusClipboard.getInstance();
        super.setEnabled(evaluationContext);
        PapyrusClipboard.setInstance((PapyrusClipboard)instance);
    }
}

