/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.chess.fla.transformations.utilities;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.m2m.qvt.oml.blackbox.java.Operation;
import org.eclipse.uml2.uml.Comment;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;
import org.polarsys.chess.fla.flamm.Expression;
import org.polarsys.chess.fla.flamm.Failure;
import org.polarsys.chess.fla.flamm.FailureTypes.FailureType;
import org.polarsys.chess.fla.flamm.FlammFactory;
import org.polarsys.chess.fla.flamm.Port;
import org.polarsys.chess.fla.flamm.Rule;
import org.polarsys.chess.fla.flamm.SimpleComponent;

public class UtilitiesLibrary {
    private static final String FLA_PREFIX = "FLA:";
    private static final String FPTC_SPECIFICATION_STEREOTYPE = "CHESS::Dependability::FailurePropagation::FPTCSpecification";

    @Operation(contextual=true)
    public static String aStringMethod(String s) {
        return s.toUpperCase();
    }

    @Operation(contextual=true)
    public static String getXmiId(Element umlElement) {
        Resource resource = umlElement.eResource();
        if (resource != null) {
            String id = resource.getURIFragment((EObject)umlElement);
            return id;
        }
        return UUID.randomUUID().toString();
    }

    @Operation(contextual=true)
    public static Element getElementWithXmiId(Element umlElement, String id) {
        if (id == null || umlElement == null) {
            return null;
        }
        for (Element element : umlElement.getOwnedElements()) {
            Resource resource = umlElement.eResource();
            if (resource == null || !id.equals(resource.getURIFragment((EObject)umlElement))) continue;
            return element;
        }
        return null;
    }

    @Operation(contextual=true)
    public static Rule getRuleFromRulestring(String flaRulestring, SimpleComponent component) {
        String rulestring = flaRulestring;
        if (flaRulestring.startsWith(FLA_PREFIX)) {
            rulestring = flaRulestring.substring(FLA_PREFIX.length());
        }
        String[] expressions = rulestring.split("->");
        Rule rule = FlammFactory.eINSTANCE.createRule();
        rule.getInputExpression().addAll(UtilitiesLibrary.string2Expressions(expressions[0], component.getInputPorts()));
        rule.getOutputExpression().addAll(UtilitiesLibrary.string2Expressions(expressions[1], component.getOutputPorts()));
        try {
            UtilitiesLibrary.validateRuleVariables(rule);
        }
        catch (Exception e) {
            throw new RuntimeException(String.valueOf(e.getMessage()) + " Component: " + component.getId());
        }
        return rule;
    }

    private static void validateRuleVariables(Rule rule) {
        HashSet<String> inputVariables = new HashSet<String>();
        HashSet<String> outputVariables = new HashSet<String>();
        for (Expression expression : rule.getInputExpression()) {
            inputVariables.addAll(UtilitiesLibrary.getAllVariableNames(expression));
        }
        for (Expression expression : rule.getOutputExpression()) {
            outputVariables.addAll(UtilitiesLibrary.getAllVariableNames(expression));
        }
        if (!inputVariables.containsAll(outputVariables)) {
            outputVariables.removeAll(inputVariables);
            throw new RuntimeException("Unknown variable(s) in output expression! (" + outputVariables + ")");
        }
        outputVariables.contains(inputVariables);
    }

    private static Set<String> getAllVariableNames(Expression expression) {
        HashSet<String> variables = new HashSet<String>();
        for (Failure failure : expression.getFailures()) {
            if (failure.getType() != FailureType.VARIABLE) continue;
            variables.add(failure.getId());
        }
        return variables;
    }

    static List<Expression> string2Expressions(String str, List<Port> list) {
        ArrayList<Expression> expressions = new ArrayList<Expression>();
        String[] stringArray = UtilitiesLibrary.splitToExpressions(str);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            expressions.add(UtilitiesLibrary.getExpression(s, list));
            ++n2;
        }
        return expressions;
    }

    private static String[] splitToExpressions(String str) {
        return str.split(",");
    }

    private static Expression getExpression(String s, List<Port> list) {
        String[] parts = s.split("\\.");
        String portName = parts[0];
        String failureString = parts[1];
        Failure failure = UtilitiesLibrary.getFailureFromString(failureString);
        Expression expr = FlammFactory.eINSTANCE.createExpression();
        expr.setPort(UtilitiesLibrary.getPortByName(list, portName));
        expr.getFailures().add(failure);
        return expr;
    }

    static Failure getFailureFromString(String failureString) {
        Failure failure = FlammFactory.eINSTANCE.createFailure();
        if (failureString.equals("noFailure")) {
            failure.setType(FailureType.NO_FAILURE);
        } else if (failureString.equals("wildcard") || failureString.equals("_")) {
            failure.setType(FailureType.WILDCARD);
        } else if (UtilitiesLibrary.isProperFailure(failureString)) {
            failure.setType(FailureType.FAILURE);
        } else {
            failure.setType(FailureType.VARIABLE);
        }
        failure.setId(failureString);
        return failure;
    }

    protected static boolean isProperFailure(String failure) {
        return org.polarsys.chess.chessmlprofile.Dependability.FailurePropagation.FailurePropagationDataTypes.FailureType.get((String)failure) != null;
    }

    private static Port getPortByName(List<Port> list, String portName) {
        portName = portName.trim();
        for (Port port : list) {
            if (!port.getName().equals(portName)) continue;
            return port;
        }
        return null;
    }

    @Operation(contextual=true)
    public static void toRuleExpression(String ruleString, Expression expression) {
        String portId = ruleString.substring(0, ruleString.indexOf(46));
        expression.setPort(UtilitiesLibrary.getPortById(portId));
        expression.getFailures().add(null);
    }

    private static Port getPortById(String portId) {
        return null;
    }

    @Operation(contextual=true)
    public static String rule2String(Rule rule) {
        String result = "";
        result = String.valueOf(result) + UtilitiesLibrary.expressionList2string(rule.getInputExpression());
        result = String.valueOf(result) + "->";
        result = String.valueOf(result) + UtilitiesLibrary.expressionList2string(rule.getOutputExpression());
        return result;
    }

    protected static String expressionList2string(List<Expression> list) {
        String result = "";
        for (Expression expression : list) {
            result = String.valueOf(result) + expression.getPort().getName() + "." + UtilitiesLibrary.failureList2String(expression.getFailures()) + ",";
        }
        if (result.endsWith(",")) {
            result = result.substring(0, result.length() - 1);
        }
        return result;
    }

    protected static String failureList2String(List<Failure> list) {
        if (list == null || list.isEmpty()) {
            return "";
        }
        if (list.size() == 1) {
            return UtilitiesLibrary.failure2string(list.get(0));
        }
        String result = "{";
        int i = 0;
        while (i < list.size()) {
            result = String.valueOf(result) + UtilitiesLibrary.failure2string(list.get(i));
            if (i < list.size() - 1) {
                result = String.valueOf(result) + ",";
            }
            ++i;
        }
        result = String.valueOf(result) + "}";
        return result;
    }

    protected static String failure2string(Failure failure) {
        return failure.getId();
    }

    @Operation(contextual=true)
    public static boolean blackboxApplyStereotype(Element element, String stereotypeQName) {
        Stereotype stereotype = element.getApplicableStereotype(stereotypeQName);
        EObject returnValue = null;
        if (stereotype != null) {
            returnValue = element.applyStereotype(stereotype);
        }
        return returnValue != null;
    }

    @Operation(contextual=true)
    public static Comment blackboxCreateFptcComment(Element owner, NamedElement annotated, Property partWithPort) {
        Comment comment = owner.createOwnedComment();
        comment.getAnnotatedElements().add((Object)annotated);
        comment.applyStereotype(comment.getApplicableStereotype(FPTC_SPECIFICATION_STEREOTYPE));
        Stereotype s = comment.getAppliedStereotype(FPTC_SPECIFICATION_STEREOTYPE);
        comment.setValue(s, "partWithPort", (Object)partWithPort);
        String commentBody = "FLA: " + UtilitiesLibrary.getName((NamedElement)partWithPort);
        if (partWithPort != annotated) {
            commentBody = String.valueOf(commentBody) + "." + UtilitiesLibrary.getName(annotated);
        }
        comment.setBody(commentBody);
        return comment;
    }

    protected static String getName(NamedElement element) {
        if (element != null && element.getName() != null) {
            return element.getName();
        }
        return "";
    }
}

