/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.chess.cleanCExporter.ui.services;

import eu.fbk.eclipse.standardtools.StateMachineTranslatorToCleanC.core.services.CleanCTranslatorServiceAPI;
import eu.fbk.eclipse.standardtools.utils.core.model.AbstractStateMachineModel;
import eu.fbk.eclipse.standardtools.utils.core.model.AbstractSystemModel;
import eu.fbk.eclipse.standardtools.utils.ui.utils.DialogUtil;
import java.io.File;
import java.util.HashMap;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.papyrus.uml.tools.model.UmlModel;
import org.eclipse.uml2.uml.Class;
import org.polarsys.chess.service.core.model.ChessSystemModel;
import org.polarsys.chess.service.core.model.UMLStateMachineModel;

public class CleanCExportServiceUI {
    private static final Logger logger = Logger.getLogger(CleanCExportServiceUI.class);
    private static CleanCExportServiceUI instance;
    private ChessSystemModel chessSystemModel = ChessSystemModel.getInstance();
    private CleanCTranslatorServiceAPI cleanCTranslatorServiceAPI = CleanCTranslatorServiceAPI.getInstance((AbstractSystemModel)this.chessSystemModel, (AbstractStateMachineModel)UMLStateMachineModel.getInstance());
    private DialogUtil dialogUtil = DialogUtil.getInstance();

    public static CleanCExportServiceUI getInstance() {
        if (instance == null) {
            instance = new CleanCExportServiceUI();
        }
        return instance;
    }

    public void exportAllNominalStateMachinesOfTheModel(UmlModel umlModel, String selectedDirectory, boolean showPopups, IProgressMonitor monitor) throws Exception {
        logger.debug((Object)("umlModel: " + umlModel));
        this.cleanCTranslatorServiceAPI.exportAllNominalStateMachinesOfTheModel((Object)umlModel, selectedDirectory, null, monitor);
        if (showPopups) {
            this.dialogUtil.showMessage_ExportNominalStateMachinesDone(selectedDirectory);
        }
    }

    public void exportNominalStateMachines(Class umlSelectedComponent, String selectedDirectory, boolean showPopups, IProgressMonitor monitor) throws Exception {
        this.cleanCTranslatorServiceAPI.exportNominalStateMachines((Object)umlSelectedComponent, selectedDirectory, null, monitor);
        if (showPopups) {
            this.dialogUtil.showMessage_ExportNominalStateMachinesDone(selectedDirectory);
        }
    }

    public String exportSingleCleanC(Class umlSelectedComponent, boolean showPopups, String selectedDirectory, IProgressMonitor monitor) throws Exception {
        File cFile = this.cleanCTranslatorServiceAPI.exportStateMachineOfComponentToCleanCFile((Object)umlSelectedComponent, showPopups, selectedDirectory, monitor);
        if (showPopups) {
            this.dialogUtil.showMessage_ExportBehaviourDone(cFile.getAbsolutePath(), "c");
        }
        return cFile.getPath();
    }

    public HashMap<String, String> exportCleanC(Class umlSelectedComponent, boolean showPopups, String selectedDirectory, IProgressMonitor monitor) throws Exception {
        HashMap mapCFile_ComponentName = this.cleanCTranslatorServiceAPI.exportAllStateMachinesToCleanCFiles((Object)umlSelectedComponent, selectedDirectory, monitor);
        logger.debug((Object)"exportCleanC done");
        if (showPopups) {
            this.dialogUtil.showMessage_ExportBehaviourDone(selectedDirectory, "c");
        }
        return mapCFile_ComponentName;
    }

    public boolean isLeafComponent(Class umlSelectedComponent) {
        EList subComponents = this.chessSystemModel.getSubComponentsInstances((Object)umlSelectedComponent);
        return subComponents == null || subComponents.size() == 0;
    }
}

