/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.profile.validation;

import java.util.Collection;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.ui.dialogs.DiagnosticDialog;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.uml2.uml.Profile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProfileValidationHelper {
    public static final String PROFILE_APPLICATION = "org.eclipse.papyrus.uml.profile.application";
    public static final int PROFILE_NOT_DEFINED = 1;

    public static boolean checkApplicableProfiles(Shell shell, Collection<Profile> profiles) {
        Diagnostic diagnostic = ProfileValidationHelper.validateApplicableProfiles(profiles);
        if (diagnostic != null && diagnostic.getSeverity() == 4) {
            DiagnosticDialog.openProblem((Shell)shell, (String)"An error occurred during profile application", null, (Diagnostic)diagnostic);
            return false;
        }
        return true;
    }

    public static Diagnostic validateApplicableProfiles(Collection<Profile> profilesToValidate) {
        if (profilesToValidate.isEmpty()) {
            return null;
        }
        BasicDiagnostic diagnostic = new BasicDiagnostic(0, PROFILE_APPLICATION, 0, "The following errors prevent the profile application:", new Object[0]);
        for (Profile profile : profilesToValidate) {
            ProfileValidationHelper.validateApplicableProfile(profile, diagnostic);
        }
        if (diagnostic.getChildren().size() == 1) {
            return (Diagnostic)diagnostic.getChildren().get(0);
        }
        return diagnostic;
    }

    public static void validateApplicableProfile(Profile profile, BasicDiagnostic diagnostic) {
        if (profile != null) {
            EPackage definitionPackage = profile.getDefinition();
            if (definitionPackage == null) {
                String message = String.format("The profile %s is not defined", profile.getQualifiedName());
                BasicDiagnostic basicDiagnostic = new BasicDiagnostic(4, PROFILE_APPLICATION, 1, message, new Object[]{profile});
                diagnostic.merge((Diagnostic)basicDiagnostic);
                return;
            }
            EditingDomain domain = EMFHelper.resolveEditingDomain((EObject)profile);
            AdapterFactory adapterFactory = domain instanceof AdapterFactoryEditingDomain ? ((AdapterFactoryEditingDomain)domain).getAdapterFactory() : null;
            Diagnostician diagnostician = ProfileValidationHelper.createDiagnostician(adapterFactory, (IProgressMonitor)new NullProgressMonitor());
            Map context = diagnostician.createDefaultContext();
            diagnostician.validate((EObject)definitionPackage, (DiagnosticChain)diagnostic, context);
        }
    }

    static Diagnostician createDiagnostician(final AdapterFactory adapterFactory, final IProgressMonitor progressMonitor) {
        return new Diagnostician(){

            public String getObjectLabel(EObject eObject) {
                IItemLabelProvider itemLabelProvider;
                if (adapterFactory != null && !eObject.eIsProxy() && (itemLabelProvider = (IItemLabelProvider)adapterFactory.adapt((Notifier)eObject, IItemLabelProvider.class)) != null) {
                    return itemLabelProvider.getText((Object)eObject);
                }
                return super.getObjectLabel(eObject);
            }

            public boolean validate(EClass eClass, EObject eObject, DiagnosticChain diagnostics, Map<Object, Object> context) {
                progressMonitor.worked(1);
                return super.validate(eClass, eObject, diagnostics, context);
            }
        };
    }
}

